/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.client.audio;

import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.world.FarlandersDimensions;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FarlandersMusicTicker
implements ITickable {
    private final Random rand = new Random();
    private final Minecraft mc;
    public ISound ambientMusic;
    public ISound bossMusic;
    public ISound playingRecord;
    private int timeUntilNextMusic = 100;

    public FarlandersMusicTicker(Minecraft mcIn) {
        this.mc = mcIn;
    }

    public void func_110550_d() {
        TrackType tracktypeB = this.getRandomTrackNightfall();
        if (this.mc.field_71439_g != null && !this.mc.func_147118_V().func_215294_c(this.playingRecord)) {
            if (this.mc.field_71439_g.field_71093_bK == FarlandersDimensions.nightfallType()) {
                if (this.ambientMusic != null && !this.mc.func_147118_V().func_215294_c(this.ambientMusic)) {
                    this.ambientMusic = null;
                    this.timeUntilNextMusic = Math.min(MathHelper.func_76136_a((Random)this.rand, (int)tracktypeB.getMinDelay(), (int)tracktypeB.getMaxDelay()), this.timeUntilNextMusic);
                }
                this.timeUntilNextMusic = Math.min(this.timeUntilNextMusic, tracktypeB.getMaxDelay());
                if (this.ambientMusic == null && this.timeUntilNextMusic-- <= 0) {
                    this.playMusic(tracktypeB);
                }
            }
        } else {
            this.stopMusic();
        }
    }

    public boolean playingMusic() {
        return this.ambientMusic != null;
    }

    public boolean playingRecord() {
        return this.playingRecord != null;
    }

    public TrackType getRandomTrackNightfall() {
        return TrackType.NIGHTFALL;
    }

    public void playMusic(TrackType requestedMusicType) {
        this.ambientMusic = SimpleSound.func_184370_a((SoundEvent)requestedMusicType.getMusicLocation());
        this.mc.func_147118_V().func_147682_a(this.ambientMusic);
        this.timeUntilNextMusic = Integer.MAX_VALUE;
    }

    public void stopMusic() {
        if (this.ambientMusic != null) {
            this.mc.func_147118_V().func_147683_b(this.ambientMusic);
            this.ambientMusic = null;
            this.timeUntilNextMusic = 0;
        }
    }

    public void playBossMusic(TrackType requestedMusicType) {
        this.bossMusic = SimpleSound.func_184370_a((SoundEvent)requestedMusicType.getMusicLocation());
        this.mc.func_147118_V().func_147682_a(this.bossMusic);
        this.timeUntilNextMusic = Integer.MAX_VALUE;
    }

    public void stopBossMusic() {
        if (this.bossMusic != null) {
            this.mc.func_147118_V().func_147683_b(this.bossMusic);
            this.bossMusic = null;
            this.timeUntilNextMusic = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum TrackType {
        NIGHTFALL(FarlandersSounds.MUSIC_NIGHTFALL_AMBIENT, 1200, 1500);

        private final SoundEvent musicLocation;
        private final int minDelay;
        private final int maxDelay;

        private TrackType(SoundEvent musicLocationIn, int minDelayIn, int maxDelayIn) {
            this.musicLocation = musicLocationIn;
            this.minDelay = minDelayIn;
            this.maxDelay = maxDelayIn;
        }

        public SoundEvent getMusicLocation() {
            return this.musicLocation;
        }

        public int getMinDelay() {
            return this.minDelay;
        }

        public int getMaxDelay() {
            return this.maxDelay;
        }
    }
}

