/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity;

import com.legacy.farlanders.block.FarlandersBlocks;
import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.FarlandersEntityTypes;
import com.legacy.farlanders.entity.ai.FarlanderLocateHomeGoal;
import com.legacy.farlanders.entity.hostile.LooterEntity;
import com.legacy.farlanders.entity.hostile.RebelEntity;
import com.legacy.farlanders.entity.hostile.boss.EnderColossusEntity;
import com.legacy.farlanders.entity.util.FarlanderTrades;
import com.legacy.farlanders.entity.util.IColoredEyes;
import com.legacy.farlanders.item.FarlandersItems;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtCustomerGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.RestrictSunGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class FarlanderEntity
extends AbstractVillagerEntity
implements IColoredEyes {
    public static final DataParameter<Integer> EYE_COLOR = EntityDataManager.func_187226_a(FarlanderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(FarlanderEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int particleEffect;
    private int xp;
    private int timeUntilReset;
    private int field_223725_bO;
    private long lastRestock;
    private long field_223726_bP;
    private PlayerEntity field_213778_bG;
    private boolean customer;
    private BlockPos homePos;

    public FarlanderEntity(EntityType<? extends FarlanderEntity> type, World world) {
        super(type, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new FarlanderLocateHomeGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, LooterEntity.class, 8.0f, 0.7, 0.8));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, RebelEntity.class, 8.0f, 0.7, 0.8));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, ZombieEntity.class, 8.0f, 0.7, 0.8));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, EnderColossusEntity.class, 8.0f, 0.5, 0.8));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtCustomerGoal((AbstractVillagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RestrictSunGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 0.6, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{FarlandersBlocks.endumium_block.func_199767_j()}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.75f : 1.6f;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)this.field_70146_Z.nextInt(6));
        this.field_70180_af.func_187214_a(LEVEL, (Object)1);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("EyeColor", this.getEyeColor());
        compound.func_74768_a("Xp", this.xp);
        compound.func_74768_a("Level", this.getLevel());
        if (this.homePos != null) {
            compound.func_218657_a("HomePosition", (INBT)NBTUtil.func_186859_a((BlockPos)this.homePos));
        }
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setEyeColor(compound.func_74762_e("EyeColor"));
        this.setLevel(compound.func_74762_e("Level"));
        if (compound.func_150297_b("Offers", 10)) {
            this.field_213724_bz = new MerchantOffers(compound.func_74775_l("Offers"));
        }
        if (compound.func_150297_b("Xp", 3)) {
            this.xp = compound.func_74762_e("Xp");
        }
        if (compound.func_74764_b("HomePosition")) {
            this.homePos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("HomePosition"));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_82737_E() % 6000L == 0L && this.field_70170_p.func_72935_r() && this.func_223721_ek()) {
            this.func_213766_ei();
        }
        if (this.func_203005_aq()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.getClass() == FarlanderEntity.class) {
            if (this.getEyeColor() == 0) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
            } else if (this.getEyeColor() == 1) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
            } else if (this.getEyeColor() == 2) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            } else if (this.getEyeColor() == 3) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197596_G, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
            } else if (this.getEyeColor() == 4) {
                ++this.particleEffect;
                if (this.particleEffect == 3) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                    this.particleEffect = 0;
                }
            } else if (this.getEyeColor() == 5) {
                ++this.particleEffect;
                if (this.particleEffect == 1) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.5 + this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                    this.particleEffect = 0;
                }
            }
        }
    }

    protected void func_70619_bc() {
        float bedRadius;
        if (!this.func_213716_dX() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.customer) {
                    this.populateBuyingList();
                    this.customer = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        float f = bedRadius = this.field_70170_p.func_72935_r() || this.field_70170_p.func_72896_J() ? 10.0f : 20.0f;
        if (this.getHomePos() != null) {
            if (this.getPosDistance(this.getHomePos().func_177958_n(), this.getHomePos().func_177956_o(), this.getHomePos().func_177952_p()) > bedRadius || (this.field_70170_p.func_72935_r() || this.field_70170_p.func_72896_J()) && this.field_70170_p.func_175710_j(this.func_180425_c())) {
                this.field_70699_by.func_75492_a((double)this.getHomePos().func_177958_n(), (double)this.getHomePos().func_177956_o(), (double)this.getHomePos().func_177952_p(), (double)0.7f);
            }
            if (this.field_70173_aa % 200 == 0 && (!(this.field_70170_p.func_180495_p(this.getHomePos()).func_177230_c() instanceof BedBlock) || this.getPosDistance(this.getHomePos().func_177958_n(), this.getHomePos().func_177956_o(), this.getHomePos().func_177952_p()) > 35.0f)) {
                this.setHomePos(null);
            }
        }
        super.func_70619_bc();
    }

    private void func_223718_eH() {
        this.func_223719_ex();
        this.field_223725_bO = 0;
    }

    public boolean func_223721_ek() {
        long i = this.lastRestock + 12000L;
        boolean flag = this.field_70170_p.func_82737_E() > i;
        long j = this.field_70170_p.func_72820_D();
        if (this.field_223726_bP > 0L) {
            long l = j / 24000L;
            long k = this.field_223726_bP / 24000L;
            flag |= l > k;
        }
        this.field_223726_bP = j;
        if (flag) {
            this.func_223718_eH();
        }
        return this.func_223720_ew() && this.func_223723_ev();
    }

    public void func_213766_ei() {
        this.func_223715_ey();
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222203_h();
        }
        ++this.field_223725_bO;
    }

    private boolean func_223723_ev() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            if (!merchantoffer.func_222217_o()) continue;
            return true;
        }
        return false;
    }

    private boolean func_223720_ew() {
        return this.field_223725_bO < 2 && this.field_70170_p.func_82737_E() > this.lastRestock + 2400L;
    }

    private void func_223719_ex() {
        int i = 2 - this.field_223725_bO;
        if (i > 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222203_h();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.func_223715_ey();
        }
    }

    private void func_223715_ey() {
        for (MerchantOffer merchantoffer : this.func_213706_dY()) {
            merchantoffer.func_222222_e();
        }
    }

    @Override
    public void setEyeColor(int colorID) {
        this.field_70180_af.func_187227_b(EYE_COLOR, (Object)colorID);
    }

    @Override
    public int getEyeColor() {
        return (Integer)this.field_70180_af.func_187225_a(EYE_COLOR);
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_FARLANDER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FarlandersSounds.ENTITY_FARLANDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FarlandersSounds.ENTITY_FARLANDER_DEATH;
    }

    public FarlanderEntity createChild(AgeableEntity ageable) {
        return (FarlanderEntity)FarlandersEntityTypes.FARLANDER.func_200721_a(this.field_70170_p);
    }

    public SoundEvent func_213714_ea() {
        this.func_184185_a(FarlandersSounds.ENTITY_FARLANDER_IDLE, this.func_70599_aP(), 1.3f);
        return null;
    }

    protected SoundEvent func_213721_r(boolean positive) {
        if (positive) {
            this.func_184185_a(FarlandersSounds.ENTITY_FARLANDER_IDLE, this.func_70599_aP(), 1.3f);
        } else {
            this.func_184185_a(FarlandersSounds.ENTITY_FARLANDER_IDLE, this.func_70599_aP(), 0.7f);
        }
        return null;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (flag) {
            itemstack.func_111282_a(player, (LivingEntity)this, hand);
            return true;
        }
        if (itemstack.func_77973_b() != FarlandersItems.farlander_spawn_egg && this.func_70089_S() && !this.func_213716_dX() && !this.func_70631_g_()) {
            if (hand == Hand.MAIN_HAND) {
                player.func_195066_a(Stats.field_188074_H);
            }
            if (this.func_213706_dY().isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                this.func_213707_a(player, this.func_145748_c_(), this.getLevel());
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private void populateBuyingList() {
        this.setLevel(this.getLevel() + 1);
        this.func_213712_ef();
    }

    protected void func_213713_b(MerchantOffer offer) {
        int i = 3 + this.field_70146_Z.nextInt(4);
        this.xp += offer.func_222210_n();
        this.field_213778_bG = this.func_70931_l_();
        if (this.func_213741_eu()) {
            this.timeUntilReset = 40;
            this.customer = true;
            i += 5;
        }
        if (offer.func_222221_q()) {
            this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), i));
        }
    }

    protected void func_213712_ef() {
        VillagerTrades.ITrade[] avillagertrades$itrade = (VillagerTrades.ITrade[])FarlanderTrades.farlanderTrades.get(this.getLevel());
        if (avillagertrades$itrade != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.func_213717_a(merchantoffers, avillagertrades$itrade, 2);
        }
    }

    private boolean func_213741_eu() {
        int i = this.getLevel();
        return VillagerData.func_221128_d((int)i) && this.xp >= VillagerData.func_221127_c((int)i);
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)level);
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL);
    }

    public int func_213708_dV() {
        return this.xp;
    }

    public void setXp(int amount) {
        this.xp = amount;
    }

    public void setHomePos(@Nullable BlockPos pos) {
        this.homePos = pos;
    }

    @Nullable
    public BlockPos getHomePos() {
        return this.homePos;
    }

    public float getPosDistance(double x, double y, double z) {
        float f = (float)(this.func_226277_ct_() - x);
        float f1 = (float)(this.func_226278_cu_() - y);
        float f2 = (float)(this.func_226281_cx_() - z);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }
}

