/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.hostile;

import com.legacy.farlanders.FarlandersConfig;
import com.legacy.farlanders.client.audio.FarlandersSounds;
import com.legacy.farlanders.entity.ElderFarlanderEntity;
import com.legacy.farlanders.entity.FarlanderEntity;
import com.legacy.farlanders.entity.WandererEntity;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.entity.util.IColoredEyes;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LooterEntity
extends MonsterEntity
implements IColoredEyes {
    public static final DataParameter<Integer> EYE_COLOR = EntityDataManager.func_187226_a(LooterEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private boolean hasSword;
    private int particleEffect;

    public LooterEntity(EntityType<? extends LooterEntity> type, World world) {
        super(type, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.6f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.65, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, FarlanderEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ElderFarlanderEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WandererEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EnderGolemEntity.class, false));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EYE_COLOR, (Object)this.field_70146_Z.nextInt(6));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("EyeColor", this.getEyeColor());
        compound.func_74757_a("HasSword", this.getHasSword());
    }

    public void func_70020_e(CompoundNBT compound) {
        super.func_70020_e(compound);
        this.setEyeColor(compound.func_74762_e("EyeColor"));
        this.setHasSword(compound.func_74767_n("HasSword"));
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (((Boolean)FarlandersConfig.COMMON.disableLooterStealing.get()).booleanValue()) {
            int rand = worldIn.func_201674_k().nextInt(7);
            Item randomWeapon = rand == 0 ? Items.field_151036_c : (rand == 1 ? Items.field_151052_q : (rand == 2 ? Items.field_151049_t : (rand == 3 ? Items.field_151048_u : (rand == 4 ? Items.field_151010_B : (rand == 5 ? Items.field_151006_E : Items.field_151040_l)))));
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)randomWeapon));
            this.setHasSword(true);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!((Boolean)FarlandersConfig.COMMON.disableLooterStealing.get()).booleanValue()) {
            this.func_199701_a_(this.func_184614_ca());
        }
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        if (!((Boolean)FarlandersConfig.COMMON.disableLooterStealing.get()).booleanValue() && this.getHasSword()) {
            return false;
        }
        return super.func_213397_c(distanceToClosestPlayer);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_203005_aq()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.func_184614_ca() != ItemStack.field_190927_a) {
            if (this.getEyeColor() == 0) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
            } else if (this.getEyeColor() == 1) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
            } else if (this.getEyeColor() == 2) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
            } else if (this.getEyeColor() == 3) {
                for (int k = 0; k < 2; ++k) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197596_G, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                }
            } else if (this.getEyeColor() == 4) {
                ++this.particleEffect;
                if (this.particleEffect == 3) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                    this.particleEffect = 0;
                }
            } else if (this.getEyeColor() == 5) {
                ++this.particleEffect;
                if (this.particleEffect == 1) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.5 + this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
                    this.particleEffect = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_70097_a(DamageSource source, float par2) {
        if (source.func_76364_f() instanceof PlayerEntity && !source.func_180136_u() && !((Boolean)FarlandersConfig.COMMON.disableLooterStealing.get()).booleanValue()) {
            PlayerEntity player = (PlayerEntity)source.func_76364_f();
            if (!this.getHasSword() && player.field_71071_by.func_70448_g() != null && (player.field_71071_by.func_70448_g().func_77973_b() instanceof SwordItem || player.field_71071_by.func_70448_g().func_77973_b() instanceof AxeItem)) {
                ItemStack copy = player.func_184614_ca().func_77946_l();
                this.func_184201_a(EquipmentSlotType.MAINHAND, copy);
                player.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                this.setHasSword(true);
                this.field_70170_p.func_184133_a(player, this.func_180425_c(), SoundEvents.field_187665_Y, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.field_70170_p.func_184133_a(player, this.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.HOSTILE, 1.0f, 1.0f);
                ItemStack var2 = this.func_184586_b(Hand.MAIN_HAND);
                double var3 = 1.5;
                try {
                    var3 += (double)((SwordItem)var2.func_77973_b()).func_200894_d();
                }
                catch (Exception e) {
                    var3 = 3.0;
                }
                finally {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(var3);
                }
            }
        }
        return super.func_70097_a(source, par2);
    }

    public boolean getHasSword() {
        return this.hasSword;
    }

    public void setHasSword(boolean hasSword) {
        this.hasSword = hasSword;
    }

    @Override
    public void setEyeColor(int colorID) {
        this.field_70180_af.func_187227_b(EYE_COLOR, (Object)colorID);
    }

    @Override
    public int getEyeColor() {
        return (Integer)this.field_70180_af.func_187225_a(EYE_COLOR);
    }

    protected SoundEvent func_184639_G() {
        return FarlandersSounds.ENTITY_FARLANDER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FarlandersSounds.ENTITY_FARLANDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FarlandersSounds.ENTITY_FARLANDER_DEATH;
    }
}

