/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.entity.hostile.boss.summon;

import com.legacy.farlanders.entity.hostile.boss.EnderColossusEntity;
import com.legacy.farlanders.entity.hostile.boss.summon.EnderColossusShadowEntity;
import com.legacy.farlanders.entity.util.MiniDragonPartEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public class MiniDragonEntity
extends MobEntity
implements IMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    public double targetX;
    public double targetY;
    public double targetZ;
    public double[][] ringBuffer = new double[64][3];
    public int ringBufferIndex = -1;
    public MiniDragonPartEntity[] dragonPartArray;
    public MiniDragonPartEntity dragonPartHead;
    public MiniDragonPartEntity dragonPartBody;
    public MiniDragonPartEntity dragonPartTail1;
    public MiniDragonPartEntity dragonPartTail2;
    public MiniDragonPartEntity dragonPartTail3;
    public MiniDragonPartEntity dragonPartWing1;
    public MiniDragonPartEntity dragonPartWing2;
    public float prevAnimTime;
    public float animTime;
    public boolean forceNewTarget;
    public boolean slowed;
    private Entity target;
    public int deathTicks;
    private boolean shotFireball = false;
    private float randomYawVelocity;
    public double field_70165_t = this.func_226277_ct_();
    public double field_70163_u = this.func_226278_cu_();
    public double field_70161_v = this.func_226281_cx_();

    public MiniDragonEntity(EntityType<? extends MiniDragonEntity> type, World world) {
        super(type, world);
        this.dragonPartHead = new MiniDragonPartEntity(this, "head", 6.0f, 6.0f);
        this.dragonPartBody = new MiniDragonPartEntity(this, "body", 8.0f, 8.0f);
        this.dragonPartTail1 = new MiniDragonPartEntity(this, "tail", 4.0f, 4.0f);
        this.dragonPartTail2 = new MiniDragonPartEntity(this, "tail", 4.0f, 4.0f);
        this.dragonPartTail3 = new MiniDragonPartEntity(this, "tail", 4.0f, 4.0f);
        this.dragonPartWing1 = new MiniDragonPartEntity(this, "wing", 4.0f, 4.0f);
        this.dragonPartWing2 = new MiniDragonPartEntity(this, "wing", 4.0f, 4.0f);
        this.dragonPartArray = new MiniDragonPartEntity[]{this.dragonPartHead, this.dragonPartBody, this.dragonPartTail1, this.dragonPartTail2, this.dragonPartTail3, this.dragonPartWing1, this.dragonPartWing2};
        this.func_70606_j(this.func_110138_aP());
        this.field_70145_X = false;
        this.targetY = 100.0;
        this.field_70158_ak = true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public double[] getMovementOffsets(int p_70974_1_, float p_70974_2_) {
        if (this.func_110143_aJ() <= 0.0f) {
            p_70974_2_ = 0.0f;
        }
        p_70974_2_ = 1.0f - p_70974_2_;
        int j = this.ringBufferIndex - p_70974_1_ * 1 & 0x3F;
        int k = this.ringBufferIndex - p_70974_1_ * 1 - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[j][0];
        double d1 = MathHelper.func_76138_g((double)(this.ringBuffer[k][0] - d0));
        adouble[0] = d0 + d1 * (double)p_70974_2_;
        d0 = this.ringBuffer[j][1];
        d1 = this.ringBuffer[k][1] - d0;
        adouble[1] = d0 + d1 * (double)p_70974_2_;
        adouble[2] = this.ringBuffer[j][2] + (this.ringBuffer[k][2] - this.ringBuffer[j][2]) * (double)p_70974_2_;
        return adouble;
    }

    public void func_70636_d() {
        if (!this.func_175446_cd()) {
            float f1;
            float f;
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            if (this.field_70170_p.field_72995_K) {
                f = MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f));
                f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
                if (f1 <= -0.3f && f >= -0.3f) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187524_aN, SoundCategory.HOSTILE, 3.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.3f, false);
                }
            }
            this.prevAnimTime = this.animTime;
            if (this.func_110143_aJ() <= 0.0f) {
                f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
                f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
                for (int i = 0; i < 3; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                Vec3d vec3d4 = this.func_213322_ci();
                float f12 = 0.2f / (MathHelper.func_76133_a((double)MiniDragonEntity.func_213296_b((Vec3d)vec3d4)) * 10.0f + 1.0f);
                this.animTime = this.slowed ? (this.animTime += f12 * 0.5f) : (this.animTime += (f12 *= (float)Math.pow(2.0, vec3d4.field_72448_b)));
                this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                if (this.func_175446_cd()) {
                    this.animTime = 0.5f;
                } else {
                    if (this.ringBufferIndex < 0) {
                        for (int i = 0; i < this.ringBuffer.length; ++i) {
                            this.ringBuffer[i][0] = this.field_70177_z;
                            this.ringBuffer[i][1] = this.field_70163_u;
                        }
                    }
                    if (++this.ringBufferIndex == this.ringBuffer.length) {
                        this.ringBufferIndex = 0;
                    }
                    this.ringBuffer[this.ringBufferIndex][0] = this.field_70177_z;
                    this.ringBuffer[this.ringBufferIndex][1] = this.field_70163_u;
                    if (this.field_70170_p.field_72995_K) {
                        if (this.field_70716_bi > 0) {
                            double d7 = this.field_70165_t + (this.field_184623_bh - this.field_70165_t) / (double)this.field_70716_bi;
                            double d0 = this.field_70163_u + (this.field_184624_bi - this.field_70163_u) / (double)this.field_70716_bi;
                            double d1 = this.field_70161_v + (this.field_184625_bj - this.field_70161_v) / (double)this.field_70716_bi;
                            double d2 = MathHelper.func_76138_g((double)(this.field_184626_bk - (double)this.field_70177_z));
                            this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70709_bj - (double)this.field_70125_A) / (double)this.field_70716_bi);
                            --this.field_70716_bi;
                            this.func_70107_b(d7, d0, d1);
                            this.func_70101_b(this.field_70177_z, this.field_70125_A);
                        }
                    } else {
                        Vec3d vec3d = new Vec3d(this.targetX, this.targetY, this.targetZ);
                        double d8 = vec3d.field_72450_a - this.field_70165_t;
                        double d9 = vec3d.field_72448_b - this.field_70163_u;
                        double d10 = vec3d.field_72449_c - this.field_70161_v;
                        double d3 = d8 * d8 + d9 * d9 + d10 * d10;
                        float f5 = 10.0f;
                        double d4 = MathHelper.func_76133_a((double)(d8 * d8 + d10 * d10));
                        if (d4 > 0.0) {
                            d9 = MathHelper.func_151237_a((double)(d9 / d4), (double)(-f5), (double)f5);
                        }
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, d9 * 0.01, 0.0));
                        this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
                        double d5 = MathHelper.func_151237_a((double)MathHelper.func_76138_g((double)(180.0 - MathHelper.func_181159_b((double)d8, (double)d10) * 57.2957763671875 - (double)this.field_70177_z)), (double)-50.0, (double)50.0);
                        Vec3d vec3d1 = vec3d.func_178786_a(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72432_b();
                        Vec3d vec3d2 = new Vec3d((double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), this.func_213322_ci().field_72448_b, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))))).func_72432_b();
                        float f8 = Math.max(((float)vec3d2.func_72430_b(vec3d1) + 0.5f) / 1.5f, 0.0f);
                        this.randomYawVelocity *= 0.8f;
                        this.randomYawVelocity = (float)((double)this.randomYawVelocity + d5);
                        this.field_70177_z += this.randomYawVelocity * 0.1f;
                        float f9 = (float)(2.0 / (d3 + 1.0));
                        this.func_213309_a(0.06f * (f8 * f9 + (1.0f - f9)), new Vec3d(0.0, 0.0, -1.0));
                        if (this.slowed) {
                            this.func_213315_a(MoverType.SELF, this.func_213322_ci().func_186678_a((double)0.8f));
                        } else {
                            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                        }
                        Vec3d vec3d3 = this.func_213322_ci().func_72432_b();
                        double d6 = 0.8 + 0.15 * (vec3d3.func_72430_b(vec3d2) + 1.0) / 2.0;
                        this.func_213317_d(this.func_213322_ci().func_216372_d(d6, (double)0.91f, d6));
                        if (this.target != null) {
                            this.targetX = this.target.func_226277_ct_();
                            this.targetZ = this.target.func_226281_cx_();
                            double d32 = this.targetX - this.field_70165_t;
                            double d52 = this.targetZ - this.field_70161_v;
                            double d7 = Math.sqrt(d32 * d32 + d52 * d52);
                            double d82 = (double)0.4f + d7 / 80.0 - 1.0;
                            if (d82 > 10.0) {
                                d82 = 10.0;
                            }
                            this.targetY = this.target.func_174813_aQ().field_72338_b + d82;
                        } else {
                            this.targetX += this.field_70146_Z.nextGaussian() * 2.0;
                            this.targetZ += this.field_70146_Z.nextGaussian() * 2.0;
                        }
                        double d102 = this.targetX - this.field_70165_t;
                        double d0 = this.targetY - this.field_70163_u;
                        double d1 = this.targetZ - this.field_70161_v;
                        double d2 = d102 * d102 + d0 * d0 + d1 * d1;
                        if (this.forceNewTarget || d2 < 100.0 || d2 > 22500.0 || this.field_70123_F || this.field_70124_G) {
                            this.setNewTarget();
                        }
                    }
                    this.field_70761_aq = this.field_70177_z;
                    Vec3d[] avec3d = new Vec3d[this.dragonPartArray.length];
                    for (int j = 0; j < this.dragonPartArray.length; ++j) {
                        avec3d[j] = new Vec3d(this.dragonPartArray[j].func_226277_ct_(), this.dragonPartArray[j].func_226278_cu_(), this.dragonPartArray[j].func_226281_cx_());
                    }
                    float f15 = (float)(this.getMovementOffsets(5, 1.0f)[1] - this.getMovementOffsets(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                    float f16 = MathHelper.func_76134_b((float)f15);
                    float f21 = MathHelper.func_76126_a((float)f15);
                    float f17 = this.field_70177_z * ((float)Math.PI / 180);
                    float f3 = MathHelper.func_76126_a((float)f17);
                    float f18 = MathHelper.func_76134_b((float)f17);
                    this.dragonPartBody.func_70071_h_();
                    this.dragonPartBody.func_70012_b(this.field_70165_t + (double)(f3 * 0.5f), this.field_70163_u, this.field_70161_v - (double)(f18 * 0.5f), 0.0f, 0.0f);
                    this.dragonPartWing1.func_70071_h_();
                    this.dragonPartWing1.func_70012_b(this.field_70165_t + (double)(f18 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v + (double)(f3 * 4.5f), 0.0f, 0.0f);
                    this.dragonPartWing2.func_70071_h_();
                    this.dragonPartWing2.func_70012_b(this.field_70165_t - (double)(f18 * 4.5f), this.field_70163_u + 2.0, this.field_70161_v - (double)(f3 * 4.5f), 0.0f, 0.0f);
                    if (!this.field_70170_p.field_72995_K && this.field_70737_aN == 0) {
                        this.collideWithEntities(this.field_70170_p.func_175674_a((Entity)this, this.dragonPartWing1.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d));
                        this.collideWithEntities(this.field_70170_p.func_175674_a((Entity)this, this.dragonPartWing2.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0).func_72317_d(0.0, -2.0, 0.0), EntityPredicates.field_188444_d));
                        this.attackEntitiesInList(this.field_70170_p.func_175674_a((Entity)this, this.dragonPartHead.func_174813_aQ().func_186662_g(1.0), EntityPredicates.field_188444_d));
                    }
                    double[] adouble = this.getMovementOffsets(5, 1.0f);
                    float f19 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180) - this.randomYawVelocity * 0.01f));
                    float f4 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180) - this.randomYawVelocity * 0.01f));
                    this.dragonPartHead.func_70071_h_();
                    float f20 = 0.0f;
                    this.dragonPartHead.func_70012_b(this.field_70165_t + (double)(f19 * 6.5f * f16), this.field_70163_u + (double)f20 + (double)(f21 * 6.5f), this.field_70161_v - (double)(f4 * 6.5f * f16), 0.0f, 0.0f);
                    for (int k = 0; k < 3; ++k) {
                        MiniDragonPartEntity enderdragonpartentity = null;
                        if (k == 0) {
                            enderdragonpartentity = this.dragonPartTail1;
                        }
                        if (k == 1) {
                            enderdragonpartentity = this.dragonPartTail2;
                        }
                        if (k == 2) {
                            enderdragonpartentity = this.dragonPartTail3;
                        }
                        double[] adouble1 = this.getMovementOffsets(12 + k * 2, 1.0f);
                        float f6 = MathHelper.func_76126_a((float)f21);
                        float f22 = MathHelper.func_76134_b((float)f21);
                        float f23 = (float)(k + 1) * 2.0f;
                        enderdragonpartentity.func_70071_h_();
                        enderdragonpartentity.func_70012_b(this.field_70165_t - (double)((f3 * 1.5f + f6 * f23) * f16), this.field_70163_u + (adouble1[1] - adouble[1]) - (double)((f23 + 1.5f) * f21) + 1.5, this.field_70161_v + (double)((f18 * 1.5f + f22 * f23) * f16), 0.0f, 0.0f);
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        this.slowed = this.destroyBlocksInAABB(this.dragonPartHead.func_174813_aQ()) | this.destroyBlocksInAABB(this.dragonPartBody.func_174813_aQ());
                    }
                    for (int l = 0; l < this.dragonPartArray.length; ++l) {
                        this.dragonPartArray[l].field_70169_q = avec3d[l].field_72450_a;
                        this.dragonPartArray[l].field_70167_r = avec3d[l].field_72448_b;
                        this.dragonPartArray[l].field_70166_s = avec3d[l].field_72449_c;
                    }
                }
            }
            if (this.target != null && this.target instanceof PlayerEntity) {
                if (this.target.func_70068_e((Entity)this) < 256.0 && !this.shotFireball) {
                    double d0 = this.target.func_226277_ct_() - this.field_70165_t;
                    double d1 = this.target.func_174813_aQ().field_72338_b + (double)(this.target.func_213302_cg() / 2.0f) - (this.field_70163_u + (double)(this.func_213302_cg() / 2.0f));
                    double d2 = this.target.func_226281_cx_() - this.field_70161_v;
                    double d5 = this.target.func_226277_ct_() - this.field_70165_t;
                    double d6 = this.target.func_174813_aQ().field_72338_b + (double)(this.target.func_213302_cg() / 2.0f) - (this.field_70163_u + (double)(this.func_213302_cg() / 2.0f));
                    double d7 = this.target.func_226281_cx_() - this.field_70161_v;
                    if (this.field_70146_Z.nextInt(15) == 0) {
                        for (int i = 0; i < 3; ++i) {
                            SmallFireballEntity entitysmallfireball = new SmallFireballEntity(this.field_70170_p, (LivingEntity)this, d0 + this.field_70146_Z.nextGaussian() * 0.6, d1, d2 + this.field_70146_Z.nextGaussian() * 0.6);
                            entitysmallfireball.func_70107_b(entitysmallfireball.func_226277_ct_(), this.field_70163_u + (double)(this.func_213302_cg() / 2.0f) - 0.5, entitysmallfireball.func_226281_cx_());
                            this.field_70170_p.func_217376_c((Entity)entitysmallfireball);
                            this.shotFireball = true;
                            this.field_70170_p.func_217378_a((PlayerEntity)null, 1017, new BlockPos((Entity)this), 0);
                        }
                    } else if (this.field_70146_Z.nextInt(10) == 0) {
                        this.field_70170_p.func_217378_a((PlayerEntity)null, 1017, new BlockPos((Entity)this), 0);
                        FireballEntity entitylargefireball = new FireballEntity(this.field_70170_p, (LivingEntity)this, d5, d6, d7);
                        entitylargefireball.func_70107_b(entitylargefireball.func_226277_ct_(), this.field_70163_u + (double)(this.func_213302_cg() / 2.0f) - 0.5, entitylargefireball.func_226281_cx_());
                        this.field_70170_p.func_217376_c((Entity)entitylargefireball);
                        this.shotFireball = true;
                    } else if (this.field_70146_Z.nextInt(5) == 0) {
                        SmallFireballEntity entitysmallfireball = new SmallFireballEntity(this.field_70170_p, (LivingEntity)this, d0 + this.field_70146_Z.nextGaussian() * 0.6, d1, d2 + this.field_70146_Z.nextGaussian() * 0.6);
                        entitysmallfireball.func_70107_b(entitysmallfireball.func_226277_ct_(), this.field_70163_u + (double)(this.func_213302_cg() / 2.0f) - 0.5, entitysmallfireball.func_226281_cx_());
                        this.field_70170_p.func_217376_c((Entity)entitysmallfireball);
                        this.shotFireball = true;
                        this.field_70170_p.func_217378_a((PlayerEntity)null, 1017, new BlockPos((Entity)this), 0);
                    }
                } else if (this.target.func_70068_e((Entity)this) > 256.0) {
                    this.shotFireball = false;
                }
            }
        }
    }

    private void collideWithEntities(List<?> p_70970_1_) {
        double d0 = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
        double d1 = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
        for (Entity entity : p_70970_1_) {
            if (!(entity instanceof LivingEntity) || entity instanceof MiniDragonEntity || entity instanceof EnderColossusEntity || entity instanceof EnderColossusShadowEntity) continue;
            double d2 = entity.func_226277_ct_() - d0;
            double d3 = entity.func_226281_cx_() - d1;
            double d4 = d2 * d2 + d3 * d3;
            entity.func_70024_g(d2 / d4 * 1.1, (double)0.2f, d3 / d4 * 0.7);
        }
    }

    private void attackEntitiesInList(List<?> p_70971_1_) {
        for (int i = 0; i < p_70971_1_.size(); ++i) {
            Entity entity = (Entity)p_70971_1_.get(i);
            if (!(entity instanceof LivingEntity) || entity instanceof MiniDragonEntity || entity instanceof EnderColossusEntity || entity instanceof EnderColossusShadowEntity) continue;
            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 1.0f);
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        if (this.field_70146_Z.nextInt(2) == 0 && !this.field_70170_p.func_217369_A().isEmpty()) {
            this.target = (Entity)this.field_70170_p.func_217369_A().get(this.field_70146_Z.nextInt(this.field_70170_p.func_217369_A().size()));
        } else {
            double d2;
            double d1;
            double d0;
            boolean flag = false;
            do {
                this.targetX = 0.0;
                this.targetY = 70.0f + this.field_70146_Z.nextFloat() * 50.0f;
                this.targetZ = 0.0;
                this.targetX += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
            } while (!(flag = (d0 = this.field_70165_t - this.targetX) * d0 + (d1 = this.field_70163_u - this.targetY) * d1 + (d2 = this.field_70161_v - this.targetZ) * d2 > 100.0));
            this.target = null;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    public boolean func_213403_a(MiniDragonPartEntity p_70965_1_, DamageSource p_70965_2_, float p_70965_3_) {
        if (p_70965_1_ != this.dragonPartHead) {
            p_70965_3_ = p_70965_3_ / 4.0f + 1.0f;
        }
        float f1 = this.field_70177_z * (float)Math.PI / 180.0f;
        float f2 = MathHelper.func_76126_a((float)f1);
        float f3 = MathHelper.func_76134_b((float)f1);
        this.targetX = this.field_70165_t + (double)(f2 * 5.0f) + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f);
        this.targetY = this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.0f) + 1.0;
        this.targetZ = this.field_70161_v - (double)(f3 * 5.0f) + (double)((this.field_70146_Z.nextFloat() - 0.5f) * 2.0f);
        this.target = null;
        if (p_70965_2_.func_76346_g() instanceof PlayerEntity || p_70965_2_.func_94541_c()) {
            this.func_70097_a(p_70965_2_, p_70965_3_);
        }
        return true;
    }

    protected boolean attackDragonFrom(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB p_70972_1_) {
        return false;
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 100 && this.deathTicks <= 150) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K && this.deathTicks == 1) {
            this.func_184185_a(SoundEvents.field_187522_aL, 5.0f, 1.2f);
        }
        this.func_213315_a(MoverType.SELF, new Vec3d(0.0, (double)0.1f, 0.0));
        this.field_70177_z += 20.0f;
        this.field_70761_aq = this.field_70177_z;
        if (this.deathTicks == 150 && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected boolean canDespawn() {
        return false;
    }

    public Entity[] getParts() {
        return this.dragonPartArray;
    }

    public boolean func_70067_L() {
        return true;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187521_aK;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187526_aP;
    }

    protected float func_70599_aP() {
        return 3.0f;
    }

    protected float func_70647_i() {
        return 1.7f;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }
}

