/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.structure;

import com.legacy.farlanders.FarlandersConfig;
import com.legacy.farlanders.TheFarlandersMod;
import com.legacy.farlanders.entity.FarlandersEntityTypes;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.entity.hostile.TitanEntity;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FarlanderLootFeature
extends Feature<NoFeatureConfig> {
    private BlockState replaceID;

    public FarlanderLootFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, BlockState replace) {
        super(configFactoryIn);
        this.replaceID = replace;
    }

    public boolean locationIsValidSpawn(IWorld world, int i, int j, int k) {
        int distanceToAir;
        BlockState checkID = world.func_180495_p(new BlockPos(i, j, k));
        for (distanceToAir = 0; distanceToAir < 255 && checkID != Blocks.field_150350_a.func_176223_P(); ++distanceToAir) {
            checkID = world.func_180495_p(new BlockPos(i, j + distanceToAir, k));
            if (distanceToAir > 100) {
                return false;
            }
            if (distanceToAir >= 0) continue;
            return false;
        }
        if (distanceToAir > 2) {
            return false;
        }
        BlockState blockID = world.func_180495_p(new BlockPos(i, j += distanceToAir - 1, k));
        BlockState blockIDAbove = world.func_180495_p(new BlockPos(i, j + 1, k));
        BlockState blockIDBelow = world.func_180495_p(new BlockPos(i, j - 1, k));
        if (blockIDAbove != Blocks.field_150350_a.func_176223_P()) {
            return false;
        }
        if (blockID.func_177230_c() == Blocks.field_150433_aE && blockIDBelow == this.replaceID || blockID.func_177230_c() == Blocks.field_150349_c && blockIDBelow == this.replaceID || blockID == Blocks.field_196606_bd.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_196605_bc.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_196555_aI.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150434_aF.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150338_P.func_176223_P() && blockIDBelow == this.replaceID || blockID == Blocks.field_150337_Q.func_176223_P() && blockIDBelow == this.replaceID) {
            return true;
        }
        return blockID == this.replaceID;
    }

    public boolean airLocationIsValidSpawn(IWorld world, int i, int j, int k) {
        BlockState blockID = world.func_180495_p(new BlockPos(i, j, k));
        BlockState blockIDAbove = world.func_180495_p(new BlockPos(i, j + 1, k));
        return blockID == Blocks.field_150350_a.func_176223_P() && blockIDAbove == Blocks.field_150350_a.func_176223_P();
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos pos, NoFeatureConfig config) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        int doorSide = random.nextInt(2);
        BlockState whiteStone = Blocks.field_150377_bs.func_176223_P();
        BlockState ironFence = Blocks.field_150411_aY.func_176223_P();
        if (!(this.locationIsValidSpawn(world, i - 1, j, k - 2) && this.locationIsValidSpawn(world, i + 3, j, k - 2) && this.locationIsValidSpawn(world, i + 3, j, k + 2) && this.locationIsValidSpawn(world, i - 1, j, k + 2) && this.airLocationIsValidSpawn(world, i - 1, j + 3, k - 2) && this.airLocationIsValidSpawn(world, i + 3, j + 3, k - 2) && this.airLocationIsValidSpawn(world, i + 3, j + 3, k + 2) && this.airLocationIsValidSpawn(world, i - 1, j + 3, k + 2))) {
            return false;
        }
        if ((Integer)FarlandersConfig.COMMON.farlanderLootWellSpawnRate.get() > 1 && random.nextInt((Integer)FarlandersConfig.COMMON.farlanderLootWellSpawnRate.get()) != 0 || (Integer)FarlandersConfig.COMMON.farlanderLootWellSpawnRate.get() <= 1) {
            return false;
        }
        System.out.println(new BlockPos(i, j, k));
        world.func_180501_a(new BlockPos(i, j, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j + 1, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j + 1, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j + 2, k), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j + 2, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i, j + 2, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k + 1), (BlockState)((BlockState)ironFence.func_206870_a((IProperty)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 1, k - 1), (BlockState)((BlockState)ironFence.func_206870_a((IProperty)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 2, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 1, j + 3, k), Blocks.field_222401_hJ.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 2, j, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 1, k - 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k + 1), whiteStone, 2);
        world.func_180501_a(new BlockPos(i + 2, j + 2, k - 1), whiteStone, 2);
        if (doorSide != 0) {
            world.func_180501_a(new BlockPos(i + 2, j, k), whiteStone, 2);
            world.func_180501_a(new BlockPos(i + 2, j + 1, k), whiteStone, 2);
        } else {
            world.func_180501_a(new BlockPos(i + 2, j, k), (BlockState)((BlockState)ironFence.func_206870_a((IProperty)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 2);
            world.func_180501_a(new BlockPos(i + 2, j + 1, k), (BlockState)((BlockState)ironFence.func_206870_a((IProperty)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), 2);
        }
        if (doorSide != 1) {
            world.func_180501_a(new BlockPos(i, j, k), whiteStone, 2);
            world.func_180501_a(new BlockPos(i, j + 1, k), whiteStone, 2);
        } else {
            world.func_180501_a(new BlockPos(i, j, k), ironFence, 2);
            world.func_180501_a(new BlockPos(i, j + 1, k), ironFence, 2);
        }
        world.func_180501_a(new BlockPos(i + 1, j, k), Blocks.field_150486_ae.func_176223_P(), 2);
        ChestTileEntity tile = (ChestTileEntity)world.func_175625_s(new BlockPos(i + 1, j, k));
        tile.func_189404_a(TheFarlandersMod.locate("chests/small_loot_chest"), world.func_201674_k().nextLong());
        world.func_180501_a(new BlockPos(i, j, k - 2), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i, j + 1, k - 2), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i, j + 2, k - 2), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 1, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i + 3, j + 2, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i - 1, j, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i - 1, j + 1, k), Blocks.field_150350_a.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(i - 1, j + 2, k), Blocks.field_150350_a.func_176223_P(), 2);
        for (int posX = i; posX <= i + 8; ++posX) {
            for (int posZ = k; posZ <= k + 6; ++posZ) {
                int posY = j - 1;
                boolean isFloorFinished = false;
                while (!isFloorFinished) {
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150350_a.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150349_c.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150434_aF.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_196606_bd.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_196605_bc.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_196555_aI.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150433_aE.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150355_j.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150353_l.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150338_P.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_150337_Q.func_176223_P() || world.func_180495_p(new BlockPos(posX, posY, posZ)) == Blocks.field_196651_dG.func_176223_P()) {
                        world.func_180501_a(new BlockPos(posX, posY, posZ), whiteStone, 2);
                        --posY;
                        continue;
                    }
                    isFloorFinished = true;
                }
            }
        }
        TitanEntity titan = new TitanEntity(FarlandersEntityTypes.TITAN, world.func_201672_e());
        titan.func_70107_b(i - 1, j + 1, k);
        titan.func_110163_bv();
        world.func_217376_c((Entity)titan);
        EnderGolemEntity golem = new EnderGolemEntity(FarlandersEntityTypes.ENDER_GOLEM, world.func_201672_e());
        golem.func_70107_b(i - 1, j + 1, k);
        golem.func_110163_bv();
        world.func_217376_c((Entity)golem);
        return true;
    }
}

