/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.farlanders.world.structure;

import com.google.common.collect.ImmutableList;
import com.legacy.farlanders.TheFarlandersMod;
import com.legacy.farlanders.entity.ElderFarlanderEntity;
import com.legacy.farlanders.entity.FarlanderEntity;
import com.legacy.farlanders.entity.FarlandersEntityTypes;
import com.legacy.farlanders.entity.hostile.EnderGolemEntity;
import com.legacy.farlanders.entity.util.IColoredEyes;
import com.legacy.farlanders.registry.FarlandersFeatures;
import com.legacy.structure_gel.structures.GelStructurePiece;
import com.legacy.structure_gel.structures.jigsaw.JigsawRegistryHelper;
import com.legacy.structure_gel.util.Collectors;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallHousePieces {
    public static void assemble(ChunkGenerator<?> chunkGen, TemplateManager template, BlockPos pos, List<StructurePiece> pieces, SharedSeedRandom seed) {
        JigsawManager.func_214889_a((ResourceLocation)TheFarlandersMod.locate("small_house/root"), (int)7, Piece::new, chunkGen, (TemplateManager)template, (BlockPos)pos, pieces, (Random)seed);
    }

    public static void init() {
    }

    static {
        RuleStructureProcessor fixStairs = new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150390_bg), (RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), Blocks.field_196658_i.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150390_bg), (RuleTest)new BlockMatchRuleTest(Blocks.field_150346_d), Blocks.field_150346_d.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150390_bg), (RuleTest)new BlockMatchRuleTest(Blocks.field_150348_b), Blocks.field_150348_b.func_176223_P())));
        JigsawRegistryHelper registry = new JigsawRegistryHelper("farlanders", "small_house/");
        registry.register("root", registry.builder().names(new String[]{"root"}).build());
        registry.register("house", registry.builder().names(Collectors.mapOf(String.class, Integer.class, (Object[])new Object[]{"house_birch", 10, "house_oak", 10, "house_nether_brick", 5, "house_elder", 1})).processors(new StructureProcessor[]{fixStairs}).maintainWater(false).build());
        registry.register("golem", registry.builder().names(new String[]{"golem"}).maintainWater(false).build());
    }

    public static class Piece
    extends GelStructurePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super((IStructurePieceType)FarlandersFeatures.SMALL_HOUSE.getSecond(), template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt, (IStructurePieceType)FarlandersFeatures.SMALL_HOUSE.getSecond());
        }

        public void handleDataMarker(String key, IWorld worldIn, BlockPos pos, Random rand, MutableBoundingBox bounds) {
            IColoredEyes entity;
            if (key.equals("farlander")) {
                this.setAir(worldIn, pos);
                entity = (FarlanderEntity)this.createEntity(FarlandersEntityTypes.FARLANDER, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("elder")) {
                this.setAir(worldIn, pos);
                entity = (ElderFarlanderEntity)this.createEntity(FarlandersEntityTypes.ELDER_FARLANDER, worldIn, pos, this.field_214834_c);
                entity.func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("golem")) {
                this.setAir(worldIn, pos);
                entity = (EnderGolemEntity)this.createEntity(FarlandersEntityTypes.ENDER_GOLEM, worldIn, pos, this.field_214834_c);
                ((EnderGolemEntity)entity).func_213386_a(worldIn, worldIn.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            }
            if (key.equals("chest")) {
                worldIn.func_180501_a(pos, Blocks.field_196553_aF.func_176223_P(), 3);
                ChestTileEntity tile = (ChestTileEntity)worldIn.func_175625_s(pos.func_177977_b());
                tile.func_189404_a(TheFarlandersMod.locate("chests/elder_house_chest"), worldIn.func_201674_k().nextLong());
            }
        }
    }
}

