/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel;

import com.legacy.structure_gel.StructureGelConfig;
import com.legacy.structure_gel.blocks.AxisStructureGelBlock;
import com.legacy.structure_gel.blocks.IStructureGel;
import com.legacy.structure_gel.blocks.StructureGelBlock;
import com.legacy.structure_gel.items.StructureGelItem;
import com.legacy.structure_gel.structures.jigsaw.GelJigsawPiece;
import com.legacy.structure_gel.structures.processors.RandomBlockSwapProcessor;
import com.legacy.structure_gel.structures.processors.RandomStateSwapProcessor;
import com.legacy.structure_gel.structures.processors.RandomTagSwapProcessor;
import com.legacy.structure_gel.structures.processors.RemoveGelStructureProcessor;
import com.legacy.structure_gel.util.RegistryHelper;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="structure_gel")
public class StructureGelMod {
    public static final String NAME = "Structure Gel API";
    public static final String MODID = "structure_gel";
    public static final String VERSION = "1.0.0";
    public static final Logger LOGGER = LogManager.getLogger();

    public StructureGelMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, StructureGelConfig.COMMON_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
    }

    public void clientInit(FMLClientSetupEvent event) {
        Blocks.BLOCKS.forEach(b -> RenderTypeLookup.setRenderLayer((Block)b, (RenderType)RenderType.func_228645_f_()));
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class JigsawDeserializers {
        public static IJigsawDeserializer GEL_SINGLE_POOL_ELEMENT;

        @SubscribeEvent
        public static void onRegistry(RegistryEvent.Register<Feature<?>> event) {
            GEL_SINGLE_POOL_ELEMENT = JigsawDeserializers.register("gel_single_pool_element", GelJigsawPiece::new);
        }

        private static IJigsawDeserializer register(String key, IJigsawDeserializer type) {
            return (IJigsawDeserializer)Registry.func_218322_a((Registry)Registry.field_218365_F, (ResourceLocation)StructureGelMod.locate(key), (Object)type);
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Processors {
        public static IStructureProcessorType REMOVE_FILLER;
        public static IStructureProcessorType REPLACE_BLOCK;
        public static IStructureProcessorType REPLACE_TAG;
        public static IStructureProcessorType REPLACE_STATE;

        @SubscribeEvent
        public static void onRegistry(RegistryEvent.Register<Feature<?>> event) {
            REMOVE_FILLER = Processors.register("remove_filler", dyn -> RemoveGelStructureProcessor.INSTANCE);
            REPLACE_BLOCK = Processors.register("replace_block", RandomBlockSwapProcessor::new);
            REPLACE_TAG = Processors.register("replace_tag", RandomTagSwapProcessor::new);
            REPLACE_STATE = Processors.register("replace_state", RandomStateSwapProcessor::new);
        }

        private static IStructureProcessorType register(String key, IStructureProcessorType type) {
            return (IStructureProcessorType)Registry.func_218322_a((Registry)Registry.field_218364_E, (ResourceLocation)StructureGelMod.locate(key), (Object)type);
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Items {
        @SubscribeEvent
        public static void onRegistry(RegistryEvent.Register<Item> event) {
            for (Block b : Blocks.BLOCKS) {
                if (!(b instanceof StructureGelBlock)) continue;
                RegistryHelper.register(event.getRegistry(), b.getRegistryName(), new StructureGelItem((StructureGelBlock)b));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Blocks {
        public static Set<Block> BLOCKS = new LinkedHashSet<Block>();
        public static Block RED_GEL;
        public static Block BLUE_GEL;
        public static Block GREEN_GEL;
        public static Block CYAN_GEL;
        public static Block ORANGE_GEL;
        public static Block YELLOW_GEL;

        @SubscribeEvent
        public static void onRegistry(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            RED_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "red_gel", new StructureGelBlock(new IStructureGel.IBehavior[0]));
            BLUE_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "blue_gel", new StructureGelBlock(IStructureGel.Behavior.PHOTOSENSITIVE));
            GREEN_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "green_gel", new StructureGelBlock(IStructureGel.Behavior.DIAGONAL_SPREAD));
            CYAN_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "cyan_gel", new StructureGelBlock(IStructureGel.Behavior.PHOTOSENSITIVE, IStructureGel.Behavior.DIAGONAL_SPREAD));
            ORANGE_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "orange_gel", new StructureGelBlock(IStructureGel.Behavior.DYNAMIC_SPREAD_DIST));
            YELLOW_GEL = Blocks.registerBlock((IForgeRegistry<Block>)registry, "yellow_gel", new AxisStructureGelBlock(IStructureGel.Behavior.AXIS_SPREAD));
        }

        private static Block registerBlock(IForgeRegistry<Block> registry, String key, Block object) {
            BLOCKS.add(object);
            return RegistryHelper.register(registry, StructureGelMod.locate(key), object);
        }
    }
}

