/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.util;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.StructureGelMod;
import java.util.Arrays;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigTemplates {

    public static class BiomeStructureConfig
    extends StructureConfig {
        private final ForgeConfigSpec.ConfigValue<String> biomeString;
        private final ForgeConfigSpec.BooleanValue isWhitelist;
        private ImmutableList<Biome> biomes = ImmutableList.of();

        public BiomeStructureConfig(ForgeConfigSpec.Builder builder, String name, double defaultProbability, int defaultSpacing, int defaultOffset, String defaultBiomesString, boolean defaultIsWhitelist) {
            super(builder, name, defaultProbability, defaultSpacing, defaultOffset);
            this.biomeString = builder.comment("A biome filter to choose where this structure should generate.").define(name + ".biomes", (Object)defaultBiomesString);
            this.isWhitelist = builder.comment("How should the code treate biomes? true = whitelist, false = blacklist.").define(name + ".is_whitelist", defaultIsWhitelist);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        }

        public BiomeStructureConfig(ForgeConfigSpec.Builder builder, String name, double defaultProbability, int defaultSpacing, int defaultOffset, String defaultBiomesString) {
            this(builder, name, defaultProbability, defaultSpacing, defaultOffset, defaultBiomesString, true);
        }

        @SubscribeEvent
        protected void onConfigLoad(ModConfig.ModConfigEvent event) {
            this.biomes = BiomeStructureConfig.parseBiomes((String)this.biomeString.get());
        }

        public ImmutableList<Biome> getBiomes() {
            return this.biomes;
        }

        public boolean isBiomeAllowed(Biome biome) {
            return this.biomes.contains((Object)biome) == ((Boolean)this.isWhitelist.get()).booleanValue();
        }

        public static ImmutableList<Biome> parseBiomes(String key) {
            if (key.isEmpty()) {
                return ImmutableList.of();
            }
            return (ImmutableList)Arrays.asList(key.replace(" ", "").split(",")).stream().map(s -> {
                if (ForgeRegistries.BIOMES.containsKey(new ResourceLocation(s))) {
                    return (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(s));
                }
                StructureGelMod.LOGGER.warn(String.format("Tried to parse the biome \"%s\" but it is not registered. Defaulting to plains.", s, key));
                return Biomes.field_76772_c;
            }).collect(ImmutableList.toImmutableList());
        }
    }

    public static class StructureConfig {
        private final ForgeConfigSpec.DoubleValue probability;
        private final ForgeConfigSpec.IntValue spacing;
        private final ForgeConfigSpec.IntValue offset;

        public StructureConfig(ForgeConfigSpec.Builder builder, String name, double defaultProbability, int defaultSpacing, int defaultOffset) {
            this.probability = builder.comment("Chance of generating in an allowed chunk").defineInRange(name + ".probability", defaultProbability, 0.0, 1.0);
            this.spacing = builder.comment("Spacing between structures").defineInRange(name + ".spacing", defaultSpacing, 1, Integer.MAX_VALUE);
            this.offset = builder.comment("Offsets the spacing of the structures randomly").defineInRange(name + ".offset", defaultOffset, 0, Integer.MAX_VALUE);
        }

        public double getProbability() {
            return (Double)this.probability.get();
        }

        public int getSpacing() {
            return (Integer)this.spacing.get();
        }

        public int getOffset() {
            return (Integer)this.offset.get();
        }
    }
}

