/*
 * Decompiled with CFR 0.152.
 */
package com.fabiulu.farlanders.common.worldgen.village;

import com.fabiulu.farlanders.common.FarlandersMod;
import com.fabiulu.farlanders.common.entity.EntityEnderGuardian;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class VillageHouseSmallNoDoor
extends WorldGenerator {
    private static final Block planks = Blocks.field_150344_f;
    private static final Block wood = Blocks.field_150364_r;
    private static final Block thinGlass = Blocks.field_150410_aZ;
    private static final Block whiteStone = Blocks.field_150377_bs;
    private static final Block air = Blocks.field_150350_a;

    protected Block[] GetValidSpawnBlocks() {
        return new Block[]{Blocks.field_150433_aE, Blocks.field_150354_m, Blocks.field_150348_b, Blocks.field_150349_c};
    }

    public boolean LocationIsValidSpawn(World world, int i, int j, int k) {
        int distanceToAir = 0;
        Block checkID = world.func_147439_a(i, j, k);
        while (checkID != air) {
            checkID = world.func_147439_a(i, j + ++distanceToAir, k);
        }
        if (distanceToAir > 2) {
            return false;
        }
        Block blockID = world.func_147439_a(i, j += distanceToAir - 1, k);
        Block blockIDAbove = world.func_147439_a(i, j + 1, k);
        Block blockIDBelow = world.func_147439_a(i, j - 1, k);
        for (Block x : this.GetValidSpawnBlocks()) {
            if (blockIDAbove != air) {
                return false;
            }
            if (blockID == Blocks.field_150433_aE && blockIDBelow == x || blockID == Blocks.field_150329_H && blockIDBelow == x || blockID == Blocks.field_150328_O && blockIDBelow == x || blockID == Blocks.field_150327_N && blockIDBelow == x || blockID == Blocks.field_150330_I && blockIDBelow == x || blockID == Blocks.field_150434_aF && blockIDBelow == x || blockID == Blocks.field_150338_P && blockIDBelow == x || blockID == Blocks.field_150337_Q && blockIDBelow == x) {
                return true;
            }
            if (blockID != x) continue;
            return true;
        }
        return false;
    }

    public boolean checkAllLocations(World world, int i, int j, int k) {
        return this.LocationIsValidSpawn(world, i, j, k) && this.LocationIsValidSpawn(world, i + 4, j, k) && this.LocationIsValidSpawn(world, i + 4, j, k + 5) && this.LocationIsValidSpawn(world, i, j, k + 5) && this.AirLocationIsValidSpawn(world, i, j + 5, k) && this.AirLocationIsValidSpawn(world, i + 4, j + 5, k) && this.AirLocationIsValidSpawn(world, i + 4, j + 5, k + 5) && this.AirLocationIsValidSpawn(world, i, j + 5, k + 5);
    }

    public boolean AirLocationIsValidSpawn(World world, int i, int j, int k) {
        Block blockID = world.func_147439_a(i, j, k);
        Block blockIDAbove = world.func_147439_a(i, j + 1, k);
        return blockID == air && blockIDAbove == air;
    }

    public boolean func_76484_a(World world, Random rand, int i, int j, int k) {
        if (!(this.LocationIsValidSpawn(world, i, j, k) && this.LocationIsValidSpawn(world, i + 4, j, k) && this.LocationIsValidSpawn(world, i + 4, j, k + 5) && this.LocationIsValidSpawn(world, i, j, k + 5) && this.AirLocationIsValidSpawn(world, i, j + 5, k) && this.AirLocationIsValidSpawn(world, i + 4, j + 5, k) && this.AirLocationIsValidSpawn(world, i + 4, j + 5, k + 5) && this.AirLocationIsValidSpawn(world, i, j + 5, k + 5))) {
            return false;
        }
        world.func_147449_b(i + 0, j + 1, k + 0, air);
        world.func_147465_d(i + 0, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 0, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 0, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 0, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 0, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 0, j + 2, k + 0, air);
        world.func_147465_d(i + 0, j + 2, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 0, j + 2, k + 2, planks, 0, 2);
        world.func_147465_d(i + 0, j + 2, k + 3, planks, 0, 2);
        world.func_147465_d(i + 0, j + 2, k + 4, planks, 0, 2);
        world.func_147465_d(i + 0, j + 2, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 0, j + 3, k + 0, air);
        world.func_147465_d(i + 0, j + 3, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 0, j + 3, k + 2, planks, 0, 2);
        world.func_147465_d(i + 0, j + 3, k + 3, thinGlass, 0, 2);
        world.func_147465_d(i + 0, j + 3, k + 4, planks, 0, 2);
        world.func_147465_d(i + 0, j + 3, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 0, j + 4, k + 0, air);
        world.func_147465_d(i + 0, j + 4, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 0, j + 4, k + 2, planks, 0, 2);
        world.func_147465_d(i + 0, j + 4, k + 3, planks, 0, 2);
        world.func_147465_d(i + 0, j + 4, k + 4, planks, 0, 2);
        world.func_147465_d(i + 0, j + 4, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 0, j + 5, k + 0, air);
        world.func_147465_d(i + 0, j + 5, k + 1, wood, 0, 2);
        world.func_147465_d(i + 0, j + 5, k + 2, wood, 0, 2);
        world.func_147465_d(i + 0, j + 5, k + 3, wood, 0, 2);
        world.func_147465_d(i + 0, j + 5, k + 4, wood, 0, 2);
        world.func_147465_d(i + 0, j + 5, k + 5, wood, 0, 2);
        world.func_147449_b(i + 1, j + 1, k + 0, air);
        world.func_147465_d(i + 1, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 1, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 1, j + 2, k + 0, air);
        world.func_147465_d(i + 1, j + 2, k + 1, planks, 0, 2);
        world.func_147449_b(i + 1, j + 2, k + 2, air);
        world.func_147449_b(i + 1, j + 2, k + 3, air);
        world.func_147449_b(i + 1, j + 2, k + 4, air);
        world.func_147465_d(i + 1, j + 2, k + 5, planks, 0, 2);
        world.func_147449_b(i + 1, j + 3, k + 0, air);
        world.func_147465_d(i + 1, j + 3, k + 1, planks, 0, 2);
        world.func_147449_b(i + 1, j + 3, k + 2, air);
        world.func_147449_b(i + 1, j + 3, k + 3, air);
        world.func_147449_b(i + 1, j + 3, k + 4, air);
        world.func_147465_d(i + 1, j + 3, k + 5, planks, 0, 2);
        world.func_147449_b(i + 1, j + 4, k + 0, air);
        world.func_147465_d(i + 1, j + 4, k + 1, planks, 0, 2);
        world.func_147449_b(i + 1, j + 4, k + 2, air);
        world.func_147449_b(i + 1, j + 4, k + 3, air);
        world.func_147449_b(i + 1, j + 4, k + 4, air);
        world.func_147465_d(i + 1, j + 4, k + 5, planks, 0, 2);
        world.func_147449_b(i + 1, j + 5, k + 0, air);
        world.func_147465_d(i + 1, j + 5, k + 1, wood, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 2, planks, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 3, planks, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 4, planks, 0, 2);
        world.func_147465_d(i + 1, j + 5, k + 5, wood, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 0, Blocks.field_150446_ar, 2, 2);
        world.func_147465_d(i + 2, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 2, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 2, j + 2, k + 0, air);
        world.func_147449_b(i + 2, j + 2, k + 1, air);
        world.func_147449_b(i + 2, j + 2, k + 2, air);
        world.func_147449_b(i + 2, j + 2, k + 3, air);
        world.func_147449_b(i + 2, j + 2, k + 4, air);
        world.func_147465_d(i + 2, j + 2, k + 5, planks, 0, 2);
        world.func_147449_b(i + 2, j + 3, k + 0, air);
        world.func_147449_b(i + 2, j + 3, k + 1, air);
        world.func_147449_b(i + 2, j + 3, k + 2, air);
        world.func_147449_b(i + 2, j + 3, k + 3, air);
        world.func_147449_b(i + 2, j + 3, k + 4, air);
        world.func_147465_d(i + 2, j + 3, k + 5, thinGlass, 0, 2);
        world.func_147449_b(i + 2, j + 4, k + 0, air);
        world.func_147465_d(i + 2, j + 4, k + 1, planks, 0, 2);
        world.func_147449_b(i + 2, j + 4, k + 3, air);
        world.func_147449_b(i + 2, j + 4, k + 4, air);
        world.func_147465_d(i + 2, j + 4, k + 5, planks, 0, 2);
        world.func_147449_b(i + 2, j + 5, k + 0, air);
        world.func_147465_d(i + 2, j + 5, k + 1, wood, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 2, planks, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 3, planks, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 4, planks, 0, 2);
        world.func_147465_d(i + 2, j + 5, k + 5, wood, 0, 2);
        world.func_147449_b(i + 3, j + 1, k + 0, air);
        world.func_147465_d(i + 3, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 3, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 3, j + 2, k + 0, air);
        world.func_147465_d(i + 3, j + 2, k + 1, planks, 0, 2);
        world.func_147449_b(i + 3, j + 2, k + 2, air);
        world.func_147449_b(i + 3, j + 2, k + 3, air);
        world.func_147449_b(i + 3, j + 2, k + 4, air);
        world.func_147465_d(i + 3, j + 2, k + 5, planks, 0, 2);
        world.func_147449_b(i + 3, j + 3, k + 0, air);
        world.func_147465_d(i + 3, j + 3, k + 1, planks, 0, 2);
        world.func_147449_b(i + 3, j + 3, k + 2, air);
        world.func_147449_b(i + 3, j + 3, k + 3, air);
        world.func_147449_b(i + 3, j + 3, k + 4, air);
        world.func_147465_d(i + 3, j + 3, k + 5, planks, 0, 2);
        world.func_147449_b(i + 3, j + 4, k + 0, air);
        world.func_147465_d(i + 3, j + 4, k + 1, planks, 0, 2);
        world.func_147449_b(i + 3, j + 4, k + 2, air);
        world.func_147449_b(i + 3, j + 4, k + 3, air);
        world.func_147449_b(i + 3, j + 4, k + 4, air);
        world.func_147465_d(i + 3, j + 4, k + 5, planks, 0, 2);
        world.func_147449_b(i + 3, j + 5, k + 0, air);
        world.func_147465_d(i + 3, j + 5, k + 1, wood, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 2, planks, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 3, planks, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 4, planks, 0, 2);
        world.func_147465_d(i + 3, j + 5, k + 5, wood, 0, 2);
        world.func_147449_b(i + 4, j + 1, k + 0, air);
        world.func_147465_d(i + 4, j + 1, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 2, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 3, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 4, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 1, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 4, j + 2, k + 0, air);
        world.func_147465_d(i + 4, j + 2, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 2, k + 2, planks, 0, 2);
        world.func_147465_d(i + 4, j + 2, k + 3, planks, 0, 2);
        world.func_147465_d(i + 4, j + 2, k + 4, planks, 0, 2);
        world.func_147465_d(i + 4, j + 2, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 4, j + 3, k + 0, air);
        world.func_147465_d(i + 4, j + 3, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 3, k + 2, planks, 0, 2);
        world.func_147465_d(i + 4, j + 3, k + 3, thinGlass, 0, 2);
        world.func_147465_d(i + 4, j + 3, k + 4, planks, 0, 2);
        world.func_147465_d(i + 4, j + 3, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 4, j + 4, k + 0, air);
        world.func_147465_d(i + 4, j + 4, k + 1, whiteStone, 0, 2);
        world.func_147465_d(i + 4, j + 4, k + 2, planks, 0, 2);
        world.func_147465_d(i + 4, j + 4, k + 3, planks, 0, 2);
        world.func_147465_d(i + 4, j + 4, k + 4, planks, 0, 2);
        world.func_147465_d(i + 4, j + 4, k + 5, whiteStone, 0, 2);
        world.func_147449_b(i + 4, j + 5, k + 0, air);
        world.func_147465_d(i + 4, j + 5, k + 1, wood, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 2, wood, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 3, wood, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 4, wood, 0, 2);
        world.func_147465_d(i + 4, j + 5, k + 5, wood, 0, 2);
        world.func_147465_d(i + 2, j + 4, k + 2, Blocks.field_150478_aa, 3, 2);
        if (rand.nextInt(2) == 0) {
            world.func_147465_d(i + 3, j + 2, k + 3, (Block)Blocks.field_150486_ae, 0, 2);
            TileEntityChest chest = new TileEntityChest();
            world.func_147455_a(i + 3, j + 2, k + 3, (TileEntity)chest);
            for (int slot = 0; slot < chest.func_70302_i_(); ++slot) {
                int num = rand.nextInt(150);
                if (num == 0) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151034_e));
                    continue;
                }
                if (num == 1) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151153_ao));
                    continue;
                }
                if (num == 2) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151009_A));
                    continue;
                }
                if (num == 3) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151025_P));
                    continue;
                }
                if (num == 4) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151157_am));
                    continue;
                }
                if (num == 5) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151147_al));
                    continue;
                }
                if (num == 6) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151015_O));
                    continue;
                }
                if (num == 7) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151117_aB));
                    continue;
                }
                if (num == 8) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151110_aK));
                    continue;
                }
                if (num == 9) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151115_aP));
                    continue;
                }
                if (num == 10) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151101_aQ));
                    continue;
                }
                if (num == 11) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151102_aT));
                    continue;
                }
                if (num == 12) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151105_aU));
                    continue;
                }
                if (num == 13) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151106_aX));
                    continue;
                }
                if (num == 14) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151082_bd));
                    continue;
                }
                if (num == 15) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151083_be));
                    continue;
                }
                if (num == 16) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151076_bf));
                    continue;
                }
                if (num == 17) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151077_bg));
                    continue;
                }
                if (num == 18) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151078_bh));
                    continue;
                }
                if (num == 19) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151172_bF));
                    continue;
                }
                if (num == 20) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151174_bG));
                    continue;
                }
                if (num == 21) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151168_bH));
                    continue;
                }
                if (num == 22) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151170_bI));
                    continue;
                }
                if (num == 23) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151150_bK));
                    continue;
                }
                if (num == 24) {
                    chest.func_70299_a(slot, new ItemStack(Items.field_151158_bO));
                    continue;
                }
                if (num != 25) continue;
                chest.func_70299_a(slot, new ItemStack(Items.field_151127_ba));
            }
        }
        for (int posX = i; posX <= i + 4; ++posX) {
            for (int posZ = k; posZ <= k + 5; ++posZ) {
                int posY = j;
                boolean isFloorFinished = false;
                while (!isFloorFinished) {
                    if (world.func_147439_a(posX, posY, posZ) == air || world.func_147439_a(posX, posY, posZ) == Blocks.field_150329_H || world.func_147439_a(posX, posY, posZ) == Blocks.field_150434_aF || world.func_147439_a(posX, posY, posZ) == Blocks.field_150328_O || world.func_147439_a(posX, posY, posZ) == Blocks.field_150327_N || world.func_147439_a(posX, posY, posZ) == Blocks.field_150330_I || world.func_147439_a(posX, posY, posZ) == Blocks.field_150433_aE || world.func_147439_a(posX, posY, posZ) == Blocks.field_150355_j || world.func_147439_a(posX, posY, posZ) == Blocks.field_150353_l || world.func_147439_a(posX, posY, posZ) == Blocks.field_150338_P || world.func_147439_a(posX, posY, posZ) == Blocks.field_150337_Q || world.func_147439_a(posX, posY, posZ) == Blocks.field_150392_bi) {
                        world.func_147465_d(posX, posY, posZ, whiteStone, 0, 2);
                        --posY;
                        continue;
                    }
                    isFloorFinished = true;
                }
            }
        }
        if (FarlandersMod.enderGuardianSpawn == 1) {
            EntityEnderGuardian var5 = new EntityEnderGuardian(world, i + 2, j + 2, k - 1, true);
            var5.func_70107_b(i + 2, j + 2, k - 1);
            world.func_72838_d((Entity)var5);
        }
        return true;
    }
}

