/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat;

import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistryDefaultHandler;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class VanillaAddon {
    private static final String[] ANIMALS = new String[]{"Pig", "Sheep", "Cow", "Chicken", "EntityHorse", "Ozelot", "Rabbit", "PolarBear", "Wolf"};

    public VanillaAddon() {
        MarketRegistry.registerDefaultHandler("Vanilla Seeds", new MarketRegistryDefaultHandler(){

            @Override
            public void apply(MarketRegistry registry, ItemStack defaultPayment) {
                registry.registerEntry(new ItemStack(Items.field_151014_N), defaultPayment, MarketEntry.EntryType.SEEDS);
                registry.registerEntry(new ItemStack(Items.field_151081_bc), defaultPayment, MarketEntry.EntryType.SEEDS);
                registry.registerEntry(new ItemStack(Items.field_151080_bb), defaultPayment, MarketEntry.EntryType.SEEDS);
                registry.registerEntry(new ItemStack(Items.field_185163_cU), defaultPayment, MarketEntry.EntryType.SEEDS);
            }

            @Override
            public boolean isEnabledByDefault() {
                return true;
            }

            @Override
            public ItemStack getDefaultPayment() {
                return new ItemStack(Items.field_151166_bC);
            }
        });
        MarketRegistry.registerDefaultHandler("Vanilla Saplings", new MarketRegistryDefaultHandler(){

            @Override
            public void apply(MarketRegistry registry, ItemStack defaultPayment) {
                for (BlockPlanks.EnumType type : BlockSapling.field_176480_a.func_177700_c()) {
                    registry.registerEntry(new ItemStack(Blocks.field_150345_g, 1, type.func_176839_a()), defaultPayment, MarketEntry.EntryType.SAPLINGS);
                }
            }

            @Override
            public boolean isEnabledByDefault() {
                return true;
            }

            @Override
            public ItemStack getDefaultPayment() {
                return new ItemStack(Items.field_151166_bC);
            }
        });
        MarketRegistry.registerDefaultHandler("Bonemeal", new MarketRegistryDefaultHandler(){

            @Override
            public void apply(MarketRegistry registry, ItemStack defaultPayment) {
                registry.registerEntry(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), defaultPayment, MarketEntry.EntryType.OTHER);
            }

            @Override
            public boolean isEnabledByDefault() {
                return true;
            }

            @Override
            public ItemStack getDefaultPayment() {
                return new ItemStack(Items.field_151166_bC);
            }
        });
        MarketRegistry.registerDefaultHandler("Animal Eggs", new MarketRegistryDefaultHandler(){

            @Override
            public void apply(MarketRegistry registry, ItemStack defaultPayment) {
                for (String animalName : ANIMALS) {
                    ItemStack eggStack = new ItemStack(Items.field_151063_bx);
                    NBTTagCompound tagCompound = eggStack.func_77978_p();
                    if (tagCompound == null) {
                        tagCompound = new NBTTagCompound();
                    }
                    NBTTagCompound entityTag = new NBTTagCompound();
                    entityTag.func_74778_a("id", animalName);
                    tagCompound.func_74782_a("EntityTag", (NBTBase)entityTag);
                    eggStack.func_77982_d(tagCompound);
                    registry.registerEntry(eggStack, defaultPayment, MarketEntry.EntryType.OTHER);
                }
            }

            @Override
            public boolean isEnabledByDefault() {
                return false;
            }

            @Override
            public ItemStack getDefaultPayment() {
                return new ItemStack(Items.field_151166_bC);
            }
        });
    }
}

