/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageMarketList
implements IMessage {
    private Collection<MarketEntry> entryList;

    public MessageMarketList() {
    }

    public MessageMarketList(Collection<MarketEntry> entryList) {
        this.entryList = entryList;
    }

    public void fromBytes(ByteBuf buf) {
        int entryCount = buf.readInt();
        this.entryList = Lists.newArrayListWithCapacity((int)entryCount);
        for (int i = 0; i < entryCount; ++i) {
            this.entryList.add(this.readEntry(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        int count = this.entryList.size();
        buf.writeInt(count);
        for (MarketEntry recipe : this.entryList) {
            this.writeEntry(recipe, buf);
        }
    }

    public Collection<MarketEntry> getEntryList() {
        return this.entryList;
    }

    private MarketEntry readEntry(ByteBuf buf) {
        ItemStack outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        ItemStack costItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        MarketEntry.EntryType type = MarketEntry.EntryType.fromId(buf.readByte());
        return new MarketEntry(outputItem, costItem, type);
    }

    private void writeEntry(MarketEntry entry, ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)entry.getOutputItem());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)entry.getCostItem());
        buf.writeByte(entry.getType().ordinal());
    }
}

