/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.compat;

import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistryDefaultHandler;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class VanillaAddon {
    private static final ResourceLocation[] ANIMALS = new ResourceLocation[]{new ResourceLocation("minecraft", "pig"), new ResourceLocation("minecraft", "sheep"), new ResourceLocation("minecraft", "cow"), new ResourceLocation("minecraft", "chicken"), new ResourceLocation("minecraft", "horse"), new ResourceLocation("minecraft", "ocelot"), new ResourceLocation("minecraft", "rabbit"), new ResourceLocation("minecraft", "polar_bear"), new ResourceLocation("minecraft", "wolf"), new ResourceLocation("minecraft", "llama")};

    public VanillaAddon() {
        MarketRegistry.registerDefaultHandler("Vanilla Seeds", new MarketRegistryDefaultHandler(){

            @Override
            public void apply(MarketRegistry registry, ItemStack defaultPayment) {
                registry.registerEntry(new ItemStack(Items.field_151014_N), defaultPayment, MarketEntry.EntryType.SEEDS);
                registry.registerEntry(new ItemStack(Items.field_151081_bc), defaultPayment, MarketEntry.EntryType.SEEDS);
                registry.registerEntry(new ItemStack(Items.field_151080_bb), defaultPayment, MarketEntry.EntryType.SEEDS);
                registry.registerEntry(new ItemStack(Items.field_185163_cU), defaultPayment, MarketEntry.EntryType.SEEDS);
            }

            @Override
            public boolean isEnabledByDefault() {
                return true;
            }

            @Override
            public ItemStack getDefaultPayment() {
                return new ItemStack(Items.field_151166_bC);
            }
        });
        MarketRegistry.registerDefaultHandler("Vanilla Saplings", new MarketRegistryDefaultHandler(){

            @Override
            public void apply(MarketRegistry registry, ItemStack defaultPayment) {
                for (BlockPlanks.EnumType type : BlockSapling.field_176480_a.func_177700_c()) {
                    registry.registerEntry(new ItemStack(Blocks.field_150345_g, 1, type.func_176839_a()), defaultPayment, MarketEntry.EntryType.SAPLINGS);
                }
            }

            @Override
            public boolean isEnabledByDefault() {
                return true;
            }

            @Override
            public ItemStack getDefaultPayment() {
                return new ItemStack(Items.field_151166_bC);
            }
        });
        MarketRegistry.registerDefaultHandler("Bonemeal", new MarketRegistryDefaultHandler(){

            @Override
            public void apply(MarketRegistry registry, ItemStack defaultPayment) {
                registry.registerEntry(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()), defaultPayment, MarketEntry.EntryType.OTHER);
            }

            @Override
            public boolean isEnabledByDefault() {
                return true;
            }

            @Override
            public ItemStack getDefaultPayment() {
                return new ItemStack(Items.field_151166_bC);
            }
        });
        MarketRegistry.registerDefaultHandler("Animal Eggs", new MarketRegistryDefaultHandler(){

            @Override
            public void apply(MarketRegistry registry, ItemStack defaultPayment) {
                for (ResourceLocation animalName : ANIMALS) {
                    ItemStack eggStack = new ItemStack(Items.field_151063_bx);
                    ItemMonsterPlacer.func_185078_a((ItemStack)eggStack, (ResourceLocation)animalName);
                    registry.registerEntry(eggStack, defaultPayment, MarketEntry.EntryType.OTHER);
                }
            }

            @Override
            public boolean isEnabledByDefault() {
                return false;
            }

            @Override
            public ItemStack getDefaultPayment() {
                return new ItemStack(Items.field_151166_bC);
            }
        });
    }
}

