/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.container;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.container.ContainerMarket;
import net.blay09.mods.farmingforblockheads.container.FakeSlotMarket;
import net.blay09.mods.farmingforblockheads.network.MessageMarketSelect;
import net.blay09.mods.farmingforblockheads.network.NetworkHandler;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerMarketClient
extends ContainerMarket {
    private final List<MarketEntry> itemList = Lists.newArrayList();
    private final List<MarketEntry> filteredItems = Lists.newArrayList();
    private final Comparator<MarketEntry> comparator = Comparator.comparingInt(o -> o.getType().ordinal());
    private String currentSearch;
    private MarketEntry.EntryType currentFilter;
    private boolean isDirty;
    private int scrollOffset;

    public ContainerMarketClient(EntityPlayer player, BlockPos pos) {
        super(player, pos);
    }

    public ItemStack func_184996_a(int slotNumber, int dragType, ClickType clickType, EntityPlayer player) {
        if (slotNumber >= 0 && slotNumber < this.field_75151_b.size()) {
            FakeSlotMarket slotMarket;
            MarketEntry entry;
            Slot slot = (Slot)this.field_75151_b.get(slotNumber);
            if (player.field_70170_p.field_72995_K && slot instanceof FakeSlotMarket && (entry = (slotMarket = (FakeSlotMarket)slot).getEntry()) != null) {
                this.selectedEntry = entry;
                NetworkHandler.instance.sendToServer((IMessage)new MessageMarketSelect(entry.getOutputItem()));
            }
        }
        return super.func_184996_a(slotNumber, dragType, clickType, player);
    }

    public void search(@Nullable String term) {
        this.currentSearch = term;
        this.applyFilters();
    }

    public void setFilterType(@Nullable MarketEntry.EntryType filterType) {
        this.currentFilter = filterType;
        this.applyFilters();
    }

    public void applyFilters() {
        boolean hasSearchFilter;
        this.scrollOffset = 0;
        this.filteredItems.clear();
        boolean bl = hasSearchFilter = this.currentSearch != null && !this.currentSearch.trim().isEmpty();
        if (this.currentFilter == null && !hasSearchFilter) {
            this.filteredItems.addAll(this.itemList);
        } else {
            for (MarketEntry entry : this.itemList) {
                if (hasSearchFilter && !entry.getOutputItem().func_82833_r().toLowerCase().contains(this.currentSearch.toLowerCase()) || this.currentFilter != null && !this.currentFilter.passes(entry)) continue;
                this.filteredItems.add(entry);
            }
        }
        this.filteredItems.sort(this.comparator);
    }

    public int getFilteredListCount() {
        return this.filteredItems.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.populateMarketSlots();
    }

    public void populateMarketSlots() {
        int i = this.scrollOffset * 3;
        for (FakeSlotMarket slot : this.marketSlots) {
            if (i < this.filteredItems.size()) {
                slot.setEntry(this.filteredItems.get(i));
                ++i;
                continue;
            }
            slot.setEntry(null);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void setEntryList(Collection<MarketEntry> entryList) {
        this.itemList.clear();
        this.itemList.addAll(entryList);
        this.applyFilters();
        this.populateMarketSlots();
        this.setDirty(true);
    }

    @Nullable
    public MarketEntry.EntryType getCurrentFilter() {
        return this.currentFilter;
    }
}

