/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MarketEntry {
    private final ItemStack outputItem;
    private final ItemStack costItem;
    private final EntryType type;

    public MarketEntry(ItemStack outputItem, ItemStack costItem, EntryType type) {
        this.outputItem = outputItem;
        this.costItem = costItem;
        this.type = type;
    }

    public ItemStack getCostItem() {
        return this.costItem;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public EntryType getType() {
        return this.type;
    }

    public static enum EntryType {
        SEEDS("gui.farmingforblockheads:market.tooltip_seeds"),
        SAPLINGS("gui.farmingforblockheads:market.tooltip_saplings"),
        OTHER("gui.farmingforblockheads:market.tooltip_other");

        private static final ResourceLocation TEXTURE;
        private static final EntryType[] values;
        private String tooltip;

        private EntryType(String tooltip) {
            this.tooltip = tooltip;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public ResourceLocation getIconTexture() {
            return TEXTURE;
        }

        public int getIconTextureX() {
            return 196 + this.ordinal() * 20;
        }

        public int getIconTextureY() {
            return 14;
        }

        public boolean passes(MarketEntry entry) {
            return entry.getType() == this;
        }

        public static EntryType fromId(int id) {
            return values[id];
        }

        static {
            TEXTURE = new ResourceLocation("farmingforblockheads", "textures/gui/market.png");
            values = EntryType.values();
        }
    }
}

