/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import net.blay09.mods.farmingforblockheads.CommonProxy;
import net.blay09.mods.farmingforblockheads.IMCHandler;
import net.blay09.mods.farmingforblockheads.InternalMethodsImpl;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.MarketRegistryReloadEvent;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.client.ClientProxy;
import net.blay09.mods.farmingforblockheads.client.ModRenderers;
import net.blay09.mods.farmingforblockheads.client.ModScreens;
import net.blay09.mods.farmingforblockheads.container.ModContainers;
import net.blay09.mods.farmingforblockheads.entity.ModEntities;
import net.blay09.mods.farmingforblockheads.item.ModItems;
import net.blay09.mods.farmingforblockheads.network.NetworkHandler;
import net.blay09.mods.farmingforblockheads.registry.market.MarketRegistryLoader;
import net.blay09.mods.farmingforblockheads.sound.ModSounds;
import net.blay09.mods.farmingforblockheads.tile.ModTileEntities;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="farmingforblockheads")
public class FarmingForBlockheads {
    public static final String MOD_ID = "farmingforblockheads";
    public static Logger logger = LogManager.getLogger();
    public static final ItemGroup itemGroup = new ItemGroup("farmingforblockheads"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModBlocks.market);
        }
    };
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);

    public FarmingForBlockheads() {
        FarmingForBlockheadsAPI.__setupAPI(new InternalMethodsImpl());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processInterMod);
        MinecraftForge.EVENT_BUS.addListener(this::setupServer);
        MinecraftForge.EVENT_BUS.addListener(this::setupMarketRegistry);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, this::registerTileEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        DeferredWorkQueue.runLater(NetworkHandler::init);
    }

    private void setupClient(FMLClientSetupEvent event) {
        ModScreens.register();
        ModRenderers.register();
    }

    private void setupServer(FMLServerAboutToStartEvent event) {
        IReloadableResourceManager resourceManager = event.getServer().func_195570_aG();
        resourceManager.func_219534_a((IFutureReloadListener)new MarketRegistryLoader());
    }

    private void setupMarketRegistry(MarketRegistryReloadEvent.Pre event) {
        FarmingForBlockheadsAPI.registerMarketCategory(new ResourceLocation(MOD_ID, "seeds"), "gui.farmingforblockheads:market.tooltip_seeds", new ItemStack((IItemProvider)Items.field_151014_N), 10);
        FarmingForBlockheadsAPI.registerMarketCategory(new ResourceLocation(MOD_ID, "saplings"), "gui.farmingforblockheads:market.tooltip_saplings", new ItemStack((IItemProvider)Items.field_221592_t), 20);
        FarmingForBlockheadsAPI.registerMarketCategory(new ResourceLocation(MOD_ID, "flowers"), "gui.farmingforblockheads:market.tooltip_flowers", new ItemStack((IItemProvider)Items.field_221619_aU), 30);
        FarmingForBlockheadsAPI.registerMarketCategory(new ResourceLocation(MOD_ID, "other"), "gui.farmingforblockheads:market.tooltip_other", new ItemStack((IItemProvider)Items.field_196106_bc), 40);
        this.buildSoftDependProxy("harvestcraft", "net.blay09.mods.farmingforblockheads.compat.HarvestcraftAddon");
        this.buildSoftDependProxy("forestry", "net.blay09.mods.farmingforblockheads.compat.ForestryAddon");
        this.buildSoftDependProxy("natura", "net.blay09.mods.farmingforblockheads.compat.NaturaAddon");
        this.buildSoftDependProxy("terraqueous", "net.blay09.mods.farmingforblockheads.compat.TerraqueousAddon");
    }

    private void buildSoftDependProxy(String modId, String className) {
        if (ModList.get().isLoaded(modId)) {
            try {
                Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("Failed to load Farming for Blockheads compat for mod id {}: ", (Object)modId, (Object)e);
            }
        }
    }

    private void processInterMod(InterModProcessEvent event) {
        IMCHandler.handleIMCMessage(event);
    }

    private void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
    }

    private void registerItems(RegistryEvent.Register<Item> event) {
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        ModItems.register((IForgeRegistry<Item>)event.getRegistry());
    }

    private void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        ModSounds.register((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    private void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        ModTileEntities.register(event.getRegistry());
    }

    private void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        ModContainers.register(event.getRegistry());
    }

    private void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        ModEntities.register(event.getRegistry());
    }
}

