/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import net.blay09.mods.farmingforblockheads.block.FertilizedFarmlandBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="farmingforblockheads")
public class FarmlandHandler {
    @SubscribeEvent
    public static void onGrowEvent(BlockEvent.CropGrowEvent.Post event) {
        World world = (World)event.getWorld();
        BlockPos pos = event.getPos();
        BlockState plant = world.func_180495_p(event.getPos());
        if (plant.func_177230_c() instanceof IGrowable) {
            IGrowable growable = (IGrowable)plant.func_177230_c();
            BlockState farmland = world.func_180495_p(event.getPos().func_177977_b());
            if (farmland.func_177230_c() instanceof FertilizedFarmlandBlock && Math.random() <= (double)((FertilizedFarmlandBlock)farmland.func_177230_c()).getDoubleGrowthChance() && growable.func_176473_a((IBlockReader)world, pos, plant, world.func_201670_d())) {
                growable.func_176474_b(world, world.func_201674_k(), event.getPos(), plant);
                world.func_217379_c(2005, pos, 0);
                FarmlandHandler.rollRegression(world, pos, farmland);
            }
        }
    }

    @SubscribeEvent
    public static void onHarvest(BlockEvent.HarvestDropsEvent event) {
        World world = (World)event.getWorld();
        BlockPos pos = event.getPos();
        BlockState plant = event.getState();
        BlockState farmland = event.getWorld().func_180495_p(event.getPos().func_177977_b());
        if (farmland.func_177230_c() instanceof FertilizedFarmlandBlock && plant.func_177230_c() instanceof IGrowable && Math.random() <= (double)((FertilizedFarmlandBlock)farmland.func_177230_c()).getBonusCropChance()) {
            event.getDrops().stream().filter(p -> !FarmlandHandler.isProbablySeed(p)).findAny().ifPresent(c -> {
                event.getDrops().add(c.func_77946_l());
                world.func_217379_c(2005, pos, 0);
                FarmlandHandler.rollRegression(world, pos, farmland);
            });
        }
    }

    private static void rollRegression(World world, BlockPos pos, BlockState farmland) {
        if (farmland.func_177230_c() instanceof FertilizedFarmlandBlock && Math.random() <= (double)((FertilizedFarmlandBlock)farmland.func_177230_c()).getRegressionChance()) {
            world.func_175656_a(pos, (BlockState)Blocks.field_150458_ak.func_176223_P().func_206870_a((IProperty)FarmlandBlock.field_176531_a, farmland.func_177229_b((IProperty)FarmlandBlock.field_176531_a)));
        }
    }

    private static boolean isProbablySeed(ItemStack itemStack) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        return registryName != null && registryName.func_110623_a().contains("seed");
    }
}

