/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.client.gui.widget.MarketFilterButton;
import net.blay09.mods.farmingforblockheads.container.MarketBuySlot;
import net.blay09.mods.farmingforblockheads.container.MarketClientContainer;
import net.blay09.mods.farmingforblockheads.container.MarketContainer;
import net.blay09.mods.farmingforblockheads.container.MarketFakeSlot;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MarketScreen
extends ContainerScreen<MarketContainer> {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final int VISIBLE_ROWS = 4;
    private static final ResourceLocation TEXTURE = new ResourceLocation("farmingforblockheads", "textures/gui/market.png");
    private final List<MarketFilterButton> filterButtons = Lists.newArrayList();
    private final MarketClientContainer clientContainer;
    private boolean isEventHandler;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private TextFieldWidget searchBar;

    public MarketScreen(MarketContainer container, PlayerInventory playerInventory, ITextComponent displayName) {
        super((Container)container, playerInventory, displayName);
        this.clientContainer = (MarketClientContainer)container;
    }

    public void init() {
        IMarketCategory[] categories;
        this.field_147000_g = 174;
        super.init();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.searchBar = new TextFieldWidget(fontRenderer, this.field_147003_i + this.field_146999_f - 78, this.field_147009_r - 5, 70, 10, this.searchBar, "");
        this.func_212928_a((IGuiEventListener)this.searchBar);
        this.addButton((Widget)this.searchBar);
        int curY = -80;
        for (IMarketCategory category : categories = (IMarketCategory[])MarketRegistry.getCategories().stream().sorted().toArray(IMarketCategory[]::new)) {
            if (MarketRegistry.getGroupedEntries().get((Object)category).isEmpty()) continue;
            MarketFilterButton filterButton = new MarketFilterButton(this.width / 2 + 87, this.height / 2 + curY, this.clientContainer, category, button -> {
                if (this.clientContainer.getCurrentCategory() == category) {
                    this.clientContainer.setFilterCategory(null);
                } else {
                    this.clientContainer.setFilterCategory(category);
                }
                this.clientContainer.populateMarketSlots();
                this.setCurrentOffset(this.currentOffset);
            });
            this.addButton((Widget)filterButton);
            this.filterButtons.add(filterButton);
            curY += 20;
        }
        if (!this.isEventHandler) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.isEventHandler = true;
        }
        this.recalculateScrollBar();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (Math.abs(delta) > 0.0) {
            this.setCurrentOffset(delta > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1 && mouseX >= (double)this.searchBar.x && mouseX < (double)(this.searchBar.x + this.searchBar.getWidth()) && mouseY >= (double)this.searchBar.y && mouseY < (double)(this.searchBar.y + this.searchBar.getHeight())) {
            this.searchBar.func_146180_a("");
            this.clientContainer.search(null);
            this.clientContainer.populateMarketSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (this.searchBar.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (mouseX >= (double)this.scrollBarXPos && mouseX <= (double)(this.scrollBarXPos + 7) && mouseY >= (double)this.scrollBarYPos && mouseY <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = (int)mouseY;
            this.indexWhenClicked = this.currentOffset;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean charTyped(char c, int keyCode) {
        boolean result = super.charTyped(c, keyCode);
        this.clientContainer.search(this.searchBar.func_146179_b());
        this.clientContainer.populateMarketSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.keyPressed(keyCode, scanCode, modifiers) || this.searchBar.isFocused()) {
            if (keyCode == 256) {
                this.getMinecraft().field_71439_g.func_71053_j();
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        for (Button button : this.filterButtons) {
            if (!button.isMouseOver((double)mouseX, (double)mouseY) || !button.active) continue;
            this.renderTooltip(((MarketFilterButton)button).getTooltipLines(), mouseX, mouseY);
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.clientContainer.isDirty()) {
            this.recalculateScrollBar();
            this.clientContainer.setDirty(false);
        }
        FontRenderer fontRenderer = this.getMinecraft().field_71466_p;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r - 10, 0, 0, this.field_146999_f, this.field_147000_g + 10);
        if (((MarketContainer)this.field_147002_h).getSelectedEntry() != null && !((MarketContainer)this.field_147002_h).isReadyToBuy()) {
            this.blit(this.field_147003_i + 43, this.field_147009_r + 40, 176, 0, 14, 14);
        }
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        fontRenderer.func_175063_a(I18n.func_135052_a((String)"container.farmingforblockheads:market", (Object[])new Object[0]), (float)(this.field_147003_i + 10), (float)(this.field_147009_r + 10), 0xFFFFFF);
        if (((MarketContainer)this.field_147002_h).getSelectedEntry() == null) {
            this.drawCenteredString(fontRenderer, I18n.func_135052_a((String)"gui.farmingforblockheads:market.no_selection", (Object[])new Object[0]), this.field_147003_i + 49, this.field_147009_r + 65, 0xFFFFFF);
        } else {
            this.drawCenteredString(fontRenderer, this.getPriceText(((MarketContainer)this.field_147002_h).getSelectedEntry()).func_150254_d(), this.field_147003_i + 49, this.field_147009_r + 65, 0xFFFFFF);
        }
        MarketScreen.fill((int)this.scrollBarXPos, (int)this.scrollBarYPos, (int)(this.scrollBarXPos + 7), (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public Collection<MarketFilterButton> getFilterButtons() {
        return this.filterButtons;
    }

    public void removed() {
        if (this.isEventHandler) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.isEventHandler = false;
        }
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f)));
        this.scrollBarXPos = this.field_147003_i + this.field_146999_f - 7 - 9;
        this.scrollBarYPos = this.field_147009_r + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.clientContainer.getFilteredListCount() / 3.0f) - 4));
        this.clientContainer.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Slot hoverSlot = this.getSlotUnderMouse();
        if (hoverSlot != null && event.getItemStack() == hoverSlot.func_75211_c()) {
            IMarketEntry hoverEntry = null;
            if (hoverSlot instanceof MarketFakeSlot) {
                hoverEntry = ((MarketFakeSlot)hoverSlot).getEntry();
            } else if (hoverSlot instanceof MarketBuySlot) {
                hoverEntry = ((MarketContainer)this.field_147002_h).getSelectedEntry();
            }
            if (hoverEntry != null) {
                event.getToolTip().add(this.getPriceTooltipText(hoverEntry));
            }
        }
    }

    private ITextComponent getPriceTooltipText(IMarketEntry entry) {
        TranslationTextComponent result = new TranslationTextComponent("gui.farmingforblockheads:market.tooltip_cost", new Object[]{this.getPriceText(entry)});
        result.func_150256_b().func_150238_a(this.getPriceColor(entry));
        return result;
    }

    private ITextComponent getPriceText(IMarketEntry entry) {
        TranslationTextComponent textComponent = new TranslationTextComponent("gui.farmingforblockheads:market.cost", new Object[]{entry.getCostItem().func_190916_E(), entry.getCostItem().func_200301_q()});
        textComponent.func_150256_b().func_150238_a(this.getPriceColor(entry));
        return textComponent;
    }

    private TextFormatting getPriceColor(IMarketEntry entry) {
        TextFormatting color = TextFormatting.GREEN;
        String unlocalizedName = entry.getCostItem().func_77977_a().toLowerCase(Locale.ENGLISH);
        if (unlocalizedName.contains("diamond")) {
            color = TextFormatting.AQUA;
        } else if (unlocalizedName.contains("gold")) {
            color = TextFormatting.YELLOW;
        } else if (unlocalizedName.contains("iron")) {
            color = TextFormatting.WHITE;
        }
        return color;
    }
}

