/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.container;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.container.MarketContainer;
import net.blay09.mods.farmingforblockheads.container.MarketFakeSlot;
import net.blay09.mods.farmingforblockheads.network.MarketSelectMessage;
import net.blay09.mods.farmingforblockheads.network.NetworkHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class MarketClientContainer
extends MarketContainer {
    private final List<IMarketEntry> itemList = Lists.newArrayList();
    private final List<IMarketEntry> filteredItems = Lists.newArrayList();
    private final Comparator<IMarketEntry> comparator = Comparator.comparingInt(o -> o.getCategory().getSortIndex());
    private String currentSearch;
    private IMarketCategory currentCategory;
    private boolean isDirty;
    private int scrollOffset;

    public MarketClientContainer(int windowId, PlayerInventory playerInventory, BlockPos pos) {
        super(windowId, playerInventory, pos);
    }

    public ItemStack func_184996_a(int slotNumber, int dragType, ClickType clickType, PlayerEntity player) {
        if (slotNumber >= 0 && slotNumber < this.field_75151_b.size()) {
            MarketFakeSlot slotMarket;
            IMarketEntry entry;
            Slot slot = (Slot)this.field_75151_b.get(slotNumber);
            if (player.field_70170_p.field_72995_K && slot instanceof MarketFakeSlot && (entry = (slotMarket = (MarketFakeSlot)slot).getEntry()) != null) {
                this.selectedEntry = entry;
                NetworkHandler.channel.sendToServer((Object)new MarketSelectMessage(entry.getOutputItem()));
            }
        }
        return super.func_184996_a(slotNumber, dragType, clickType, player);
    }

    public void search(@Nullable String term) {
        this.currentSearch = term;
        this.applyFilters();
    }

    public void setFilterCategory(@Nullable IMarketCategory category) {
        this.currentCategory = category;
        this.applyFilters();
    }

    private void applyFilters() {
        boolean hasSearchFilter;
        this.scrollOffset = 0;
        this.filteredItems.clear();
        boolean bl = hasSearchFilter = this.currentSearch != null && !this.currentSearch.trim().isEmpty();
        if (this.currentCategory == null && !hasSearchFilter) {
            this.filteredItems.addAll(this.itemList);
        } else {
            for (IMarketEntry entry : this.itemList) {
                String itemName = entry.getOutputItem().func_200301_q().func_150261_e();
                if (hasSearchFilter && !itemName.toLowerCase(Locale.ENGLISH).contains(this.currentSearch.toLowerCase()) || this.currentCategory != null && !this.currentCategory.passes(entry)) continue;
                this.filteredItems.add(entry);
            }
        }
        this.filteredItems.sort(this.comparator);
    }

    public int getFilteredListCount() {
        return this.filteredItems.size();
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.populateMarketSlots();
    }

    public void populateMarketSlots() {
        int i = this.scrollOffset * 3;
        for (MarketFakeSlot slot : this.marketSlots) {
            if (i < this.filteredItems.size()) {
                slot.setEntry(this.filteredItems.get(i));
                ++i;
                continue;
            }
            slot.setEntry(null);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void setEntryList(Collection<IMarketEntry> entryList) {
        this.itemList.clear();
        this.itemList.addAll(entryList);
        this.applyFilters();
        this.populateMarketSlots();
        this.setDirty(true);
    }

    @Nullable
    public IMarketCategory getCurrentCategory() {
        return this.currentCategory;
    }
}

