/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.entity.MerchantGoal;
import net.blay09.mods.farmingforblockheads.sound.ModSounds;
import net.blay09.mods.farmingforblockheads.tile.MarketTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.fml.network.NetworkHooks;

public class MerchantEntity
extends CreatureEntity {
    private static final Random rand = new Random();
    private BlockPos marketPos;
    private Direction facing;
    private boolean spawnAnimationStarted;
    private boolean spawnDone;
    private SpawnAnimationType spawnAnimation = SpawnAnimationType.MAGIC;
    private BlockPos marketEntityPos;
    private int diggingAnimation;
    private BlockState diggingBlockState;

    public MerchantEntity(EntityType<MerchantEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, ZombieEntity.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(5, (Goal)new MerchantGoal(this, 0.6));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        MarketTileEntity tileMarket = this.getMarketTileEntity();
        if (tileMarket != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileMarket, (BlockPos)tileMarket.func_174877_v());
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.marketPos != null) {
            compound.func_74772_a("MarketPos", this.marketPos.func_218275_a());
        }
        if (this.facing != null) {
            compound.func_74774_a("Facing", (byte)this.facing.func_176745_a());
        }
        compound.func_74757_a("SpawnDone", this.spawnDone);
        compound.func_74774_a("SpawnAnimation", (byte)this.spawnAnimation.ordinal());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!this.func_145818_k_()) {
            String merchantName = FarmingForBlockheadsConfig.getRandomMerchantName(rand);
            this.func_200203_b((ITextComponent)new StringTextComponent(merchantName));
        }
        if (compound.func_74764_b("MarketPos")) {
            this.setMarket(BlockPos.func_218283_e((long)compound.func_74763_f("MarketPos")), Direction.func_82600_a((int)compound.func_74771_c("Facing")));
        }
        this.spawnDone = compound.func_74767_n("SpawnDone");
        this.spawnAnimation = SpawnAnimationType.values()[compound.func_74771_c("SpawnAnimation")];
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public boolean func_213392_I() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && !this.isMarketValid()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)12);
            this.func_70106_y();
        }
        if (!this.spawnDone && !this.spawnAnimationStarted) {
            this.spawnAnimationStarted = true;
            switch (this.spawnAnimation) {
                case DIGGING: {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                    break;
                }
                case FALLING: {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                    break;
                }
                case MAGIC: {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)15);
                }
            }
        }
        if (this.diggingAnimation > 0) {
            --this.diggingAnimation;
            for (int i = 0; i < 4; ++i) {
                BlockState diggingState = this.diggingBlockState != null ? this.diggingBlockState : Blocks.field_150346_d.func_176223_P();
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, diggingState), this.field_70165_t, this.field_70163_u, this.field_70161_v, Math.random() * 2.0 - 1.0, Math.random() * 4.0, Math.random() * 2.0 - 1.0);
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, diggingState), this.field_70165_t, this.field_70163_u, this.field_70161_v, (Math.random() - 0.5) * 0.5, Math.random() * 0.5, (Math.random() - 0.5) * 0.5);
            }
            if (this.diggingAnimation % 2 == 0) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundType.field_185849_b.func_185846_f(), SoundCategory.BLOCKS, 1.0f, (float)(Math.random() + 0.5), false);
            }
        }
    }

    public void func_70103_a(byte id) {
        if (id == 12) {
            this.disappear();
        } else if (id == 13) {
            this.diggingBlockState = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
            this.diggingAnimation = 60;
        } else if (id == 14) {
            BlockPos pos = this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_180425_c());
            this.field_70170_p.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), ModSounds.falling, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        } else if (id == 15) {
            this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5, SoundEvents.field_187616_bj, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
            for (int i = 0; i < 50; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197629_v, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
            }
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5, 0.0, 0.0, 0.0);
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_70665_d(DamageSource damageSource, float damageAmount) {
        if (!this.spawnDone && damageSource == DamageSource.field_76379_h) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184601_bQ(damageSource), SoundCategory.NEUTRAL, 1.0f, 2.0f, false);
            this.spawnDone = true;
            return;
        }
        super.func_70665_d(damageSource, damageAmount);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.62f;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        if (Math.random() < 0.001) {
            this.func_200203_b((ITextComponent)new StringTextComponent(Math.random() <= 0.5 ? "Pam" : "Blay"));
        } else {
            String merchantName = FarmingForBlockheadsConfig.getRandomMerchantName(rand);
            this.func_200203_b((ITextComponent)new StringTextComponent(merchantName));
        }
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public void setMarket(BlockPos marketPos, Direction facing) {
        this.marketPos = marketPos;
        this.marketEntityPos = marketPos.func_177972_a(facing.func_176734_d());
        this.facing = facing;
    }

    @Nullable
    public BlockPos getMarketEntityPosition() {
        return this.marketEntityPos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAtMarket() {
        if (this.marketEntityPos == null) return false;
        Vec3d vec3d = new Vec3d((Vec3i)this.marketEntityPos.func_177972_a(this.facing.func_176734_d()));
        if (!(this.func_195048_a(vec3d) <= 1.0)) return false;
        return true;
    }

    @Nullable
    private MarketTileEntity getMarketTileEntity() {
        if (this.marketPos == null) {
            return null;
        }
        TileEntity tileEntity = this.field_70170_p.func_175625_s(this.marketPos);
        if (tileEntity instanceof MarketTileEntity) {
            return (MarketTileEntity)tileEntity;
        }
        return null;
    }

    private boolean isMarketValid() {
        return this.marketPos != null && this.field_70170_p.func_180495_p(this.marketPos).func_177230_c() == ModBlocks.market;
    }

    public void setToFacingAngle() {
        float facingAngle = this.facing.func_185119_l();
        this.func_70101_b(facingAngle, 0.0f);
        this.func_70034_d(facingAngle);
        this.func_181013_g(facingAngle);
    }

    private void disappear() {
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187616_bj, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        for (int i = 0; i < 50; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197629_v, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5);
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.0, 0.0, 0.0);
        this.func_70106_y();
    }

    public void setSpawnAnimation(SpawnAnimationType spawnAnimation) {
        this.spawnAnimation = spawnAnimation;
    }

    public int getDiggingAnimation() {
        return this.diggingAnimation;
    }

    public static enum SpawnAnimationType {
        MAGIC,
        FALLING,
        DIGGING;

    }
}

