/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.network;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import java.util.function.Supplier;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.container.MarketClientContainer;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class MarketListMessage {
    private final ArrayListMultimap<IMarketCategory, IMarketEntry> entryMap;

    public MarketListMessage(ArrayListMultimap<IMarketCategory, IMarketEntry> entryMap) {
        this.entryMap = entryMap;
    }

    public static MarketListMessage decode(PacketBuffer buf) {
        ArrayListMultimap entryMap = ArrayListMultimap.create();
        int categoryCount = buf.readByte();
        for (int i = 0; i < categoryCount; ++i) {
            ResourceLocation categoryId = buf.func_192575_l();
            IMarketCategory category = FarmingForBlockheadsAPI.getMarketCategory(categoryId);
            if (category == null) {
                category = FarmingForBlockheadsAPI.getMarketCategoryOther();
            }
            int entryCount = buf.readShort();
            for (int j = 0; j < entryCount; ++j) {
                entryMap.put((Object)category, (Object)MarketListMessage.readEntry(buf, category));
            }
        }
        return new MarketListMessage((ArrayListMultimap<IMarketCategory, IMarketEntry>)entryMap);
    }

    public static void encode(MarketListMessage message, PacketBuffer buf) {
        buf.writeByte(message.entryMap.keySet().size());
        for (IMarketCategory category : message.entryMap.keySet()) {
            buf.func_192572_a(category.getRegistryName());
            List entries = message.entryMap.get((Object)category);
            buf.writeShort(entries.size());
            for (IMarketEntry entry : entries) {
                MarketListMessage.writeEntry(entry, buf);
            }
        }
    }

    public static void handle(MarketListMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
            if (container instanceof MarketClientContainer) {
                ((MarketClientContainer)container).setEntryList(message.entryMap.values());
            }
        }));
        context.setPacketHandled(true);
    }

    private static MarketEntry readEntry(PacketBuffer buf, IMarketCategory category) {
        ItemStack outputItem = buf.func_150791_c();
        ItemStack costItem = buf.func_150791_c();
        return new MarketEntry(outputItem, costItem, category);
    }

    private static void writeEntry(IMarketEntry entry, PacketBuffer buf) {
        buf.func_150788_a(entry.getOutputItem());
        buf.func_150788_a(entry.getCostItem());
    }
}

