/*
 * Decompiled with CFR 0.152.
 */
package koala.fishingreal;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import koala.fishingreal.util.JsonUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class FishingConversion {
    protected ItemStack stack;
    protected CompoundNBT target;
    protected boolean randomizeNBT;

    public FishingConversion(ItemStack stack, CompoundNBT target, boolean randomizeNBT) {
        this.stack = stack;
        this.target = target;
        this.randomizeNBT = randomizeNBT;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public CompoundNBT getTarget() {
        return this.target;
    }

    public boolean isRandomizeNBT() {
        return this.randomizeNBT;
    }

    public static class Serializer
    implements JsonDeserializer<FishingConversion>,
    JsonSerializer<FishingConversion> {
        public FishingConversion deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            ItemStack stack = JsonUtils.deserializeItemStack(obj.get("input").getAsJsonObject());
            JsonObject result = obj.get("result").getAsJsonObject();
            String id = result.get("id").getAsString();
            CompoundNBT nbt = null;
            if (result.has("nbt")) {
                nbt = JsonUtils.deserializeCompoundNBT(result.get("nbt").getAsJsonObject());
            }
            CompoundNBT target = new CompoundNBT();
            target.func_74778_a("id", id);
            if (nbt != null) {
                target.func_197643_a(nbt);
            }
            return new FishingConversion(stack, target, nbt == null);
        }

        public JsonElement serialize(FishingConversion src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("input", (JsonElement)JsonUtils.serializeItemStack(src.stack));
            obj.add("result", (JsonElement)JsonUtils.serializeCompoundNBT(src.target));
            return obj;
        }
    }
}

