/*
 * Decompiled with CFR 0.152.
 */
package koala.fishingreal;

import java.util.Arrays;
import koala.fishingreal.FishingManager;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fishingreal")
public class FishingReal {
    public static final Logger LOGGER = LogManager.getLogger((String)"FishingReal");
    public static final FishingManager FISHING_MANAGER = new FishingManager();

    public FishingReal() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerAboutToStartEvent event) {
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)FISHING_MANAGER);
    }

    @SubscribeEvent
    public void itemFished(ItemFishedEvent event) {
        PlayerEntity angler = event.getPlayer();
        FishingBobberEntity hook = event.getHookEntity();
        NonNullList drops = event.getDrops();
        for (ItemStack stack : drops) {
            CompoundNBT nbt = FISHING_MANAGER.matchWithStack(stack);
            if (nbt == null) continue;
            EntityType.func_220335_a((CompoundNBT)nbt, (World)angler.func_130014_f_(), entity -> {
                World w = angler.func_130014_f_();
                if (w instanceof ServerWorld) {
                    ServerWorld world = (ServerWorld)w;
                    entity.func_70012_b(hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, hook.field_70177_z, hook.field_70125_A);
                    double dX = angler.field_70165_t - hook.field_70165_t;
                    double dY = angler.field_70163_u - hook.field_70163_u;
                    double dZ = angler.field_70161_v - hook.field_70161_v;
                    double mult = 0.12;
                    entity.func_213293_j(dX * mult, dY * mult + Math.sqrt(Math.sqrt(dX * dX + dY * dY + dZ * dZ)) * 0.14, dZ * mult);
                    world.func_217376_c((Entity)new ExperienceOrbEntity(angler.field_70170_p, angler.field_70165_t, angler.field_70163_u + 0.5, angler.field_70161_v + 0.5, angler.field_70170_p.func_201674_k().nextInt(6) + 1));
                    if (stack.func_77973_b().func_206844_a(ItemTags.field_206964_G)) {
                        angler.func_195067_a(Stats.field_188071_E, 1);
                    }
                    if (angler instanceof ServerPlayerEntity) {
                        CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)angler, angler.func_184607_cu(), hook, Arrays.asList(stack));
                    }
                    if (FISHING_MANAGER.getConversionFromStack(stack).isRandomizeNBT() && entity instanceof MobEntity) {
                        ((MobEntity)entity).func_213386_a((IWorld)world, world.func_175649_E(angler.func_180425_c()), SpawnReason.NATURAL, null, null);
                    }
                    return !world.func_217470_d(entity) ? null : entity;
                }
                return null;
            });
            if (!angler.func_184812_l_()) {
                event.damageRodBy(1);
            }
            event.setCanceled(true);
        }
    }
}

