/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.world;

import com.google.common.base.Predicate;
import com.kwpugh.gobber2.lists.BlockList;
import com.kwpugh.gobber2.world.DimensionalGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.CompositeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MinableConfig;
import net.minecraft.world.gen.placement.BasePlacement;
import net.minecraft.world.gen.placement.CountRange;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class OreGeneration {
    private static final Predicate<IBlockState> IS_NETHERRACK = state -> state.func_177230_c() == Blocks.field_150424_aL;
    private static final Predicate<IBlockState> IS_ENDSTONE = state -> state.func_177230_c() == Blocks.field_150377_bs;

    public static void setupOreGeneration() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            CountRangeConfig gobber2_ore_placement = new CountRangeConfig(1, 20, 20, 30);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, new CompositeFeature(Feature.field_202290_aj, (IFeatureConfig)new MinableConfig(MinableConfig.field_202441_a, BlockList.gobber2_ore.func_176223_P(), 20), (BasePlacement)new CountRange(), (IPlacementConfig)gobber2_ore_placement));
            CountRangeConfig gobber2_ore_nether_placement = new CountRangeConfig(1, 0, 0, 256);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, new DimensionalGenerator<MinableConfig, CountRangeConfig>((Feature<MinableConfig>)Feature.field_202290_aj, new MinableConfig(IS_NETHERRACK, BlockList.gobber2_ore_nether.func_176223_P(), 20), (BasePlacement<CountRangeConfig>)new CountRange(), gobber2_ore_nether_placement, DimensionType.NETHER));
            CountRangeConfig gobber2_ore_end_placement = new CountRangeConfig(1, 0, 0, 256);
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, new DimensionalGenerator<MinableConfig, CountRangeConfig>((Feature<MinableConfig>)Feature.field_202290_aj, new MinableConfig(IS_ENDSTONE, BlockList.gobber2_ore_end.func_176223_P(), 20), (BasePlacement<CountRangeConfig>)new CountRange(), gobber2_ore_end_placement, DimensionType.THE_END));
        }
    }
}

