/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.blocks;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockLooter
extends Block {
    int radius = (Integer)GobberConfigBuilder.LOOTER_RADIUS.get();
    int minTickTime = 5;
    int maxTickTime = 20;

    public BlockLooter(Block.Properties properties) {
        super(properties);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), world.field_73012_v.nextInt(this.maxTickTime - this.minTickTime + 1));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), worldIn.field_73012_v.nextInt(this.maxTickTime - this.minTickTime + 1));
        if (worldIn.field_72995_K) {
            player.func_145747_a(new TranslationTextComponent("item.gobber2.block_looter.line1", new Object[]{this.radius}).func_211708_a(TextFormatting.GREEN));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world) + random.nextInt(10));
            BlockPos posUp = pos.func_177984_a();
            BlockState flaming = ((FireBlock)Blocks.field_150480_ab).func_196448_a((IBlockReader)world, posUp);
            world.func_180501_a(posUp, flaming, 11);
            List mobs = world.func_175647_a(LivingEntity.class, new AxisAlignedBB((double)(pos.func_177958_n() - this.radius), (double)(pos.func_177956_o() - this.radius), (double)(pos.func_177952_p() - this.radius), (double)(pos.func_177958_n() + this.radius), (double)(pos.func_177956_o() + this.radius), (double)(pos.func_177952_p() + this.radius)), e -> e instanceof LivingEntity);
            for (Entity mob : mobs) {
                ItemStack drop;
                if (mob instanceof ZombieEntity || mob instanceof ZombieVillagerEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_151043_k);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (mob instanceof SpiderEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_151007_F);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (mob instanceof SkeletonEntity || mob instanceof StrayEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_151103_aS);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (mob instanceof PillagerEntity || mob instanceof RavagerEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_151042_j);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (mob instanceof CreeperEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_151016_H);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (mob instanceof SlimeEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_151123_aH);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (mob instanceof WitchEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_151166_bC);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (mob instanceof EndermanEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_151079_bi);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (mob instanceof BlazeEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_151072_bj);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (mob instanceof WitherSkeletonEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_196183_dw);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (mob instanceof PhantomEntity) {
                    ((MobEntity)mob).func_70656_aK();
                    mob.remove(true);
                    drop = new ItemStack((IItemProvider)Items.field_204840_eX);
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                    world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
                }
                if (!(mob instanceof VindicatorEntity) && !(mob instanceof SpellcastingIllagerEntity)) continue;
                ((MobEntity)mob).func_70656_aK();
                mob.remove(true);
                drop = new ItemStack((IItemProvider)Items.field_151045_i);
                world.func_217376_c((Entity)new ItemEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), drop));
                world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, (double)(pos.func_177958_n() + 3), (double)pos.func_177956_o(), (double)(pos.func_177952_p() + 3), 1));
            }
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("item.gobber2.block_looter.line2", new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent("item.gobber2.block_looter.line3", new Object[]{this.radius}).func_211708_a(TextFormatting.LIGHT_PURPLE));
    }
}

