/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.blocks;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.BambooSaplingBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.ChorusFlowerBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CoralBlock;
import net.minecraft.block.CoralPlantBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.MelonBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.PumpkinBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SeaGrassBlock;
import net.minecraft.block.SeaPickleBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.block.TallSeaGrassBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockMaturator
extends Block {
    int radius = (Integer)GobberConfigBuilder.MATURATOR_RADIUS.get();
    int rediusVertical = (Integer)GobberConfigBuilder.MATURATOR_VERTICAL_RANGE.get();
    int minTickTime = (Integer)GobberConfigBuilder.MATURATOR_MIN_TICK.get();
    int maxTickTime = (Integer)GobberConfigBuilder.MATURATOR_MAX_TICK.get();

    public BlockMaturator(Block.Properties properties) {
        super(properties);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), world.field_73012_v.nextInt(this.maxTickTime - this.minTickTime + 1));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), worldIn.field_73012_v.nextInt(this.maxTickTime - this.minTickTime + 1));
        if (worldIn.field_72995_K) {
            player.func_145747_a(new TranslationTextComponent("item.gobber2.block_maturator.line1", new Object[]{this.radius}).func_211708_a(TextFormatting.GREEN));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        boolean enableMaturatorAnimalEffect = (Boolean)GobberConfigBuilder.ENABLE_MATURATOR_ANIMAL_EFFECT.get();
        if (!world.field_72995_K) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world) + rand.nextInt(this.minTickTime));
            BlockPos posUp = pos.func_177984_a();
            BlockState flaming = ((FireBlock)Blocks.field_150480_ab).func_196448_a((IBlockReader)world, posUp);
            world.func_180501_a(posUp, flaming, 11);
            for (BlockPos targetPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-this.radius, -2, -this.radius), (BlockPos)pos.func_177982_a(this.radius, this.rediusVertical, this.radius))) {
                BlockState state1 = world.func_180495_p(targetPos);
                if (!(state1.func_177230_c() instanceof CropsBlock) && !(state1.func_177230_c() instanceof SaplingBlock) && !(state1.func_177230_c() instanceof VineBlock) && !(state1.func_177230_c() instanceof SugarCaneBlock) && !(state1.func_177230_c() instanceof SweetBerryBushBlock) && !(state1.func_177230_c() instanceof NetherWartBlock) && !(state1.func_177230_c() instanceof CactusBlock) && !(state1.func_177230_c() instanceof MelonBlock) && !(state1.func_177230_c() instanceof StemBlock) && !(state1.func_177230_c() instanceof PumpkinBlock) && !(state1.func_177230_c() instanceof CoralBlock) && !(state1.func_177230_c() instanceof BambooSaplingBlock) && !(state1.func_177230_c() instanceof BambooBlock) && !(state1.func_177230_c() instanceof CocoaBlock) && !(state1.func_177230_c() instanceof StemGrownBlock) && !(state1.func_177230_c() instanceof CoralPlantBlock) && !(state1.func_177230_c() instanceof CoralBlock) && !(state1.func_177230_c() instanceof TallSeaGrassBlock) && !(state1.func_177230_c() instanceof SeaGrassBlock) && !(state1.func_177230_c() instanceof SeaPickleBlock) && !(state1.func_177230_c() instanceof ChorusFlowerBlock)) continue;
                state1.func_227033_a_(world, targetPos, world.field_73012_v);
            }
            if (enableMaturatorAnimalEffect) {
                List entities = world.func_175647_a(AnimalEntity.class, new AxisAlignedBB((double)(pos.func_177958_n() - this.radius), (double)(pos.func_177956_o() - this.radius), (double)(pos.func_177952_p() - this.radius), (double)(pos.func_177958_n() + this.radius), (double)(pos.func_177956_o() + this.radius), (double)(pos.func_177952_p() + this.radius)), e -> e instanceof LivingEntity);
                for (Entity entity : entities) {
                    ((AgeableEntity)entity).func_175501_a(120, true);
                }
            }
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("item.gobber2.block_maturator.line2", new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent("item.gobber2.block_maturator.line3", new Object[]{this.radius}).func_211708_a(TextFormatting.LIGHT_PURPLE));
    }
}

