/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.blocks;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockProtector
extends Block {
    int radius = (Integer)GobberConfigBuilder.PROTECTOR_RADIUS.get();
    int minTickTime = 5;
    int maxTickTime = 20;

    public BlockProtector(Block.Properties properties) {
        super(properties);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), world.field_73012_v.nextInt(this.maxTickTime - this.minTickTime + 1));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), worldIn.field_73012_v.nextInt(this.maxTickTime - this.minTickTime + 1));
        if (worldIn.field_72995_K) {
            player.func_145747_a(new TranslationTextComponent("item.gobber2.block_protector.line1", new Object[]{this.radius}).func_211708_a(TextFormatting.GREEN));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), random.nextInt(this.minTickTime));
            BlockPos posUp = pos.func_177984_a();
            BlockState flaming = ((FireBlock)Blocks.field_150480_ab).func_196448_a((IBlockReader)world, posUp);
            world.func_180501_a(posUp, flaming, 11);
            List entities = world.func_175647_a(LivingEntity.class, new AxisAlignedBB((double)(pos.func_177958_n() - this.radius), (double)(pos.func_177956_o() - this.radius), (double)(pos.func_177952_p() - this.radius), (double)(pos.func_177958_n() + this.radius), (double)(pos.func_177956_o() + this.radius), (double)(pos.func_177952_p() + this.radius)), e -> e instanceof LivingEntity);
            for (Entity entity : entities) {
                EntityClassification isCreature;
                if (entity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity;
                    int newfoodlevel = 1;
                    float newsatlevel = 0.035f;
                    PlayerSpecialAbilities.giveRegenEffect((World)world, player, null, newfoodlevel, newsatlevel);
                }
                if ((isCreature = entity.getEntity().getClassification(true)) == EntityClassification.CREATURE || entity instanceof PlayerEntity || entity instanceof ArmorStandEntity || entity instanceof VillagerEntity || entity instanceof WanderingTraderEntity || entity instanceof AnimalEntity || entity instanceof IronGolemEntity || entity instanceof DolphinEntity || entity instanceof WaterMobEntity || entity instanceof GuardianEntity || entity instanceof ElderGuardianEntity || entity instanceof SpellcastingIllagerEntity || entity instanceof VexEntity || entity instanceof VindicatorEntity || entity instanceof GhastEntity || entity instanceof BlazeEntity || entity instanceof WitherSkeletonEntity || entity instanceof WitherEntity || entity instanceof EnderDragonEntity || !(entity instanceof MobEntity)) continue;
                ((MobEntity)entity).func_70656_aK();
                entity.remove(true);
            }
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("item.gobber2.block_protector.line2", new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent("item.gobber2.block_protector.line3", new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent("item.gobber2.block_protector.line4", new Object[]{this.radius}).func_211708_a(TextFormatting.LIGHT_PURPLE));
    }
}

