/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomArmorDragon
extends ArmorItem {
    public ItemCustomArmorDragon(IArmorMaterial materialIn, EquipmentSlotType slots, Item.Properties builder) {
        super(materialIn, slots, builder);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!player.getPersistentData().func_74764_b("wearingFullDragonArmor")) {
            player.getPersistentData().func_74757_a("wearingFullDragonArmor", false);
        }
        ItemStack head = player.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        ItemStack legs = player.func_184582_a(EquipmentSlotType.LEGS);
        ItemStack feet = player.func_184582_a(EquipmentSlotType.FEET);
        this.setDamage(head, 0);
        this.setDamage(chest, 0);
        this.setDamage(legs, 0);
        this.setDamage(feet, 0);
        boolean iswearingFullDragonArmor = head != null && head.func_77973_b() == ItemInit.GOBBER2_HELMET_DRAGON.get() && chest != null && chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get() && legs != null && legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS_DRAGON.get() && feet != null && feet.func_77973_b() == ItemInit.GOBBER2_BOOTS_DRAGON.get();
        boolean wasWearingDragonArmorLastTick = player.getPersistentData().func_74767_n("wearingFullDragonArmor");
        if (!iswearingFullDragonArmor && wasWearingDragonArmorLastTick && !player.func_184812_l_()) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
        } else if (iswearingFullDragonArmor && (player.field_71093_bK.func_186068_a() == -1 || player.field_71093_bK.func_186068_a() == 0 || player.field_71093_bK.func_186068_a() == 1)) {
            player.field_71075_bZ.field_75101_c = true;
        }
        player.getPersistentData().func_74757_a("wearingFullDragonArmor", iswearingFullDragonArmor);
        if (iswearingFullDragonArmor) {
            player.func_184596_c(Effects.field_76440_q);
            player.func_184596_c(Effects.field_76421_d);
            player.func_184596_c(Effects.field_76419_f);
            player.func_184596_c(Effects.field_76433_i);
            player.func_184596_c(Effects.field_76431_k);
            player.func_184596_c(Effects.field_76438_s);
            player.func_184596_c(Effects.field_76436_u);
            player.func_184596_c(Effects.field_82731_v);
            player.func_184596_c(Effects.field_188424_y);
            player.func_184596_c(Effects.field_189112_A);
            player.func_184596_c(Effects.field_76437_t);
        }
        if (head.func_77973_b() == ItemInit.GOBBER2_HELMET_DRAGON.get()) {
            PlayerSpecialAbilities.giveYellowHearts(world, (LivingEntity)player, stack, 20, 0.66f);
            PlayerSpecialAbilities.giveRegenEffect(world, player, stack, 1, 0.15f);
        } else {
            PlayerSpecialAbilities.giveNoExtraHearts(world, player, stack);
        }
        if (chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get()) {
            player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(40.0);
        }
        if (legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS_DRAGON.get()) {
            PlayerSpecialAbilities.giveConduitEffect(world, player, stack);
        }
        if (feet.func_77973_b() == ItemInit.GOBBER2_BOOTS_DRAGON.get()) {
            PlayerSpecialAbilities.giveDolphinEffect(world, player, stack);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ItemInit.GOBBER2_ARMOR_REPAIR.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor_dragon.line1", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor_dragon.line2", new Object[0]).func_211708_a(TextFormatting.GOLD));
    }
}

