/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomArmorGobber
extends ArmorItem {
    public ItemCustomArmorGobber(IArmorMaterial materialIn, EquipmentSlotType slots, Item.Properties builder) {
        super(materialIn, slots, builder);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (player instanceof PlayerEntity) {
            ItemStack head = player.func_184582_a(EquipmentSlotType.HEAD);
            ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
            ItemStack legs = player.func_184582_a(EquipmentSlotType.LEGS);
            ItemStack feet = player.func_184582_a(EquipmentSlotType.FEET);
            if (head.func_77973_b() == ItemInit.GOBBER2_HELMET.get() && chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE.get() && legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS.get() && feet.func_77973_b() == ItemInit.GOBBER2_BOOTS.get()) {
                player.func_184596_c(Effects.field_76436_u);
            }
            if (head.func_77973_b() == ItemInit.GOBBER2_HELMET.get()) {
                PlayerSpecialAbilities.giveRegenEffect(world, player, stack, 1, 0.0f);
            }
            if (chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE.get()) {
                // empty if block
            }
            if (legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS.get()) {
                // empty if block
            }
            if (feet.func_77973_b() == ItemInit.GOBBER2_BOOTS.get()) {
                // empty if block
            }
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ItemInit.GOBBER2_ARMOR_REPAIR.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor.line1", new Object[0]).func_211708_a(TextFormatting.AQUA));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor.line2", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor.line3", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor.line4", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor.line5", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor.line6", new Object[0]).func_211708_a(TextFormatting.GOLD));
    }
}

