/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomArmorNether
extends ArmorItem {
    public ItemCustomArmorNether(IArmorMaterial materialIn, EquipmentSlotType slots, Item.Properties builder) {
        super(materialIn, slots, builder);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        ItemStack head = player.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        ItemStack legs = player.func_184582_a(EquipmentSlotType.LEGS);
        ItemStack feet = player.func_184582_a(EquipmentSlotType.FEET);
        if (head.func_77973_b() == ItemInit.GOBBER2_HELMET_NETHER.get() && chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE_NETHER.get() && legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS_NETHER.get() && feet.func_77973_b() == ItemInit.GOBBER2_BOOTS_NETHER.get()) {
            player.func_184596_c(Effects.field_76436_u);
            player.func_184596_c(Effects.field_82731_v);
        }
        if (head.func_77973_b() == ItemInit.GOBBER2_HELMET_NETHER.get()) {
            PlayerSpecialAbilities.giveYellowHearts(world, (LivingEntity)player, stack, 4, 0.33f);
            PlayerSpecialAbilities.giveRegenEffect(world, player, stack, 1, 0.05f);
        }
        if (chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE_NETHER.get()) {
            player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(40.0);
        }
        if (legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS_NETHER.get()) {
            // empty if block
        }
        if (feet.func_77973_b() == ItemInit.GOBBER2_BOOTS_NETHER.get()) {
            // empty if block
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ItemInit.GOBBER2_ARMOR_REPAIR.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor_nether.line1", new Object[0]).func_211708_a(TextFormatting.AQUA));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor_nether.line2", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor_nether.line3", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor_nether.line4", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor_nether.line5", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_armor_nether.line6", new Object[0]).func_211708_a(TextFormatting.GOLD));
    }
}

