/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemCustomRingLumberjack
extends Item {
    int ringLumberjackCooldown = (Integer)GobberConfigBuilder.RING_LUMBERJACK_COOLDOWN.get();
    public static final int BREAK_DELAY = 1;
    boolean delayedBreakMode = (Boolean)GobberConfigBuilder.DELAY_BREAK_MODE.get();
    boolean shiftKeyPressed = false;

    public ItemCustomRingLumberjack(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(final World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack equippedMain = player.func_184614_ca();
        if (equippedMain == stack) {
            this.shiftKeyPressed = player.func_225608_bj_();
            player.func_184811_cZ().func_185145_a((Item)this, this.ringLumberjackCooldown);
            if (!world.field_72995_K) {
                Block block;
                final ArrayList<BlockPos> poslist = new ArrayList<BlockPos>();
                for (int x = -5; x <= 5; ++x) {
                    for (int y = -2; y <= 40; ++y) {
                        for (int z = -5; z <= 5; ++z) {
                            BlockPos pos = player.func_180425_c().func_177982_a(x, y, z);
                            block = world.func_180495_p(pos).func_177230_c();
                            if (!(block instanceof LeavesBlock) && !(block instanceof LogBlock) && !(block instanceof MushroomBlock) && !block.func_203417_a(BlockTags.field_206952_E) && !block.func_203417_a(BlockTags.field_200031_h) && block != Blocks.field_150420_aW && block != Blocks.field_196706_do && block != Blocks.field_150419_aX && !(block instanceof VineBlock)) continue;
                            poslist.add(player.func_180425_c().func_177982_a(x, y, z));
                        }
                    }
                }
                if (this.delayedBreakMode) {
                    if (!poslist.isEmpty()) {
                        MinecraftForge.EVENT_BUS.register(new Object(){
                            int delay = 1;
                            int i = 0;

                            @SubscribeEvent
                            public void onTick(TickEvent.WorldTickEvent event) {
                                if (this.delay-- > 0) {
                                    return;
                                }
                                this.delay = 1;
                                if (this.i < poslist.size()) {
                                    BlockPos breakPos = (BlockPos)poslist.get(this.i);
                                    if (ItemCustomRingLumberjack.this.shiftKeyPressed) {
                                        world.func_175655_b(breakPos, false);
                                    } else {
                                        world.func_175655_b(breakPos, true);
                                    }
                                    ++this.i;
                                } else {
                                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                                }
                            }
                        });
                    }
                } else {
                    for (int i = 0; i <= poslist.size() - 1; ++i) {
                        BlockPos targetpos = (BlockPos)poslist.get(i);
                        block = world.func_180495_p(targetpos).func_177230_c();
                        if (player.func_225608_bj_()) {
                            world.func_175655_b(targetpos, false);
                            continue;
                        }
                        world.func_175655_b(targetpos, true);
                    }
                }
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_lumberjack.line1", new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_lumberjack.line2", new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_lumberjack.line3", new Object[0]).func_211708_a(TextFormatting.YELLOW));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_lumberjack.line4", new Object[0]).func_211708_a(TextFormatting.YELLOW));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring.cooldown", new Object[]{this.ringLumberjackCooldown}).func_211708_a(TextFormatting.LIGHT_PURPLE));
    }
}

