/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.GravelBlock;
import net.minecraft.block.SandBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemCustomRingMiner
extends Item {
    public static final int BREAK_DELAY = 1;
    int ringMinerCooldown = (Integer)GobberConfigBuilder.RING_MINER_COOLDOWN.get();
    boolean reverseRingMiner = (Boolean)GobberConfigBuilder.REVERSE_RING_MINER.get();
    boolean delayedBreakMode = (Boolean)GobberConfigBuilder.DELAY_BREAK_MODE.get();
    boolean shiftKeyPressed = false;

    public ItemCustomRingMiner(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(final World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack equippedMain = player.func_184614_ca();
        if (equippedMain == stack) {
            this.shiftKeyPressed = player.func_225608_bj_();
            player.func_184811_cZ().func_185145_a((Item)this, this.ringMinerCooldown);
            if (!world.field_72995_K) {
                Block block;
                final ArrayList<BlockPos> poslist = new ArrayList<BlockPos>();
                for (int x = -5; x <= 5; ++x) {
                    for (int y = 0; y <= 4; ++y) {
                        for (int z = -5; z <= 5; ++z) {
                            BlockPos pos = player.func_180425_c().func_177982_a(x, y, z);
                            block = world.func_180495_p(pos).func_177230_c();
                            String blockForgeTags = block.getTags().toString();
                            if (block != Blocks.field_150348_b && !blockForgeTags.contains("forge:stone") && !blockForgeTags.contains("forge:sandstone") && !blockForgeTags.contains("forge:sand") && !blockForgeTags.contains("forge:dirt") && !blockForgeTags.contains("forge:gravel") && !(block instanceof GravelBlock) && !(block instanceof SandBlock) && block != Blocks.field_150346_d && block != Blocks.field_185774_da && block != Blocks.field_150354_m && block != Blocks.field_196611_F && block != Blocks.field_150322_A && block != Blocks.field_180395_cM && block != Blocks.field_150351_n && block != Blocks.field_196658_i && block != Blocks.field_196660_k && block != Blocks.field_196661_l && block != Blocks.field_150391_bh && block != Blocks.field_196650_c && block != Blocks.field_196656_g && block != Blocks.field_196654_e && block != Blocks.field_196654_e && block != Blocks.field_150425_aM && block != Blocks.field_150341_Y && block != Blocks.field_222450_ln && block != Blocks.field_222411_kZ && block != Blocks.field_196698_dj && block != Blocks.field_222409_kX && block != Blocks.field_222448_ll && block != Blocks.field_196696_di && block != Blocks.field_150390_bg && block != Blocks.field_196573_bB && block != Blocks.field_196700_dk && block != Blocks.field_196692_dg && block != Blocks.field_196694_dh && block != Blocks.field_196687_dd && block != Blocks.field_196690_df && block != Blocks.field_150377_bs && block != Blocks.field_150424_aL) continue;
                            poslist.add(player.func_180425_c().func_177982_a(x, y, z));
                        }
                    }
                }
                if (this.delayedBreakMode) {
                    if (!poslist.isEmpty()) {
                        MinecraftForge.EVENT_BUS.register(new Object(){
                            int delay = 1;
                            int i = 0;

                            @SubscribeEvent
                            public void onTick(TickEvent.WorldTickEvent event) {
                                if (this.delay-- > 0) {
                                    return;
                                }
                                this.delay = 1;
                                if (this.i < poslist.size()) {
                                    BlockPos breakPos = (BlockPos)poslist.get(this.i);
                                    if (ItemCustomRingMiner.this.shiftKeyPressed) {
                                        world.func_175655_b(breakPos, !ItemCustomRingMiner.this.reverseRingMiner);
                                    } else {
                                        world.func_175655_b(breakPos, ItemCustomRingMiner.this.reverseRingMiner);
                                    }
                                    ++this.i;
                                } else {
                                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                                }
                            }
                        });
                    }
                } else if (!poslist.isEmpty()) {
                    for (int i = 0; i <= poslist.size() - 1; ++i) {
                        BlockPos targetpos = (BlockPos)poslist.get(i);
                        block = world.func_180495_p(targetpos).func_177230_c();
                        if (player.func_225608_bj_()) {
                            world.func_175655_b(targetpos, !this.reverseRingMiner);
                            continue;
                        }
                        world.func_175655_b(targetpos, this.reverseRingMiner);
                    }
                }
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_miner.line1", new Object[0]).func_211708_a(TextFormatting.GREEN));
        if (this.reverseRingMiner) {
            tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_miner.line4", new Object[0]).func_211708_a(TextFormatting.YELLOW));
            tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_miner.line5", new Object[0]).func_211708_a(TextFormatting.YELLOW));
        } else {
            tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_miner.line2", new Object[0]).func_211708_a(TextFormatting.YELLOW));
            tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_miner.line3", new Object[0]).func_211708_a(TextFormatting.YELLOW));
        }
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_miner.line6", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring.cooldown", new Object[]{this.ringMinerCooldown}).func_211708_a(TextFormatting.LIGHT_PURPLE));
        if (this.delayedBreakMode) {
            tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_miner.mode.line2", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        } else {
            tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_miner.mode.line1", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        }
    }
}

