/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomRingTeleport
extends Item {
    public ItemCustomRingTeleport(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        Direction direction = context.func_196000_l();
        ItemStack stackRing = context.func_195999_j().func_184614_ca();
        if (ItemCustomRingTeleport.getPosition(stackRing) == null && player.func_225608_bj_()) {
            ItemCustomRingTeleport.setPosition(stackRing, world, pos.func_177972_a(direction), player);
            if (!world.field_72995_K) {
                player.func_145747_a(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line1", new Object[0]).func_211708_a(TextFormatting.GREEN));
            }
            return ActionResultType.SUCCESS;
        }
        if (ItemCustomRingTeleport.getPosition(stackRing) != null) {
            if (!world.field_72995_K) {
                player.func_145747_a(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line2", new Object[0]).func_211708_a(TextFormatting.GREEN));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemCustomRingTeleport.getPosition(stack) != null && !player.func_225608_bj_()) {
            this.teleport(player, world, stack);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (ItemCustomRingTeleport.getPosition(stack) != null && player.func_225608_bj_()) {
            ItemCustomRingTeleport.setPosition(stack, world, null, player);
            if (!world.field_72995_K) {
                player.func_145747_a(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line3", new Object[0]).func_211708_a(TextFormatting.GREEN));
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public static BlockPos getPosition(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT tags = stack.func_77978_p();
        if (tags.func_74764_b("pos")) {
            return NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)tags.func_74781_a("pos")));
        }
        return null;
    }

    public static int getDimension(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Integer.MAX_VALUE;
        }
        CompoundNBT tags = stack.func_77978_p();
        if (tags.func_74764_b("dim")) {
            return tags.func_74762_e("dim");
        }
        return Integer.MAX_VALUE;
    }

    public static void setPosition(ItemStack stack, World world, BlockPos pos, PlayerEntity player) {
        if (world.field_72995_K) {
            return;
        }
        CompoundNBT tags = !stack.func_77942_o() ? new CompoundNBT() : stack.func_77978_p();
        if (pos == null) {
            tags.func_82580_o("pos");
            tags.func_82580_o("dim");
        } else {
            tags.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            tags.func_74768_a("dim", player.field_71093_bK.func_186068_a());
        }
        stack.func_77982_d(tags);
    }

    public void teleport(PlayerEntity player, World world, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        int currentDim = player.field_71093_bK.func_186068_a();
        BlockPos pos = ItemCustomRingTeleport.getPosition(stack);
        if (ItemCustomRingTeleport.getDimension(stack) == currentDim) {
            player.func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
        }
        if (ItemCustomRingTeleport.getDimension(stack) != currentDim) {
            if (ItemCustomRingTeleport.getDimension(stack) == 0) {
                player.func_212321_a(DimensionType.field_223227_a_);
                player.func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                if (!world.field_72995_K) {
                    player.func_145747_a(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line4", new Object[0]).func_211708_a(TextFormatting.GREEN));
                }
            } else if (ItemCustomRingTeleport.getDimension(stack) == 1) {
                player.func_212321_a(DimensionType.field_223229_c_);
                player.func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                if (!world.field_72995_K) {
                    player.func_145747_a(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line5", new Object[0]).func_211708_a(TextFormatting.GREEN));
                }
            } else if (ItemCustomRingTeleport.getDimension(stack) == -1) {
                player.func_212321_a(DimensionType.field_223228_b_);
                player.func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                if (!world.field_72995_K) {
                    player.func_145747_a(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line6", new Object[0]).func_211708_a(TextFormatting.GREEN));
                }
            } else if (!world.field_72995_K) {
                player.func_145747_a(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line7", new Object[0]).func_211708_a(TextFormatting.GREEN));
                player.func_145747_a(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line8", new Object[0]).func_211708_a(TextFormatting.GREEN));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String dimName;
        switch (ItemCustomRingTeleport.getDimension(stack)) {
            case 1: {
                dimName = "End";
                break;
            }
            case 0: {
                dimName = "OverWorld";
                break;
            }
            case -1: {
                dimName = "Nether";
                break;
            }
            default: {
                dimName = "Unknown";
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line9", new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line10", new Object[0]).func_211708_a(TextFormatting.GREEN));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line11", new Object[0]).func_211708_a(TextFormatting.YELLOW));
        tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line12", new Object[0]).func_211708_a(TextFormatting.LIGHT_PURPLE));
        if (ItemCustomRingTeleport.getPosition(stack) != null) {
            BlockPos pos = ItemCustomRingTeleport.getPosition(stack);
            tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line13", new Object[0]).func_211708_a(TextFormatting.RED));
            tooltip.add(new TranslationTextComponent("item.gobber2.gobber2_ring_teleport.line14", new Object[]{dimName, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}).func_211708_a(TextFormatting.LIGHT_PURPLE));
        }
    }
}

