/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util.handlers;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.util.PlayerEquipsUtil;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.OreBlock;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gobber2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    static int extraXPOrbs = (Integer)GobberConfigBuilder.MEDALLION_EXP_ORBS.get();
    static int extraLoot = (Integer)GobberConfigBuilder.MEDALLION_EXP_LOOT.get();
    static boolean enableVoidProtection = (Boolean)GobberConfigBuilder.ENABLE_DRAGON_ARMOR_VOID_PROTECTION.get();

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onLivingHurtEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (enableVoidProtection && event.getSource() == DamageSource.field_76380_i && PlayerEquipsUtil.isPlayerGotVoidProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.field_76379_h && PlayerEquipsUtil.isPlayerGotFallProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if ((event.getSource() == DamageSource.field_76372_a || event.getSource() == DamageSource.field_76370_b || event.getSource() == DamageSource.field_76371_c) && PlayerEquipsUtil.isPlayerGotFireProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.field_76369_e && PlayerEquipsUtil.isPlayerGotWaterBreathing(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity) {
            PlayerEntity player = (PlayerEntity)event.getTarget();
            MobEntity attacker = (MobEntity)event.getEntityLiving();
            if (PlayerEquipsUtil.isPlayerGotStealth(player)) {
                attacker.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void onKillingLootEvent(LootingLevelEvent event) {
        PlayerEntity player;
        if (event.getEntity() instanceof MobEntity && event.getDamageSource().func_76346_g() instanceof PlayerEntity && PlayerEquipsUtil.isPlayerGotExpToken(player = (PlayerEntity)event.getDamageSource().func_76346_g())) {
            event.setLootingLevel(extraLoot);
        }
    }

    @SubscribeEvent
    public static void onMiningFortuneEvent(BlockEvent.HarvestDropsEvent event) {
        PlayerEntity player;
        if (event.getState().func_177230_c() instanceof OreBlock && event.getHarvester() instanceof PlayerEntity && PlayerEquipsUtil.isPlayerGotExpToken(player = event.getHarvester())) {
            event.setDropChance(1.0f);
        }
    }

    @SubscribeEvent
    public static void onKillingExpDropEvent(LivingExperienceDropEvent event) {
        PlayerEntity player;
        if (event.getAttackingPlayer() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity && PlayerEquipsUtil.isPlayerGotExpToken(player = event.getAttackingPlayer())) {
            int orgExp = event.getOriginalExperience();
            int newExp = orgExp * extraXPOrbs;
            event.setDroppedExperience(newExp);
        }
    }

    @SubscribeEvent
    public static void onMiningExpDropEvent(BlockEvent.BreakEvent event) {
        PlayerEntity player;
        if (event.getState().func_177230_c() instanceof OreBlock && event.getPlayer() instanceof PlayerEntity && PlayerEquipsUtil.isPlayerGotExpToken(player = event.getPlayer())) {
            event.setExpToDrop(extraXPOrbs);
        }
    }

    @SubscribeEvent
    public static void breakingBlockSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        BlockPos pos = event.getPos();
        Block block = event.getState().func_177230_c();
        if (player != null && !(player instanceof FakePlayer) && !player.func_184812_l_() && PlayerEquipsUtil.isPlayerGotHasteRing(player) && ForgeHooks.canToolHarvestBlock((IWorldReader)event.getPlayer().field_70170_p, (BlockPos)pos, (ItemStack)stack)) {
            if (block == Blocks.field_150343_Z) {
                event.setNewSpeed((float)((Integer)GobberConfigBuilder.HASTE_RING_BREAK_SPEED.get() * 8));
            } else {
                event.setNewSpeed((float)((Integer)GobberConfigBuilder.HASTE_RING_BREAK_SPEED.get()).intValue());
            }
        }
    }
}

