/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforge;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockDragonforgeCore
extends BlockContainer
implements IDragonProof {
    private static boolean keepInventory;
    private boolean isFire;
    private boolean activated;

    public BlockDragonforgeCore(boolean isFire, boolean activated) {
        super(Material.field_151573_f);
        this.func_149711_c(40.0f);
        this.func_149752_b(500.0f);
        this.func_149672_a(SoundType.field_185852_e);
        if (!activated) {
            this.func_149647_a(IceAndFire.TAB_BLOCKS);
        }
        String disabled = activated ? "" : "_disabled";
        this.func_149663_c("iceandfire.dragonforge_" + (isFire ? "fire" : "ice") + "_core");
        this.setRegistryName("iceandfire", "dragonforge_" + (isFire ? "fire" : "ice") + "_core" + disabled);
        if (activated) {
            this.func_149715_a(1.0f);
        }
        this.isFire = isFire;
        this.activated = activated;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public static void setState(boolean fire, boolean active, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            if (fire) {
                worldIn.func_180501_a(pos, ModBlocks.dragonforge_fire_core.func_176223_P(), 3);
                worldIn.func_180501_a(pos, ModBlocks.dragonforge_fire_core.func_176223_P(), 3);
            } else {
                worldIn.func_180501_a(pos, ModBlocks.dragonforge_ice_core.func_176223_P(), 3);
                worldIn.func_180501_a(pos, ModBlocks.dragonforge_ice_core.func_176223_P(), 3);
            }
        } else if (fire) {
            worldIn.func_180501_a(pos, ModBlocks.dragonforge_fire_core_disabled.func_176223_P(), 3);
            worldIn.func_180501_a(pos, ModBlocks.dragonforge_fire_core_disabled.func_176223_P(), 3);
        } else {
            worldIn.func_180501_a(pos, ModBlocks.dragonforge_ice_core_disabled.func_176223_P(), 3);
            worldIn.func_180501_a(pos, ModBlocks.dragonforge_ice_core_disabled.func_176223_P(), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        playerIn.openGui((Object)IceAndFire.INSTANCE, 7, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isFire ? Item.func_150898_a((Block)ModBlocks.dragonforge_fire_core_disabled) : Item.func_150898_a((Block)ModBlocks.dragonforge_ice_core_disabled);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.isFire ? Item.func_150898_a((Block)ModBlocks.dragonforge_fire_core_disabled) : Item.func_150898_a((Block)ModBlocks.dragonforge_ice_core_disabled));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.isFire;
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.activated) {
            // empty if block
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDragonforge(this.isFire);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityDragonforge) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityDragonforge)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }
}

