/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.structures.WorldUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGoldPile
extends Block {
    public static final PropertyInteger LAYERS = PropertyInteger.func_177719_a((String)"layers", (int)1, (int)8);
    protected static final AxisAlignedBB[] SNOW_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public Item itemBlock;

    public BlockGoldPile() {
        super(Material.field_151578_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(1)));
        this.func_149675_a(true);
        this.func_149647_a(IceAndFire.TAB_BLOCKS);
        this.func_149663_c("iceandfire.goldpile");
        this.func_149711_c(0.3f);
        this.func_149672_a(ModBlocks.SOUND_TYPE_GOLD);
        this.setRegistryName("iceandfire", "goldpile");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SNOW_AABB[(Integer)state.func_177229_b((IProperty)LAYERS)];
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)LAYERS) < 5;
    }

    @Deprecated
    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) == 7;
    }

    public AxisAlignedBB func_180640_a(IBlockState blockState, World worldIn, BlockPos pos) {
        int i = (Integer)blockState.func_177229_b((IProperty)LAYERS) - 1;
        float f = 0.125f;
        AxisAlignedBB axisalignedbb = blockState.func_185900_c((IBlockAccess)worldIn, pos);
        return new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, (double)((float)i * f), axisalignedbb.field_72334_f);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = iblockstate.func_177230_c();
        return block != Blocks.field_150432_aD && block != Blocks.field_150403_cj && (iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b()) || block == this && (Integer)iblockstate.func_177229_b((IProperty)LAYERS) >= 7 || iblockstate.func_185914_p() && iblockstate.func_185904_a().func_76230_c());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack item = playerIn.field_71071_by.func_70448_g();
        if (!item.func_190926_b() && item.func_77973_b() != null && item.func_77973_b() == Item.func_150898_a((Block)ModBlocks.goldPile) && !item.func_190926_b() && this.func_176201_c(state) < 7) {
            WorldUtils.setBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ModBlocks.goldPile, this.func_176201_c(state) + 1, 3);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                item.func_190918_g(1);
                if (item.func_190926_b()) {
                    playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                } else {
                    playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, item);
                }
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public boolean func_149662_c(IBlockState blockstate) {
        return false;
    }

    public boolean func_149686_d(IBlockState blockstate) {
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (world instanceof World) {
            this.checkAndDropBlock((World)world, pos, world.func_180495_p(neighbor));
        }
    }

    private boolean checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            return false;
        }
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151074_bl;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP || super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf((meta & 7) + 1));
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)LAYERS) == 1;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) - 1;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) + 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LAYERS});
    }
}

