/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.compat.thaumcraft;

import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.enums.EnumHippogryphTypes;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import com.github.alexthe666.iceandfire.enums.EnumSkullType;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class ThaumcraftCompat {
    static final Aspect MYTHICAL = new Aspect("mythus", 14276011, new Aspect[]{Aspect.BEAST, Aspect.MAGIC}, new ResourceLocation("iceandfire:textures/thaumcraft/mythical.png"), 1);
    static final Aspect DRAGON = ThaumcraftCompat.getOrCreateAspect("draco", 10626847, new Aspect[]{MYTHICAL, Aspect.DESIRE}, new ResourceLocation("iceandfire", "textures/thaumcraft/dragon.png"), 1);
    private static final ThaumcraftCompat INSTANCE = new ThaumcraftCompat();
    private static boolean registered = false;

    static Aspect getOrCreateAspect(String tag, int color, Aspect[] components, ResourceLocation image, int blend) {
        Aspect a = Aspect.getAspect((String)tag);
        if (a != null) {
            return a;
        }
        return new Aspect(tag, color, components, image, blend);
    }

    @Deprecated
    public static void register() {
        if (registered) {
            throw new RuntimeException("You can only call ThaumcraftCompat.register() once");
        }
        registered = true;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void aspectRegistrationEvent(AspectRegistryEvent evt) {
        evt.register.registerObjectTag(new ItemStack(ModItems.bestiary), new AspectList().add(DRAGON, 2).add(MYTHICAL, 5).add(Aspect.BEAST, 6).add(Aspect.MAGIC, 2).add(Aspect.MIND, 4).add(Aspect.WATER, 2).add(Aspect.AIR, 1));
        evt.register.registerObjectTag(new ItemStack(ModItems.manuscript), new AspectList().add(MYTHICAL, 5).add(Aspect.PLANT, 3).add(Aspect.MIND, 2).add(Aspect.WATER, 2).add(Aspect.AIR, 1));
        evt.register.registerObjectTag(new ItemStack(ModItems.sapphireGem), new AspectList().add(Aspect.CRYSTAL, 15).add(Aspect.DESIRE, 10));
        evt.register.registerObjectTag(new ItemStack(ModItems.fire_stew), new AspectList().add(Aspect.FIRE, 8).add(DRAGON, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.frost_stew), new AspectList().add(Aspect.COLD, 8).add(DRAGON, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonegg_red), new AspectList().add(DRAGON, 5).add(Aspect.FIRE, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonegg_bronze), new AspectList().add(DRAGON, 5).add(Aspect.FIRE, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonegg_green), new AspectList().add(DRAGON, 5).add(Aspect.FIRE, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonegg_gray), new AspectList().add(DRAGON, 5).add(Aspect.FIRE, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonegg_blue), new AspectList().add(DRAGON, 5).add(Aspect.COLD, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonegg_silver), new AspectList().add(DRAGON, 5).add(Aspect.COLD, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonegg_white), new AspectList().add(DRAGON, 5).add(Aspect.COLD, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonegg_sapphire), new AspectList().add(DRAGON, 5).add(Aspect.COLD, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonscales_red), new AspectList().add(DRAGON, 5).add(Aspect.FIRE, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonscales_bronze), new AspectList().add(DRAGON, 5).add(Aspect.FIRE, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonscales_green), new AspectList().add(DRAGON, 5).add(Aspect.FIRE, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonscales_gray), new AspectList().add(DRAGON, 5).add(Aspect.FIRE, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonscales_blue), new AspectList().add(DRAGON, 5).add(Aspect.COLD, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonscales_silver), new AspectList().add(DRAGON, 5).add(Aspect.COLD, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonscales_white), new AspectList().add(DRAGON, 5).add(Aspect.COLD, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonscales_sapphire), new AspectList().add(DRAGON, 5).add(Aspect.COLD, 5).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonbone), new AspectList().add(Aspect.DEATH, 5).add(DRAGON, 5).add(Aspect.MAGIC, 2));
        evt.register.registerObjectTag(new ItemStack(ModItems.witherbone), new AspectList().add(Aspect.DEATH, 6).add(Aspect.DARKNESS, 5).add(Aspect.MAGIC, 2).add(Aspect.ENTROPY, 5).add(Aspect.UNDEAD, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.wither_shard), new AspectList().add(Aspect.DEATH, 2).add(Aspect.DARKNESS, 1).add(Aspect.ENTROPY, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.fishing_spear), new AspectList().add(Aspect.PLANT, 2).add(Aspect.WATER, 7).add(Aspect.BEAST, 2).add(Aspect.TOOL, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.fishing_spear), new AspectList().add(Aspect.PLANT, 2).add(Aspect.WATER, 7).add(Aspect.BEAST, 2).add(Aspect.TOOL, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonbone_sword), new AspectList().add(DRAGON, 15).add(Aspect.DESIRE, 15).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 20).add(Aspect.DEATH, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonbone_sword_fire), new AspectList().add(DRAGON, 15).add(Aspect.DESIRE, 15).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 20).add(Aspect.DEATH, 5).add(Aspect.FIRE, 25).add(Aspect.MAGIC, 2));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonbone_sword_ice), new AspectList().add(DRAGON, 15).add(Aspect.DESIRE, 15).add(Aspect.BEAST, 6).add(Aspect.PROTECT, 20).add(Aspect.DEATH, 5).add(Aspect.COLD, 25).add(Aspect.MAGIC, 2));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonbone_pickaxe), new AspectList().add(DRAGON, 15).add(Aspect.DESIRE, 15).add(Aspect.BEAST, 6).add(Aspect.TOOL, 20).add(Aspect.DEATH, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonbone_axe), new AspectList().add(DRAGON, 15).add(Aspect.DESIRE, 15).add(Aspect.BEAST, 6).add(Aspect.TOOL, 20).add(Aspect.DEATH, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonbone_shovel), new AspectList().add(DRAGON, 15).add(Aspect.DESIRE, 15).add(Aspect.BEAST, 6).add(Aspect.TOOL, 20).add(Aspect.DEATH, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonbone_hoe), new AspectList().add(DRAGON, 15).add(Aspect.DESIRE, 15).add(Aspect.BEAST, 6).add(Aspect.TOOL, 20).add(Aspect.DEATH, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonbone_arrow), new AspectList().add(DRAGON, 5).add(Aspect.DESIRE, 2).add(Aspect.TOOL, 2).add(Aspect.AIR, 5).add(Aspect.FLIGHT, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonbone_bow), new AspectList().add(DRAGON, 15).add(Aspect.DESIRE, 15).add(Aspect.PROTECT, 20).add(Aspect.AIR, 15).add(Aspect.FLIGHT, 10).add(Aspect.CRAFT, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_skull, 1, 0), new AspectList().add(Aspect.DEATH, 15).add(DRAGON, 20).add(Aspect.MAGIC, 2).add(Aspect.FIRE, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_skull, 1, 1), new AspectList().add(Aspect.DEATH, 15).add(DRAGON, 20).add(Aspect.MAGIC, 2).add(Aspect.COLD, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_iron, 1, 0), new AspectList().add(Aspect.METAL, 20).add(DRAGON, 10).add(Aspect.DESIRE, 10).add(Aspect.PROTECT, 20));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_iron, 1, 1), new AspectList().add(Aspect.METAL, 10).add(DRAGON, 10).add(Aspect.DESIRE, 10).add(Aspect.PROTECT, 20));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_iron, 1, 2), new AspectList().add(Aspect.METAL, 30).add(DRAGON, 10).add(Aspect.DESIRE, 10).add(Aspect.PROTECT, 20));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_iron, 1, 3), new AspectList().add(Aspect.METAL, 20).add(DRAGON, 10).add(Aspect.DESIRE, 10).add(Aspect.PROTECT, 20));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_gold, 1, 0), new AspectList().add(Aspect.METAL, 20).add(DRAGON, 10).add(Aspect.DESIRE, 20).add(Aspect.PROTECT, 30));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_gold, 1, 1), new AspectList().add(Aspect.METAL, 10).add(DRAGON, 10).add(Aspect.DESIRE, 20).add(Aspect.PROTECT, 30));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_gold, 1, 2), new AspectList().add(Aspect.METAL, 30).add(DRAGON, 10).add(Aspect.DESIRE, 20).add(Aspect.PROTECT, 30));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_gold, 1, 3), new AspectList().add(Aspect.METAL, 20).add(DRAGON, 10).add(Aspect.DESIRE, 20).add(Aspect.PROTECT, 30));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_diamond, 1, 0), new AspectList().add(Aspect.CRYSTAL, 20).add(DRAGON, 10).add(Aspect.DESIRE, 30).add(Aspect.PROTECT, 40));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_diamond, 1, 1), new AspectList().add(Aspect.CRYSTAL, 10).add(DRAGON, 10).add(Aspect.DESIRE, 30).add(Aspect.PROTECT, 40));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_diamond, 1, 2), new AspectList().add(Aspect.CRYSTAL, 30).add(DRAGON, 10).add(Aspect.DESIRE, 30).add(Aspect.PROTECT, 40));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_armor_diamond, 1, 3), new AspectList().add(Aspect.CRYSTAL, 20).add(DRAGON, 10).add(Aspect.DESIRE, 30).add(Aspect.PROTECT, 40));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_meal), new AspectList().add(Aspect.LIFE, 10).add(Aspect.BEAST, 5).add(DRAGON, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.fire_dragon_flesh), new AspectList().add(Aspect.DEATH, 10).add(Aspect.BEAST, 10).add(DRAGON, 15).add(Aspect.FIRE, 10).add(Aspect.LIFE, 3));
        evt.register.registerObjectTag(new ItemStack(ModItems.ice_dragon_flesh), new AspectList().add(Aspect.DEATH, 10).add(Aspect.BEAST, 10).add(DRAGON, 15).add(Aspect.FIRE, 10).add(Aspect.LIFE, 3));
        evt.register.registerObjectTag(new ItemStack(ModItems.fire_dragon_heart), new AspectList().add(Aspect.LIFE, 10).add(Aspect.BEAST, 10).add(DRAGON, 15).add(Aspect.FIRE, 10).add(Aspect.SOUL, 30));
        evt.register.registerObjectTag(new ItemStack(ModItems.ice_dragon_heart), new AspectList().add(Aspect.LIFE, 10).add(Aspect.BEAST, 10).add(DRAGON, 15).add(Aspect.COLD, 10).add(Aspect.SOUL, 30));
        evt.register.registerObjectTag(new ItemStack(ModItems.fire_dragon_blood), new AspectList().add(Aspect.LIFE, 10).add(Aspect.BEAST, 10).add(DRAGON, 15).add(Aspect.FIRE, 10).add(Aspect.ALCHEMY, 30));
        evt.register.registerObjectTag(new ItemStack(ModItems.ice_dragon_blood), new AspectList().add(Aspect.LIFE, 10).add(Aspect.BEAST, 10).add(DRAGON, 15).add(Aspect.COLD, 10).add(Aspect.ALCHEMY, 30));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_stick), new AspectList().add(Aspect.TOOL, 10).add(Aspect.BEAST, 20).add(DRAGON, 35).add(Aspect.CRAFT, 5).add(Aspect.MAGIC, 15).add(Aspect.MOTION, 10).add(Aspect.ORDER, 40).add(Aspect.MIND, 10));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_horn), new AspectList().add(Aspect.LIFE, 20).add(Aspect.BEAST, 25).add(DRAGON, 50).add(Aspect.MAGIC, 20).add(Aspect.CRAFT, 15).add(Aspect.ORDER, 20).add(Aspect.EXCHANGE, 20).add(Aspect.SOUL, 10));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_horn_fire), new AspectList().add(Aspect.LIFE, 20).add(Aspect.BEAST, 25).add(DRAGON, 50).add(Aspect.MAGIC, 20).add(Aspect.CRAFT, 15).add(Aspect.ORDER, 20).add(Aspect.EXCHANGE, 20).add(Aspect.SOUL, 10).add(Aspect.FIRE, 10));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_horn_ice), new AspectList().add(Aspect.LIFE, 20).add(Aspect.BEAST, 25).add(DRAGON, 50).add(Aspect.MAGIC, 20).add(Aspect.CRAFT, 15).add(Aspect.ORDER, 20).add(Aspect.EXCHANGE, 20).add(Aspect.SOUL, 10).add(Aspect.COLD, 10));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragon_flute), new AspectList().add(Aspect.TOOL, 15).add(Aspect.BEAST, 25).add(MYTHICAL, 15).add(DRAGON, 25).add(Aspect.CRAFT, 5).add(Aspect.MAGIC, 15).add(Aspect.MOTION, 10).add(Aspect.ORDER, 30).add(Aspect.MIND, 15));
        evt.register.registerObjectTag(new ItemStack(ModItems.iron_hippogryph_armor), new AspectList().add(Aspect.METAL, 10).add(MYTHICAL, 10).add(Aspect.DESIRE, 10).add(Aspect.PROTECT, 10).add(Aspect.FLIGHT, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.iron_hippogryph_armor), new AspectList().add(Aspect.METAL, 10).add(MYTHICAL, 10).add(Aspect.DESIRE, 15).add(Aspect.PROTECT, 15).add(Aspect.FLIGHT, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.iron_hippogryph_armor), new AspectList().add(Aspect.CRYSTAL, 10).add(MYTHICAL, 10).add(Aspect.DESIRE, 20).add(Aspect.PROTECT, 20).add(Aspect.FLIGHT, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.gorgon_head), new AspectList().add(Aspect.DEATH, 50).add(MYTHICAL, 60).add(Aspect.DESIRE, 15).add(Aspect.MAN, 20).add(Aspect.EXCHANGE, 15).add(Aspect.EARTH, 15).add(Aspect.ENTROPY, 15).add(Aspect.TRAP, 5).add(Aspect.DARKNESS, 10).add(Aspect.UNDEAD, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.pixie_dust), new AspectList().add(Aspect.MAGIC, 30).add(MYTHICAL, 12).add(Aspect.DESIRE, 5).add(Aspect.MAN, 20).add(Aspect.LIFE, 15));
        evt.register.registerObjectTag(new ItemStack(ModItems.ambrosia), new AspectList().add(Aspect.MAGIC, 40).add(MYTHICAL, 5).add(Aspect.DESIRE, 20).add(Aspect.LIFE, 35));
        evt.register.registerObjectTag(new ItemStack(ModItems.shiny_scales), new AspectList().add(Aspect.WATER, 10).add(MYTHICAL, 15).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.earplugs), new AspectList().add(Aspect.PLANT, 5).add(Aspect.SENSES, 10));
        evt.register.registerObjectTag(new ItemStack(ModItems.deathworm_chitin, 1, 0), new AspectList().add(Aspect.BEAST, 5).add(MYTHICAL, 5).add(Aspect.PROTECT, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.deathworm_chitin, 1, 1), new AspectList().add(Aspect.BEAST, 5).add(MYTHICAL, 5).add(Aspect.PROTECT, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.deathworm_chitin, 1, 2), new AspectList().add(Aspect.BEAST, 5).add(MYTHICAL, 5).add(Aspect.PROTECT, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.deathworm_egg, 1, 0), new AspectList().add(Aspect.BEAST, 10).add(MYTHICAL, 12).add(Aspect.LIFE, 7).add(Aspect.DESIRE, 7).add(Aspect.PROTECT, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.deathworm_egg, 1, 1), new AspectList().add(Aspect.BEAST, 10).add(MYTHICAL, 30).add(Aspect.LIFE, 10).add(Aspect.DESIRE, 20).add(Aspect.PROTECT, 20));
        for (int i = 0; i < EnumHippogryphTypes.values().length; ++i) {
            evt.register.registerObjectTag(new ItemStack(ModItems.hippogryph_egg, 1, i), new AspectList().add(MYTHICAL, 10).add(Aspect.AIR, 5).add(Aspect.DESIRE, 20).add(Aspect.FLIGHT, 8).add(Aspect.BEAST, 6));
        }
        evt.register.registerObjectTag(new ItemStack(ModItems.rotten_egg), new AspectList().add(Aspect.BEAST, 10).add(MYTHICAL, 2).add(Aspect.LIFE, 5).add(Aspect.DEATH, 5).add(Aspect.UNDEAD, 5).add(Aspect.ENTROPY, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.stymphalian_bird_feather), new AspectList().add(Aspect.BEAST, 5).add(MYTHICAL, 15).add(Aspect.DESIRE, 5).add(Aspect.METAL, 7).add(Aspect.FLIGHT, 3));
        evt.register.registerObjectTag(new ItemStack(ModItems.stymphalian_arrow), new AspectList().add(Aspect.BEAST, 2).add(MYTHICAL, 5).add(Aspect.DESIRE, 2).add(Aspect.PROTECT, 2).add(Aspect.METAL, 7).add(Aspect.FLIGHT, 3).add(Aspect.CRAFT, 3));
        evt.register.registerObjectTag(new ItemStack(ModItems.troll_tusk), new AspectList().add(Aspect.BEAST, 10).add(MYTHICAL, 10).add(Aspect.DEATH, 5).add(Aspect.BEAST, 5).add(Aspect.AVERSION, 2).add(Aspect.MAGIC, 5).add(Aspect.ENTROPY, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.stone_statue), new AspectList().add(Aspect.BEAST, 20).add(MYTHICAL, 10).add(Aspect.DEATH, 10).add(Aspect.MAGIC, 5).add(Aspect.AVERSION, 2).add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5));
        for (EnumTroll.Weapon weapon : EnumTroll.Weapon.values()) {
            evt.register.registerObjectTag(new ItemStack(weapon.item), new AspectList().add(Aspect.BEAST, 10).add(MYTHICAL, 10).add(Aspect.DEATH, 5).add(Aspect.PROTECT, 15).add(Aspect.CRAFT, 2).add(Aspect.MAGIC, 5).add(Aspect.ENTROPY, 5));
        }
        evt.register.registerObjectTag(new ItemStack(EnumTroll.MOUNTAIN.leather), new AspectList().add(Aspect.BEAST, 10).add(MYTHICAL, 10).add(Aspect.PROTECT, 5).add(Aspect.DESIRE, 2).add(Aspect.MAGIC, 5).add(Aspect.ENTROPY, 5).add(Aspect.EARTH, 7));
        evt.register.registerObjectTag(new ItemStack(EnumTroll.FROST.leather), new AspectList().add(Aspect.BEAST, 10).add(MYTHICAL, 10).add(Aspect.PROTECT, 5).add(Aspect.DESIRE, 2).add(Aspect.MAGIC, 5).add(Aspect.ENTROPY, 5).add(Aspect.COLD, 7));
        evt.register.registerObjectTag(new ItemStack(EnumTroll.FOREST.leather), new AspectList().add(Aspect.BEAST, 10).add(MYTHICAL, 10).add(Aspect.PROTECT, 5).add(Aspect.DESIRE, 2).add(Aspect.MAGIC, 5).add(Aspect.ENTROPY, 5).add(Aspect.PLANT, 7));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.lectern), new AspectList().add(Aspect.PLANT, 8).add(MYTHICAL, 10).add(Aspect.SENSES, 10).add(Aspect.MIND, 12));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.podium, 1, 0), new AspectList().add(Aspect.PLANT, 7).add(MYTHICAL, 3).add(Aspect.SENSES, 4).add(Aspect.DESIRE, 20));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.podium, 1, 1), new AspectList().add(Aspect.PLANT, 7).add(MYTHICAL, 3).add(Aspect.SENSES, 4).add(Aspect.DESIRE, 20));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.podium, 1, 2), new AspectList().add(Aspect.PLANT, 7).add(MYTHICAL, 3).add(Aspect.SENSES, 4).add(Aspect.DESIRE, 20));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.podium, 1, 3), new AspectList().add(Aspect.PLANT, 7).add(MYTHICAL, 3).add(Aspect.SENSES, 4).add(Aspect.DESIRE, 20));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.podium, 1, 4), new AspectList().add(Aspect.PLANT, 7).add(MYTHICAL, 3).add(Aspect.SENSES, 4).add(Aspect.DESIRE, 20));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.podium, 1, 5), new AspectList().add(Aspect.PLANT, 7).add(MYTHICAL, 3).add(Aspect.SENSES, 4).add(Aspect.DESIRE, 20));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.fire_lily), new AspectList().add(Aspect.FIRE, 5).add(Aspect.PLANT, 7).add(DRAGON, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.frost_lily), new AspectList().add(Aspect.COLD, 5).add(Aspect.PLANT, 7).add(DRAGON, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.sapphireOre), new AspectList().add(Aspect.CRYSTAL, 15).add(Aspect.DESIRE, 10).add(Aspect.EARTH, 5));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.sapphireOre), new AspectList().add(Aspect.CRYSTAL, 15).add(Aspect.DESIRE, 10).add(Aspect.EARTH, 5));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.charedDirt), new AspectList().add(Aspect.EARTH, 5).add(Aspect.FIRE, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.charedGrass), new AspectList().add(Aspect.EARTH, 5).add(Aspect.PLANT, 2).add(Aspect.FIRE, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.charedGrassPath), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ORDER, 2).add(Aspect.PLANT, 2).add(Aspect.FIRE, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.charedStone), new AspectList().add(Aspect.EARTH, 5).add(Aspect.FIRE, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.charedCobblestone), new AspectList().add(Aspect.EARTH, 5).add(Aspect.FIRE, 2).add(Aspect.ENTROPY, 1));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.charedGravel), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 2).add(Aspect.FIRE, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.ash), new AspectList().add(Aspect.ENTROPY, 5).add(Aspect.FIRE, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.frozenDirt), new AspectList().add(Aspect.EARTH, 5).add(Aspect.COLD, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.frozenGrass), new AspectList().add(Aspect.EARTH, 5).add(Aspect.PLANT, 2).add(Aspect.COLD, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.frozenGrassPath), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ORDER, 2).add(Aspect.PLANT, 2).add(Aspect.COLD, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.frozenStone), new AspectList().add(Aspect.EARTH, 5).add(Aspect.COLD, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.frozenGravel), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 2).add(Aspect.COLD, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.dragon_ice), new AspectList().add(Aspect.ENTROPY, 2).add(Aspect.COLD, 5));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.frozenCobblestone), new AspectList().add(Aspect.EARTH, 5).add(Aspect.FIRE, 2).add(Aspect.ENTROPY, 1));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.dragon_ice_spikes), new AspectList().add(Aspect.DEATH, 2).add(Aspect.TRAP, 2).add(Aspect.ENTROPY, 5).add(Aspect.COLD, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.nest), new AspectList().add(Aspect.EARTH, 5).add(Aspect.LIFE, 2).add(DRAGON, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.pixieHouse, 1, 0), new AspectList().add(Aspect.EARTH, 3).add(Aspect.CRAFT, 1).add(Aspect.PLANT, 3).add(MYTHICAL, 2).add(Aspect.MAGIC, 3));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.pixieHouse, 1, 1), new AspectList().add(Aspect.EARTH, 3).add(Aspect.CRAFT, 1).add(Aspect.PLANT, 3).add(MYTHICAL, 2).add(Aspect.MAGIC, 3));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.pixieHouse, 1, 2), new AspectList().add(Aspect.EARTH, 3).add(Aspect.CRAFT, 1).add(Aspect.PLANT, 3).add(MYTHICAL, 2).add(Aspect.MAGIC, 3));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.pixieHouse, 1, 3), new AspectList().add(Aspect.EARTH, 3).add(Aspect.CRAFT, 1).add(Aspect.PLANT, 3).add(MYTHICAL, 2).add(Aspect.MAGIC, 3));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.pixieHouse, 1, 4), new AspectList().add(Aspect.EARTH, 3).add(Aspect.CRAFT, 1).add(Aspect.PLANT, 3).add(MYTHICAL, 2).add(Aspect.MAGIC, 3));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.pixieHouse, 1, 5), new AspectList().add(Aspect.EARTH, 3).add(Aspect.CRAFT, 1).add(Aspect.PLANT, 3).add(MYTHICAL, 2).add(Aspect.MAGIC, 3));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.jar_empty), new AspectList().add(Aspect.CRYSTAL, 3).add(Aspect.AIR, 5));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.jar_pixie, 1, 0), new AspectList().add(Aspect.CRYSTAL, 3).add(MYTHICAL, 20).add(Aspect.MAGIC, 10).add(Aspect.AIR, 5));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.jar_pixie, 1, 1), new AspectList().add(Aspect.CRYSTAL, 3).add(MYTHICAL, 20).add(Aspect.MAGIC, 10).add(Aspect.AIR, 5));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.jar_pixie, 1, 2), new AspectList().add(Aspect.CRYSTAL, 3).add(MYTHICAL, 20).add(Aspect.MAGIC, 10).add(Aspect.AIR, 5));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.jar_pixie, 1, 3), new AspectList().add(Aspect.CRYSTAL, 3).add(MYTHICAL, 20).add(Aspect.MAGIC, 10).add(Aspect.AIR, 5));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.jar_pixie, 1, 4), new AspectList().add(Aspect.CRYSTAL, 3).add(MYTHICAL, 20).add(Aspect.MAGIC, 10).add(Aspect.AIR, 5));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.eggInIce), new AspectList().add(DRAGON, 5).add(Aspect.COLD, 20).add(Aspect.DESIRE, 20).add(Aspect.BEAST, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_desert_egg, 1, 0), new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_desert_egg, 1, 1), new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_desert_egg, 1, 2), new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_desert_egg, 1, 3), new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_desert_egg, 1, 4), new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 25).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_jungle_egg, 1, 0), new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_jungle_egg, 1, 1), new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_jungle_egg, 1, 2), new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_jungle_egg, 1, 3), new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_jungle_egg, 1, 4), new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 25).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_desert_resin), new AspectList().add(Aspect.EXCHANGE, 5).add(Aspect.ENTROPY, 5).add(MYTHICAL, 7).add(Aspect.BEAST, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_jungle_resin), new AspectList().add(Aspect.EXCHANGE, 5).add(Aspect.ENTROPY, 5).add(MYTHICAL, 7).add(Aspect.BEAST, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_desert_chitin), new AspectList().add(Aspect.BEAST, 5).add(Aspect.PROTECT, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_jungle_chitin), new AspectList().add(Aspect.BEAST, 5).add(Aspect.PROTECT, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_stinger), new AspectList().add(Aspect.BEAST, 15).add(Aspect.TRAP, 5).add(Aspect.DEATH, 5).add(MYTHICAL, 7));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_desert_staff), new AspectList().add(Aspect.TOOL, 10).add(Aspect.BEAST, 20).add(MYTHICAL, 15).add(Aspect.CRAFT, 5).add(Aspect.MAGIC, 15).add(Aspect.MOTION, 10).add(Aspect.ORDER, 40).add(Aspect.MIND, 10));
        evt.register.registerObjectTag(new ItemStack(ModItems.myrmex_jungle_staff), new AspectList().add(Aspect.TOOL, 10).add(Aspect.BEAST, 20).add(MYTHICAL, 15).add(Aspect.CRAFT, 5).add(Aspect.MAGIC, 15).add(Aspect.MOTION, 10).add(Aspect.ORDER, 40).add(Aspect.MIND, 10));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.myrmex_resin, 1, 0), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.myrmex_resin, 1, 1), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.myrmex_resin_sticky, 1, 0), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.myrmex_resin_sticky, 1, 1), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5).add(MYTHICAL, 2).add(Aspect.TRAP, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.desert_myrmex_cocoon), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5).add(Aspect.CRAFT, 5).add(Aspect.MECHANISM, 5).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.jungle_myrmex_cocoon), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5).add(Aspect.CRAFT, 5).add(Aspect.MECHANISM, 5).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.myrmex_desert_biolight), new AspectList().add(Aspect.EARTH, 5).add(Aspect.PLANT, 5).add(Aspect.AURA, 2).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.myrmex_jungle_biolight), new AspectList().add(Aspect.EARTH, 5).add(Aspect.PLANT, 5).add(Aspect.AURA, 2).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.myrmex_desert_resin_block), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ORDER, 2).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.myrmex_jungle_resin_block), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ORDER, 2).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.myrmex_desert_resin_glass), new AspectList().add(Aspect.EARTH, 5).add(Aspect.AIR, 2).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModBlocks.myrmex_jungle_resin_glass), new AspectList().add(Aspect.EARTH, 5).add(Aspect.AIR, 2).add(MYTHICAL, 2));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonsteel_fire_ingot), new AspectList().add(Aspect.METAL, 40).add(MYTHICAL, 20).add(DRAGON, 10).add(Aspect.FIRE, 10).add(Aspect.MAGIC, 25).add(Aspect.DESIRE, 45));
        evt.register.registerObjectTag(new ItemStack(ModItems.dragonsteel_ice_ingot), new AspectList().add(Aspect.METAL, 40).add(MYTHICAL, 20).add(DRAGON, 10).add(Aspect.WATER, 10).add(Aspect.MAGIC, 25).add(Aspect.DESIRE, 45));
        evt.register.registerObjectTag(new ItemStack(ModItems.hippogryph_talon), new AspectList().add(MYTHICAL, 10).add(Aspect.AIR, 5).add(Aspect.DESIRE, 20).add(Aspect.FLIGHT, 8).add(Aspect.BEAST, 6));
        evt.register.registerObjectTag(new ItemStack(ModItems.pixie_wings), new AspectList().add(MYTHICAL, 30).add(Aspect.FLIGHT, 5).add(Aspect.MAN, 10).add(Aspect.AIR, 10).add(Aspect.MAGIC, 30).add(Aspect.DESIRE, 5).add(Aspect.EXCHANGE, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.cyclops_eye), new AspectList().add(MYTHICAL, 30).add(Aspect.MAN, 10).add(Aspect.DEATH, 10).add(Aspect.MAGIC, 30).add(Aspect.DESIRE, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.siren_tear), new AspectList().add(MYTHICAL, 30).add(Aspect.MAN, 10).add(Aspect.DESIRE, 25).add(Aspect.MAGIC, 30).add(Aspect.WATER, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.hippocampus_fin), new AspectList().add(MYTHICAL, 20).add(Aspect.BEAST, 10).add(Aspect.WATER, 25));
        evt.register.registerObjectTag(new ItemStack(ModItems.deathworm_tounge), new AspectList().add(MYTHICAL, 20).add(Aspect.BEAST, 10).add(Aspect.TRAP, 5));
        evt.register.registerObjectTag(new ItemStack(ModItems.cockatrice_eye), new AspectList().add(MYTHICAL, 20).add(Aspect.BEAST, 10).add(Aspect.DEATH, 35));
        evt.register.registerObjectTag(new ItemStack(ModItems.amphithere_feather), new AspectList().add(MYTHICAL, 10).add(Aspect.BEAST, 10).add(Aspect.FLIGHT, 10));
        evt.register.registerObjectTag(new ItemStack(ModItems.sea_serpent_fang), new AspectList().add(MYTHICAL, 20).add(Aspect.BEAST, 10).add(Aspect.WATER, 10));
        for (Enum enum_ : EnumSeaSerpent.values()) {
            evt.register.registerObjectTag(new ItemStack(((EnumSeaSerpent)enum_).scale), new AspectList().add(MYTHICAL, 20).add(Aspect.BEAST, 10).add(Aspect.WATER, 10));
        }
        for (Enum enum_ : EnumSkullType.values()) {
            evt.register.registerObjectTag(new ItemStack(((EnumSkullType)enum_).skull_item), new AspectList().add(MYTHICAL, 20).add(Aspect.BEAST, 10).add(Aspect.DEATH, 10));
        }
        ThaumcraftApi.registerEntityTag((String)"dragonegg", (AspectList)new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 5).add(DRAGON, 10).add(Aspect.MAGIC, 2), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"dragonskull", (AspectList)new AspectList().add(Aspect.DEATH, 5).add(Aspect.DESIRE, 5).add(DRAGON, 10).add(Aspect.MAGIC, 2), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"firedragon", (AspectList)new AspectList().add(Aspect.FIRE, 25).add(Aspect.BEAST, 15).add(Aspect.FLIGHT, 25).add(Aspect.MIND, 5).add(DRAGON, 50).add(Aspect.MAGIC, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"icedragon", (AspectList)new AspectList().add(Aspect.COLD, 25).add(Aspect.BEAST, 15).add(Aspect.FLIGHT, 25).add(Aspect.MIND, 5).add(DRAGON, 50).add(Aspect.MAGIC, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"snowvillager", (AspectList)new AspectList().add(Aspect.COLD, 20).add(Aspect.MAN, 10).add(Aspect.MIND, 7), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"hippogryph", (AspectList)new AspectList().add(MYTHICAL, 35).add(Aspect.FLIGHT, 15).add(Aspect.BEAST, 10).add(Aspect.AIR, 7), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"stonestatue", (AspectList)new AspectList().add(MYTHICAL, 5).add(Aspect.EARTH, 10).add(Aspect.MAGIC, 5).add(Aspect.DEATH, 5).add(Aspect.ELDRITCH, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"gorgon", (AspectList)new AspectList().add(MYTHICAL, 50).add(Aspect.DEATH, 20).add(Aspect.MAN, 10).add(Aspect.BEAST, 10).add(Aspect.UNDEAD, 10).add(Aspect.DESIRE, 15).add(Aspect.EARTH, 5).add(Aspect.SENSES, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"if_pixie", (AspectList)new AspectList().add(MYTHICAL, 30).add(Aspect.FLIGHT, 5).add(Aspect.MAN, 10).add(Aspect.AIR, 10).add(Aspect.MAGIC, 30).add(Aspect.DESIRE, 5).add(Aspect.EXCHANGE, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"cyclops", (AspectList)new AspectList().add(MYTHICAL, 50).add(Aspect.MAN, 10).add(Aspect.MIND, 2).add(Aspect.ELDRITCH, 5).add(Aspect.LIFE, 5).add(Aspect.EARTH, 10).add(Aspect.DEATH, 2).add(Aspect.SENSES, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"siren", (AspectList)new AspectList().add(MYTHICAL, 50).add(Aspect.MAN, 10).add(Aspect.WATER, 20).add(Aspect.DESIRE, 150).add(Aspect.DEATH, 5).add(Aspect.SENSES, 40), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"hippocampus", (AspectList)new AspectList().add(MYTHICAL, 35).add(Aspect.WATER, 15).add(Aspect.DESIRE, 5).add(Aspect.BEAST, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"deathworm", (AspectList)new AspectList().add(MYTHICAL, 20).add(Aspect.DEATH, 15).add(Aspect.MOTION, 5).add(Aspect.BEAST, 20).add(Aspect.PROTECT, 10).add(Aspect.ELDRITCH, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"stymphalianbird", (AspectList)new AspectList().add(MYTHICAL, 35).add(Aspect.FLIGHT, 20).add(Aspect.METAL, 20).add(Aspect.BEAST, 20).add(Aspect.PROTECT, 15).add(Aspect.AVERSION, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"if_cockatrice", (AspectList)new AspectList().add(MYTHICAL, 35).add(Aspect.FLIGHT, 20).add(Aspect.ALCHEMY, 20).add(Aspect.DARKNESS, 20).add(Aspect.AVERSION, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"if_troll", (AspectList)new AspectList().add(MYTHICAL, 30).add(Aspect.BEAST, 20).add(Aspect.AVERSION, 10).add(Aspect.DARKNESS, 20).add(Aspect.MAGIC, 15).add(Aspect.MAN, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"myrmex_egg", (AspectList)new AspectList().add(Aspect.LIFE, 5).add(Aspect.DESIRE, 5).add(MYTHICAL, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"myrmex_worker", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.EXCHANGE, 5).add(MYTHICAL, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"myrmex_soldier", (AspectList)new AspectList().add(Aspect.BEAST, 15).add(Aspect.PROTECT, 5).add(MYTHICAL, 15), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"myrmex_sentinel", (AspectList)new AspectList().add(Aspect.BEAST, 20).add(Aspect.PROTECT, 10).add(MYTHICAL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"myrmex_royal", (AspectList)new AspectList().add(Aspect.BEAST, 20).add(Aspect.SENSES, 10).add(Aspect.FLIGHT, 10).add(MYTHICAL, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"myrmex_queen", (AspectList)new AspectList().add(Aspect.BEAST, 35).add(Aspect.EXCHANGE, 10).add(Aspect.LIFE, 10).add(MYTHICAL, 30), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"myrmex_swarmer", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.SENSES, 5).add(Aspect.FLIGHT, 5).add(MYTHICAL, 5), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"seaserpent", (AspectList)new AspectList().add(MYTHICAL, 40).add(Aspect.BEAST, 30).add(Aspect.WATER, 20).add(Aspect.DEATH, 25).add(Aspect.DARKNESS, 10), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"amphithere", (AspectList)new AspectList().add(MYTHICAL, 30).add(Aspect.FLIGHT, 40).add(Aspect.BEAST, 10).add(Aspect.AIR, 20), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
    }
}

