/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.compat.tinkers;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.compat.tinkers.TinkersCompat;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import slimeknights.mantle.client.book.BookTransformer;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.gui.book.element.ElementImage;
import slimeknights.mantle.client.gui.book.element.ElementItem;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.book.content.ContentListing;
import slimeknights.tconstruct.library.book.content.ContentMaterial;
import slimeknights.tconstruct.library.book.content.ContentModifier;
import slimeknights.tconstruct.library.book.content.ContentPageIconList;
import slimeknights.tconstruct.library.book.content.ContentSingleStatMultMaterial;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;

public class IceAndFireBookTranformer
extends BookTransformer {
    public static List<ContentPageIconList> getPagesNeededForItemCount(int addLoc, int count, SectionData data, String title) {
        ArrayList listPages = Lists.newArrayList();
        while (count > 0) {
            ContentPageIconList overview = new ContentPageIconList();
            PageData page2 = new PageData(true);
            page2.source = data.source;
            page2.parent = data;
            page2.content = overview;
            page2.load();
            data.pages.add(addLoc, page2);
            overview.title = title;
            listPages.add(overview);
            count -= overview.getMaxIconCount();
        }
        if (listPages.size() > 1) {
            listPages.forEach(page -> {
                page.maxScale = 1.0f;
            });
        }
        return listPages;
    }

    public void transform(BookData book) {
        SectionData modifierSection = null;
        SectionData iafModifierSection = null;
        SectionData materialsSection = null;
        SectionData bowMaterialsSection = null;
        for (SectionData section : book.sections) {
            if (section.name.equals("modifiers")) {
                modifierSection = section;
            }
            if (section.name.equals("iafmodifiers")) {
                iafModifierSection = section;
            }
            if (section.name.equals("materials")) {
                materialsSection = section;
            }
            if (!section.name.equals("bowmaterials")) continue;
            bowMaterialsSection = section;
        }
        if (modifierSection != null && iafModifierSection != null) {
            for (Object page : iafModifierSection.pages) {
                ((PageData)page).parent = modifierSection;
                modifierSection.pages.add(page);
            }
            PageData pageData = (PageData)modifierSection.pages.get(0);
            if (pageData.content instanceof ContentListing) {
                for (PageData page : iafModifierSection.pages) {
                    IModifier modifier;
                    page.parent = modifierSection;
                    if (!(page.content instanceof ContentModifier) || (modifier = TinkerRegistry.getModifier((String)((ContentModifier)page.content).modifierName)) == null) continue;
                    page.name = "iaf_" + modifier.getIdentifier();
                    ((ContentListing)pageData.content).addEntry(modifier.getLocalizedName(), page);
                }
            }
            iafModifierSection.pages.clear();
            book.sections.remove(iafModifierSection);
        }
        if (IceAndFire.CONFIG.weezerTinkers) {
            try {
                Iterator itr;
                if (materialsSection != null) {
                    itr = materialsSection.pages.iterator();
                    ContentPageIconList previousContents = null;
                    HashMap<String, PageData> previousMaterialPages = new HashMap<String, PageData>();
                    while (itr.hasNext()) {
                        PageData data = (PageData)itr.next();
                        if (data.type != null && data.type.equalsIgnoreCase("toolmaterial")) {
                            previousMaterialPages.put(data.name, data);
                        }
                        if (data.name.equalsIgnoreCase(TinkersCompat.MATERIAL_WEEZER.identifier)) {
                            itr.remove();
                        }
                        if (!(data.content instanceof ContentPageIconList)) continue;
                        previousContents = (ContentPageIconList)data.content;
                        itr.remove();
                    }
                    if (previousContents != null) {
                        List materialList = TinkerRegistry.getAllMaterials().stream().filter(m -> !m.isHidden()).filter(this::isValidMaterial).filter(Material::hasItems).collect(Collectors.toList());
                        List<ContentPageIconList> listPages = IceAndFireBookTranformer.getPagesNeededForItemCount(0, materialList.size(), materialsSection, book.translate("materials"));
                        ListIterator<ContentPageIconList> iter = listPages.listIterator();
                        ContentPageIconList overview = iter.next();
                        for (Material material2 : materialList) {
                            PageData page = (PageData)previousMaterialPages.get(material2.identifier);
                            Object icon = material2.getRepresentativeItem() != null ? new ElementItem(0, 0, 1.0f, material2.getRepresentativeItem()) : new ElementImage(ImageData.MISSING);
                            if (page == null) continue;
                            while (!overview.addLink((SizedBookElement)icon, material2.getLocalizedNameColored(), page)) {
                                overview = iter.next();
                            }
                        }
                    }
                }
                if (bowMaterialsSection != null) {
                    itr = bowMaterialsSection.pages.iterator();
                    int contentLoc = 0;
                    ContentPageIconList previousContents = null;
                    HashMap<String, PageData> previousMaterialPages = new HashMap<String, PageData>();
                    while (itr.hasNext()) {
                        PageData data = (PageData)itr.next();
                        if (data.content instanceof ContentPageIconList && previousContents == null) {
                            previousContents = (ContentPageIconList)data.content;
                            contentLoc = bowMaterialsSection.pages.indexOf(data);
                            itr.remove();
                        } else if (data.type != null && data.type.equalsIgnoreCase("single_stat_material")) {
                            previousMaterialPages.put(data.name, data);
                        }
                        if (!data.name.contains(TinkersCompat.MATERIAL_WEEZER.identifier)) continue;
                        itr.remove();
                    }
                    if (previousContents != null) {
                        List materialList = TinkerRegistry.getAllMaterials().stream().filter(m -> !m.isHidden()).filter(Material::hasItems).filter(material -> material.hasStats("bow")).collect(Collectors.toList());
                        List<ContentPageIconList> listPages = IceAndFireBookTranformer.getPagesNeededForItemCount(contentLoc, materialList.size(), bowMaterialsSection, book.translate("materials"));
                        listPages.forEach(p -> {
                            p.maxScale = 1.0f;
                        });
                        ListIterator<ContentPageIconList> iter = listPages.listIterator();
                        ContentPageIconList overview = iter.next();
                        for (List materials : Lists.partition(materialList, (int)3)) {
                            ContentSingleStatMultMaterial content = new ContentSingleStatMultMaterial(materials, "bow");
                            String id = "bow_" + materials.stream().map(Material::getIdentifier).collect(Collectors.joining("_"));
                            PageData page = (PageData)previousMaterialPages.get(id);
                            for (Material material3 : materials) {
                                if (material3.identifier.equalsIgnoreCase(TinkersCompat.MATERIAL_WEEZER.identifier)) continue;
                                Object icon = material3.getRepresentativeItem() != null ? new ElementItem(0, 0, 1.0f, material3.getRepresentativeItem()) : new ElementImage(ImageData.MISSING);
                                if (page == null) continue;
                                while (!overview.addLink((SizedBookElement)icon, material3.getLocalizedNameColored(), page)) {
                                    overview = iter.next();
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected PageData addPage(SectionData data, String name, String type, PageContent content) {
        PageData page = new PageData(true);
        page.source = data.source;
        page.parent = data;
        page.name = name;
        page.type = type;
        page.content = content;
        page.load();
        data.pages.add(page);
        return page;
    }

    protected boolean isValidMaterial(Material material) {
        return (material.hasStats("head") || material.hasStats("head") || material.hasStats("head")) && !material.identifier.equalsIgnoreCase(TinkersCompat.MATERIAL_WEEZER.identifier);
    }

    protected PageContent getPageContent(Material material) {
        return new ContentMaterial(material);
    }
}

