/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.compat.tinkers;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.compat.tinkers.TraitAntigravity;
import com.github.alexthe666.iceandfire.compat.tinkers.TraitArrowKnockback;
import com.github.alexthe666.iceandfire.compat.tinkers.TraitBurn;
import com.github.alexthe666.iceandfire.compat.tinkers.TraitFreeze;
import com.github.alexthe666.iceandfire.compat.tinkers.TraitHiveDefender;
import com.github.alexthe666.iceandfire.compat.tinkers.TraitInTheGarage;
import com.github.alexthe666.iceandfire.compat.tinkers.TraitSplinteringII;
import com.github.alexthe666.iceandfire.compat.tinkers.TraitSplitting2;
import com.github.alexthe666.iceandfire.compat.tinkers.TraitSurfWaxAmerica;
import com.github.alexthe666.iceandfire.compat.tinkers.TraitSweaterSong;
import com.github.alexthe666.iceandfire.core.ModItems;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTraits;
import slimeknights.tconstruct.tools.traits.TraitBonusDamage;

public class TinkersCompat {
    public static final Material MATERIAL_DRAGONBONE = new Material("dragonbone", 12038813);
    public static final Material MATERIAL_DESERT_MYRMEX = new Material("desert_myrmex", 7879436);
    public static final Material MATERIAL_JUNGLE_MYRMEX = new Material("jungle_myrmex", 2521714);
    public static final Material MATERIAL_DRAGONSTEEL_FIRE = new Material("dragonsteel_fire", 0xCCBBC4);
    public static final Material MATERIAL_DRAGONSTEEL_ICE = new Material("dragonsteel_ice", 12313853);
    public static final Material MATERIAL_STYMPH_FEATHER = new Material("stymph_feather", 8215360);
    public static final Material MATERIAL_AMPHITHERE_FEATHER = new Material("amphithere_feather", 2262880);
    public static final Material MATERIAL_WEEZER = new Material("weezer", 43746, true);
    public static final AbstractTrait SPLINTERING_II = new TraitSplinteringII();
    public static final AbstractTrait SPLINTERS_II = new TraitSplitting2();
    public static final AbstractTrait FRACTURED_II = new TraitBonusDamage("fractured2", 3.0f);
    public static final AbstractTrait HIVE_DEFENDER = new TraitHiveDefender();
    public static final AbstractTrait FREEZE_II = new TraitFreeze(2);
    public static final AbstractTrait BURN_II = new TraitBurn(2);
    public static final AbstractTrait FREEZE_I = new TraitFreeze(1);
    public static final AbstractTrait BURN_I = new TraitBurn(1);
    public static final AbstractTrait ANTIGRAVITY = new TraitAntigravity();
    public static final AbstractTrait ARROW_KNOCKBACK = new TraitArrowKnockback();
    public static final AbstractTrait IN_THE_GARAGE = new TraitInTheGarage();
    public static final AbstractTrait SWEATER_SONG = new TraitSweaterSong();
    public static final AbstractTrait SURF_WAX_AMERICA = new TraitSurfWaxAmerica();
    private static final TinkersCompat INSTANCE = new TinkersCompat();
    public static FluidMolten MOLTEN_FIRE_DRAGONSTEEL;
    public static FluidMolten MOLTEN_ICE_DRAGONSTEEL;
    private static boolean registered;

    public static void register() {
        if (registered) {
            throw new RuntimeException("You can only call TinkersCompat.register() once");
        }
        registered = true;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        TinkersCompat.init();
    }

    private static void init() {
        TinkerMaterials.materials.add(MATERIAL_DRAGONBONE);
        TinkerRegistry.integrate((Material)MATERIAL_DRAGONBONE).preInit();
        MATERIAL_DRAGONBONE.addItem(ModItems.dragonbone, 1, 144);
        MATERIAL_DRAGONBONE.setRepresentativeItem(ModItems.dragonbone);
        MATERIAL_DRAGONBONE.setCraftable(true);
        MATERIAL_DRAGONBONE.setCastable(false);
        TinkerRegistry.addMaterialStats((Material)MATERIAL_DRAGONBONE, (IMaterialStats)new HeadMaterialStats(300, 3.0f, 6.0f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.3f, 130), new ExtraMaterialStats(200)});
        TinkerRegistry.addMaterialStats((Material)MATERIAL_DRAGONBONE, (IMaterialStats)new BowMaterialStats(0.6f, 1.2f, 4.0f));
        MATERIAL_DRAGONBONE.addTrait((ITrait)SPLINTERING_II, "head");
        MATERIAL_DRAGONBONE.addTrait((ITrait)SPLINTERS_II, "shaft");
        MATERIAL_DRAGONBONE.addTrait((ITrait)FRACTURED_II);
        TinkerRegistry.addMaterialStats((Material)MATERIAL_DRAGONBONE, (IMaterialStats)new ArrowShaftMaterialStats(1.3f, 2));
        TinkerMaterials.materials.add(MATERIAL_DESERT_MYRMEX);
        TinkerRegistry.integrate((Material)MATERIAL_DESERT_MYRMEX).preInit();
        MATERIAL_DESERT_MYRMEX.addItem(ModItems.myrmex_desert_chitin, 1, 144);
        MATERIAL_DESERT_MYRMEX.setRepresentativeItem(ModItems.myrmex_desert_chitin);
        MATERIAL_DESERT_MYRMEX.setCraftable(true);
        MATERIAL_DESERT_MYRMEX.setCastable(false);
        TinkerRegistry.addMaterialStats((Material)MATERIAL_DESERT_MYRMEX, (IMaterialStats)new HeadMaterialStats(400, 4.0f, 5.5f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.7f, 300), new ExtraMaterialStats(150)});
        TinkerRegistry.addMaterialStats((Material)MATERIAL_DESERT_MYRMEX, (IMaterialStats)new BowMaterialStats(0.5f, 0.7f, 2.0f));
        MATERIAL_DESERT_MYRMEX.addTrait((ITrait)HIVE_DEFENDER, "head");
        MATERIAL_DESERT_MYRMEX.addTrait((ITrait)TinkerTraits.poisonous);
        TinkerMaterials.materials.add(MATERIAL_JUNGLE_MYRMEX);
        TinkerRegistry.integrate((Material)MATERIAL_JUNGLE_MYRMEX).preInit();
        MATERIAL_JUNGLE_MYRMEX.addItem(ModItems.myrmex_jungle_chitin, 1, 144);
        MATERIAL_JUNGLE_MYRMEX.setRepresentativeItem(ModItems.myrmex_jungle_chitin);
        TinkerRegistry.addMaterialStats((Material)MATERIAL_JUNGLE_MYRMEX, (IMaterialStats)new HeadMaterialStats(400, 4.0f, 5.5f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.7f, 300), new ExtraMaterialStats(150)});
        TinkerRegistry.addMaterialStats((Material)MATERIAL_JUNGLE_MYRMEX, (IMaterialStats)new BowMaterialStats(0.5f, 0.7f, 2.0f));
        MATERIAL_JUNGLE_MYRMEX.addTrait((ITrait)HIVE_DEFENDER, "head");
        MATERIAL_JUNGLE_MYRMEX.addTrait((ITrait)TinkerTraits.poisonous);
        TinkersCompat.setupFluids();
        TinkerMaterials.materials.add(MATERIAL_DRAGONSTEEL_FIRE);
        TinkerRegistry.integrate((Material)MATERIAL_DRAGONSTEEL_FIRE, (Fluid)MOLTEN_FIRE_DRAGONSTEEL, (String)"FireDragonsteel").toolforge().preInit();
        MATERIAL_DRAGONSTEEL_FIRE.addItem(ModItems.dragonsteel_fire_ingot, 1, 144);
        MATERIAL_DRAGONSTEEL_FIRE.setRepresentativeItem(ModItems.dragonsteel_fire_ingot);
        TinkerRegistry.addMaterialStats((Material)MATERIAL_DRAGONSTEEL_FIRE, (IMaterialStats)new HeadMaterialStats(1500, 7.0f, (float)IceAndFire.CONFIG.dragonsteelBaseDamage - 8.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.4f, 400), new ExtraMaterialStats(510)});
        TinkerRegistry.addMaterialStats((Material)MATERIAL_DRAGONSTEEL_FIRE, (IMaterialStats)new BowMaterialStats(0.9f, 3.0f, 6.0f));
        MATERIAL_DRAGONSTEEL_FIRE.addTrait((ITrait)BURN_II, "head");
        MATERIAL_DRAGONSTEEL_FIRE.addTrait((ITrait)TinkerTraits.sharp);
        TinkerMaterials.materials.add(MATERIAL_DRAGONSTEEL_ICE);
        TinkerRegistry.integrate((Material)MATERIAL_DRAGONSTEEL_ICE, (Fluid)MOLTEN_ICE_DRAGONSTEEL, (String)"IceDragonsteel").toolforge().preInit();
        MATERIAL_DRAGONSTEEL_ICE.addItem(ModItems.dragonsteel_ice_ingot, 1, 144);
        MATERIAL_DRAGONSTEEL_ICE.setRepresentativeItem(ModItems.dragonsteel_ice_ingot);
        MATERIAL_DRAGONSTEEL_ICE.setCraftable(false);
        MATERIAL_DRAGONSTEEL_ICE.setCastable(true);
        TinkerRegistry.addMaterialStats((Material)MATERIAL_DRAGONSTEEL_ICE, (IMaterialStats)new HeadMaterialStats(1500, 7.0f, (float)IceAndFire.CONFIG.dragonsteelBaseDamage - 8.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.4f, 400), new ExtraMaterialStats(510)});
        TinkerRegistry.addMaterialStats((Material)MATERIAL_DRAGONSTEEL_ICE, (IMaterialStats)new BowMaterialStats(0.9f, 3.0f, 6.0f));
        MATERIAL_DRAGONSTEEL_ICE.addTrait((ITrait)FREEZE_II, "head");
        MATERIAL_DRAGONSTEEL_ICE.addTrait((ITrait)TinkerTraits.sharp);
        FREEZE_I.addItem(ModItems.ice_dragon_blood);
        FREEZE_I.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack(ModItems.ice_dragon_blood)}));
        BURN_I.addItem(ModItems.fire_dragon_blood);
        BURN_I.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack(ModItems.fire_dragon_blood)}));
        TinkerMaterials.materials.add(MATERIAL_STYMPH_FEATHER);
        TinkerRegistry.integrate((Material)MATERIAL_STYMPH_FEATHER).preInit();
        MATERIAL_STYMPH_FEATHER.addItem(ModItems.stymphalian_bird_feather, 1, 144);
        MATERIAL_STYMPH_FEATHER.setRepresentativeItem(ModItems.stymphalian_bird_feather);
        MATERIAL_STYMPH_FEATHER.addTrait((ITrait)ANTIGRAVITY);
        TinkerRegistry.addMaterialStats((Material)MATERIAL_STYMPH_FEATHER, (IMaterialStats)new FletchingMaterialStats(1.0f, 1.1f));
        TinkerMaterials.materials.add(MATERIAL_AMPHITHERE_FEATHER);
        TinkerRegistry.integrate((Material)MATERIAL_AMPHITHERE_FEATHER).preInit();
        MATERIAL_AMPHITHERE_FEATHER.addItem(ModItems.amphithere_feather, 1, 144);
        MATERIAL_AMPHITHERE_FEATHER.setRepresentativeItem(ModItems.amphithere_feather);
        MATERIAL_AMPHITHERE_FEATHER.addTrait((ITrait)ARROW_KNOCKBACK);
        TinkerRegistry.addMaterialStats((Material)MATERIAL_AMPHITHERE_FEATHER, (IMaterialStats)new FletchingMaterialStats(0.9f, 0.7f));
        if (IceAndFire.CONFIG.weezerTinkers) {
            TinkerMaterials.materials.add(MATERIAL_WEEZER);
            TinkerRegistry.integrate((Material)MATERIAL_WEEZER).preInit();
            MATERIAL_WEEZER.setCraftable(true);
            MATERIAL_WEEZER.setCastable(false);
            MATERIAL_WEEZER.addItem(ModItems.weezer_blue_album, 1, 144);
            MATERIAL_WEEZER.setRepresentativeItem(ModItems.weezer_blue_album);
            TinkerRegistry.addMaterialStats((Material)MATERIAL_WEEZER, (IMaterialStats)new HeadMaterialStats(1500, 5.0f, 10.0f, 4), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.5f, 100), new ExtraMaterialStats(500)});
            TinkerRegistry.addMaterialStats((Material)MATERIAL_WEEZER, (IMaterialStats)new BowMaterialStats(1.5f, 1.2f, 8.0f));
            MATERIAL_WEEZER.addTrait((ITrait)IN_THE_GARAGE);
            MATERIAL_WEEZER.addTrait((ITrait)SWEATER_SONG);
            MATERIAL_WEEZER.addTrait((ITrait)SURF_WAX_AMERICA);
        }
    }

    public static void setupFluids() {
        MOLTEN_FIRE_DRAGONSTEEL = TinkersCompat.fluidMetal("dragonsteel_fire", 5852248);
        MOLTEN_FIRE_DRAGONSTEEL.setTemperature(769);
        MOLTEN_ICE_DRAGONSTEEL = TinkersCompat.fluidMetal("dragonsteel_ice", 8559015);
        MOLTEN_ICE_DRAGONSTEEL.setTemperature(769);
        MATERIAL_DRAGONSTEEL_FIRE.setFluid((Fluid)MOLTEN_FIRE_DRAGONSTEEL);
        MATERIAL_DRAGONSTEEL_ICE.setFluid((Fluid)MOLTEN_ICE_DRAGONSTEEL);
    }

    public static void post() {
    }

    protected static boolean isSmelteryLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");
    }

    private static FluidMolten fluidMetal(String name, int color) {
        FluidMolten fluid = new FluidMolten(name, color);
        return TinkersCompat.registerFluid(fluid);
    }

    protected static <T extends Fluid> T registerFluid(T fluid) {
        fluid.setUnlocalizedName(Util.prefix((String)fluid.getName()));
        FluidRegistry.registerFluid(fluid);
        return fluid;
    }

    static {
        registered = false;
    }
}

