/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.core.ModKeys;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.BlockLaunchExplosion;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.IGroundMount;
import com.github.alexthe666.iceandfire.entity.IPhasesThroughBlock;
import com.github.alexthe666.iceandfire.entity.ISyncMount;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIFindSandTarget;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIGetInSand;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAITarget;
import com.github.alexthe666.iceandfire.entity.ai.DeathWormAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DeathwormAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.EntityGroundAIRide;
import com.github.alexthe666.iceandfire.entity.ai.IAFLookHelper;
import com.github.alexthe666.iceandfire.message.MessageDeathWormHitbox;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateDeathWormLand;
import com.github.alexthe666.iceandfire.pathfinding.PathNavigateDeathWormSand;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.client.model.tools.ChainBuffer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.multipart.IMultipartEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDeathWorm
extends EntityTameable
implements ISyncMount,
IBlacklistedFromStatues,
IMultipartEntity,
IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IPhasesThroughBlock,
IGroundMount {
    public static final ResourceLocation TAN_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "deathworm_tan"));
    public static final ResourceLocation WHITE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "deathworm_white"));
    public static final ResourceLocation RED_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "deathworm_red"));
    public static final ResourceLocation TAN_GIANT_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "deathworm_tan_giant"));
    public static final ResourceLocation WHITE_GIANT_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "deathworm_white_giant"));
    public static final ResourceLocation RED_GIANT_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "deathworm_red_giant"));
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityDeathWorm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityDeathWorm.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntityDeathWorm.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> WORM_AGE = EntityDataManager.func_187226_a(EntityDeathWorm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> HOME = EntityDataManager.func_187226_a(EntityDeathWorm.class, (DataSerializer)DataSerializers.field_187200_j);
    public static Animation ANIMATION_BITE = Animation.create((int)10);
    @SideOnly(value=Side.CLIENT)
    public ChainBuffer tail_buffer;
    private int animationTick;
    private boolean willExplode = false;
    private int ticksTillExplosion = 60;
    private Animation currentAnimation;
    private EntityMutlipartPart[] segments = new EntityMutlipartPart[6];
    private boolean isSandNavigator;
    private float prevScale = 0.0f;
    private EntityLookHelper lookHelper = new IAFLookHelper((EntityLiving)this);
    private int growthCounter = 0;

    public EntityDeathWorm(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
        this.field_70138_W = 1.0f;
        this.func_70105_a(0.8f, 0.8f);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.tail_buffer = new ChainBuffer();
        }
        this.field_175506_bl = Blocks.field_150354_m;
        this.switchNavigator(false);
        this.field_70714_bg.func_75776_a(0, new EntityGroundAIRide<EntityDeathWorm>(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DeathWormAIFindSandTarget(this, 10));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DeathWormAIGetInSand(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DeathWormAIWander(this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, new DeathwormAITargetItems(this, false, false));
        this.field_70715_bh.func_75776_a(5, new DeathWormAITarget<EntityLivingBase>(this, EntityLivingBase.class, false, new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase input) {
                if (EntityDeathWorm.this.func_70909_n()) {
                    return input instanceof EntityMob;
                }
                return (IceAndFire.CONFIG.deathWormAttackMonsters ? input instanceof EntityLivingBase : input instanceof EntityAnimal || input instanceof EntityPlayer) && DragonUtils.isAlive(input) && (!(input instanceof EntityDragonBase) || !((EntityDragonBase)input).isModelDead()) && !EntityDeathWorm.this.func_152114_e(input);
            }
        }));
        this.initSegments(1.0f);
    }

    public EntityLookHelper func_70671_ap() {
        return this.lookHelper;
    }

    public boolean func_70601_bi() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        return this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c() == this.field_175506_bl && this.func_70681_au().nextInt(1 + IceAndFire.CONFIG.deathWormSpawnCheckChance) == 0 && this.field_70170_p.func_175699_k(blockpos) > 8 && super.func_70601_bi();
    }

    public void onUpdateParts() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            entity.func_70071_h_();
        }
    }

    protected int func_70693_a(EntityPlayer player) {
        return this.getScaleForAge() > 3.0f ? 20 : 10;
    }

    public void initSegments(float scale) {
        this.func_98054_a(false);
        this.segments = new EntityMutlipartPart[11];
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new EntityMutlipartPart((EntityLiving)this, (-0.8f - (float)i * 0.8f) * scale, 0.0f, 0.0f, 0.7f * scale, 0.7f * scale, 1.0f);
        }
    }

    private void clearSegments() {
        for (EntityMutlipartPart entity : this.segments) {
            if (entity == null) continue;
            entity.func_174812_G();
            this.field_70170_p.func_72973_f((Entity)entity);
        }
    }

    public void setExplosive(boolean explosive) {
        this.willExplode = true;
        this.ticksTillExplosion = 60;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            this.func_184185_a(this.getScaleForAge() > 3.0f ? ModSounds.DEATHWORM_GIANT_ATTACK : ModSounds.DEATHWORM_ATTACK, 1.0f, 1.0f);
        }
        if (this.func_70681_au().nextInt(3) == 0 && this.getScaleForAge() > 1.0f && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && !MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((EntityLiving)this, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v))) {
            BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.field_70170_p, (Entity)this, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, this.getScaleForAge());
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((EntityLivingBase)this, (DamageSource)cause)) {
            return;
        }
        this.clearSegments();
        if (!this.field_70729_aU) {
            Entity entity = cause.func_76346_g();
            EntityLivingBase entitylivingbase = this.func_94060_bK();
            if (this.field_70744_aE >= 0 && entitylivingbase != null) {
                entitylivingbase.func_191956_a((Entity)this, this.field_70744_aE, cause);
            }
            if (entity != null) {
                entity.func_70074_a((EntityLivingBase)this);
            }
            this.field_70729_aU = true;
            this.func_110142_aN().func_94549_h();
            if (!this.field_70170_p.field_72995_K) {
                int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)entity, (DamageSource)cause);
                this.captureDrops = true;
                this.capturedDrops.clear();
                if (this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                    boolean flag = this.field_70718_bc > 0;
                    this.func_184610_a(flag, i, cause);
                }
                this.captureDrops = false;
                if (!ForgeHooks.onLivingDrops((EntityLivingBase)this, (DamageSource)cause, (ArrayList)this.capturedDrops, (int)i, (this.field_70718_bc > 0 ? 1 : 0) != 0)) {
                    for (EntityItem item : this.capturedDrops) {
                        this.field_70170_p.func_72838_d((Entity)item);
                        item.field_70163_u = this.getSurface((int)item.field_70165_t, (int)item.field_70163_u, (int)item.field_70161_v);
                    }
                }
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Nullable
    private EntityItem dropItemAt(ItemStack stack, double x, double y, double z) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, x, y, z, stack);
        entityitem.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getVariant()) {
            case 0: {
                return this.getScaleForAge() > 3.0f ? TAN_GIANT_LOOT : TAN_LOOT;
            }
            case 1: {
                return this.getScaleForAge() > 3.0f ? WHITE_GIANT_LOOT : WHITE_LOOT;
            }
            case 2: {
                return this.getScaleForAge() > 3.0f ? RED_GIANT_LOOT : RED_LOOT;
            }
        }
        return null;
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
        this.field_70180_af.func_187214_a(WORM_AGE, (Object)10);
        this.field_70180_af.func_187214_a(HOME, (Object)BlockPos.field_177992_a);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("GrowthCounter", this.growthCounter);
        compound.func_74776_a("Scale", this.getScale());
        compound.func_74768_a("WormAge", this.getWormAge());
        compound.func_74772_a("WormHome", this.getWormHome().func_177986_g());
        compound.func_74757_a("WillExplode", this.willExplode);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.growthCounter = compound.func_74762_e("GrowthCounter");
        this.setDeathWormScale(compound.func_74760_g("Scale"));
        this.setWormAge(compound.func_74762_e("WormAge"));
        this.setWormHome(BlockPos.func_177969_a((long)compound.func_74763_f("WormHome")));
        this.willExplode = compound.func_74767_n("WillExplode");
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getControlState() {
        return (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
    }

    public void setControlState(byte state) {
        this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)state);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public BlockPos getWormHome() {
        return (BlockPos)this.field_70180_af.func_187225_a(HOME);
    }

    public void setWormHome(BlockPos home) {
        if (home instanceof BlockPos) {
            this.field_70180_af.func_187227_b(HOME, (Object)home);
        }
    }

    public int getWormAge() {
        return Math.max(1, (Integer)this.field_70180_af.func_187225_a(WORM_AGE));
    }

    public void setWormAge(int age) {
        this.field_70180_af.func_187227_b(WORM_AGE, (Object)age);
    }

    public float getScale() {
        return Float.valueOf(((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue()).floatValue();
    }

    public float getScaleForAge() {
        return this.getScale() * ((float)this.getWormAge() / 5.0f);
    }

    public void func_98054_a(boolean baby) {
        this.func_98055_j(Math.min(this.getScaleForAge(), 7.0f));
    }

    public void setDeathWormScale(float scale) {
        this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(scale));
        this.updateAttributes();
        this.clearSegments();
        if (!this.field_70170_p.field_72995_K) {
            this.initSegments(scale * ((float)this.getWormAge() / 5.0f));
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageDeathWormHitbox(this.func_145782_y(), scale * ((float)this.getWormAge() / 5.0f)));
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setVariant(this.func_70681_au().nextInt(3));
        float size = 0.25f + (float)(Math.random() * (double)0.35f);
        this.setDeathWormScale(this.func_70681_au().nextInt(20) == 0 ? size * 4.0f : size);
        if (this.isSandBelow() && this.getScaleForAge() != 1.0f) {
            this.field_70181_x = -0.5;
        }
        return livingdata;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(IceAndFire.CONFIG.deathWormAttackStrength);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(IceAndFire.CONFIG.deathWormMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)Math.min(2048, IceAndFire.CONFIG.deathWormTargetSearchLength));
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            this.field_70761_aq = this.field_70177_z;
            this.field_70177_z = passenger.field_70177_z;
            float radius = -0.5f * this.getScaleForAge();
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + (double)this.func_70047_e() - (double)0.55f, this.field_70161_v + extraZ);
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)passenger;
            return player;
        }
        return null;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_184586_b(hand).func_111282_a(player, (EntityLivingBase)this, hand)) {
            return true;
        }
        if (this.getWormAge() > 4 && !player.func_184218_aH() && player.func_184614_ca().func_77973_b() == Items.field_151112_aM && player.func_184592_cb().func_77973_b() == Items.field_151112_aM && !this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    private void switchNavigator(boolean inSand) {
        if (inSand) {
            this.field_70765_h = new SandMoveHelper();
            this.field_70699_by = new PathNavigateDeathWormSand(this, this.field_70170_p);
            this.isSandNavigator = true;
        } else {
            this.field_70765_h = new EntityMoveHelper((EntityLiving)this);
            this.field_70699_by = new PathNavigateDeathWormLand(this, this.field_70170_p);
            this.isSandNavigator = false;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d || source == DamageSource.field_82729_p) {
            return false;
        }
        if (this.func_184207_aI() && source.func_76346_g() != null && this.func_184179_bs() != null && source.func_76346_g() == this.func_184179_bs()) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean checkBlockCollision(AxisAlignedBB bb) {
        int j2 = MathHelper.func_76128_c((double)bb.field_72340_a);
        int k2 = MathHelper.func_76143_f((double)bb.field_72336_d);
        int l2 = MathHelper.func_76128_c((double)bb.field_72338_b);
        int i3 = MathHelper.func_76143_f((double)bb.field_72337_e);
        int j3 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int k3 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int l3 = j2; l3 < k2; ++l3) {
            for (int i4 = l2; i4 < i3; ++i4) {
                for (int j4 = j3; j4 < k3; ++j4) {
                    IBlockState iblockstate1 = this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(l3, i4, j4));
                    if (iblockstate1.func_185904_a() == Material.field_151579_a || iblockstate1.func_185904_a() == Material.field_151595_p) continue;
                    blockpos$pooledmutableblockpos.func_185344_t();
                    return true;
                }
            }
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    public boolean func_70094_T() {
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (int i = 0; i < 8; ++i) {
            int j = MathHelper.func_76128_c((double)(this.field_70163_u + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)this.func_70047_e()));
            int k = MathHelper.func_76128_c((double)(this.field_70165_t + (double)(((float)((i >> 1) % 2) - 0.5f) * this.field_70130_N * 0.8f)));
            int l = MathHelper.func_76128_c((double)(this.field_70161_v + (double)(((float)((i >> 2) % 2) - 0.5f) * this.field_70130_N * 0.8f)));
            if (blockpos$pooledmutableblockpos.func_177958_n() == k && blockpos$pooledmutableblockpos.func_177956_o() == j && blockpos$pooledmutableblockpos.func_177952_p() == l) continue;
            blockpos$pooledmutableblockpos.func_181079_c(k, j, l);
            if (!this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_191058_s() || this.field_70170_p.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_185904_a() == Material.field_151595_p) continue;
            blockpos$pooledmutableblockpos.func_185344_t();
            return true;
        }
        blockpos$pooledmutableblockpos.func_185344_t();
        return false;
    }

    protected boolean func_145771_j(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        double d0 = x - (double)blockpos.func_177958_n();
        double d1 = y - (double)blockpos.func_177956_o();
        double d2 = z - (double)blockpos.func_177952_p();
        if (!this.field_70170_p.func_184143_b(this.func_174813_aQ())) {
            return false;
        }
        EnumFacing enumfacing = EnumFacing.UP;
        double d3 = Double.MAX_VALUE;
        if (!this.isBlockFullCube(blockpos.func_177976_e()) && d0 < d3) {
            d3 = d0;
            enumfacing = EnumFacing.WEST;
        }
        if (!this.isBlockFullCube(blockpos.func_177974_f()) && 1.0 - d0 < d3) {
            d3 = 1.0 - d0;
            enumfacing = EnumFacing.EAST;
        }
        if (!this.isBlockFullCube(blockpos.func_177978_c()) && d2 < d3) {
            d3 = d2;
            enumfacing = EnumFacing.NORTH;
        }
        if (!this.isBlockFullCube(blockpos.func_177968_d()) && 1.0 - d2 < d3) {
            d3 = 1.0 - d2;
            enumfacing = EnumFacing.SOUTH;
        }
        if (!this.isBlockFullCube(blockpos.func_177984_a()) && 1.0 - d1 < d3) {
            d3 = 1.0 - d1;
            enumfacing = EnumFacing.UP;
        }
        float f = this.field_70146_Z.nextFloat() * 0.2f + 0.1f;
        float f1 = enumfacing.func_176743_c().func_179524_a();
        if (enumfacing.func_176740_k() == EnumFacing.Axis.X) {
            this.field_70159_w = f1 * f;
            this.field_70181_x *= 0.75;
            this.field_70179_y *= 0.75;
        } else if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            this.field_70159_w *= 0.75;
            this.field_70181_x = f1 * f;
            this.field_70179_y *= 0.75;
        } else if (enumfacing.func_176740_k() == EnumFacing.Axis.Z) {
            this.field_70159_w *= 0.75;
            this.field_70181_x *= 0.75;
            this.field_70179_y = f1 * f;
        }
        return true;
    }

    private boolean isBlockFullCube(BlockPos pos) {
        AxisAlignedBB axisalignedbb = this.field_70170_p.func_180495_p(pos).func_185890_d((IBlockAccess)this.field_70170_p, pos);
        return this.field_70170_p.func_180495_p(pos).func_185904_a() != Material.field_151595_p && axisalignedbb != Block.field_185506_k && axisalignedbb.func_72320_b() >= 1.0;
    }

    private void updateAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(Math.min(0.2, 0.15 * (double)this.getScaleForAge()));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Math.max(1.0, IceAndFire.CONFIG.deathWormAttackStrength * (double)this.getScaleForAge()));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Math.max(6.0, IceAndFire.CONFIG.deathWormMaxHealth * (double)this.getScaleForAge()));
        this.func_70606_j((float)this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        if (this.func_70909_n()) {
            this.func_70691_i(14.0f);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70638_az() instanceof EntityPlayer) {
            this.func_70624_b(null);
        }
        if (this.willExplode) {
            if (this.ticksTillExplosion == 0) {
                boolean b = !MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((EntityLiving)this, this.field_70165_t, this.field_70163_u, this.field_70161_v));
                this.field_70170_p.func_72885_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.5f * this.getScaleForAge(), false, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) && b);
            } else {
                --this.ticksTillExplosion;
            }
        }
        if (this.field_70173_aa == 1) {
            this.initSegments(this.getScaleForAge());
        }
        if (this.growthCounter > 1000 && this.getWormAge() < 5) {
            this.growthCounter = 0;
            this.setWormAge(Math.min(5, this.getWormAge() + 1));
            this.clearSegments();
            this.func_70691_i(15.0f);
            this.setDeathWormScale(this.getScale());
            if (this.field_70170_p.field_72995_K) {
                int i = 0;
                while ((float)i < 10.0f * this.getScaleForAge()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, (double)((float)this.getSurface((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v)) + 0.5f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
                    for (int j = 0; j < this.segments.length; ++j) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.segments[j].field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.segments[j].field_70130_N * 2.0f) - (double)this.segments[j].field_70130_N, (double)((float)this.getSurface((int)Math.floor(this.segments[j].field_70165_t), (int)Math.floor(this.segments[j].field_70163_u), (int)Math.floor(this.segments[j].field_70161_v)) + 0.5f), this.segments[j].field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.segments[j].field_70130_N * 2.0f) - (double)this.segments[j].field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[0]);
                    }
                    ++i;
                }
            }
        }
        if (this.getWormAge() < 5) {
            ++this.growthCounter;
        }
        if (this.func_184179_bs() != null) {
            if (this.func_70094_T()) {
                this.field_70181_x = 2.0;
            } else {
                this.field_70145_X = false;
            }
        }
        if (this.func_184179_bs() != null && this.func_70638_az() != null) {
            this.func_70661_as().func_75499_g();
            this.func_70624_b(null);
        }
        if (this.func_70638_az() == null) {
            this.field_70125_A = 0.0f;
        } else {
            this.func_70625_a((Entity)this.func_70638_az(), 10.0f, 10.0f);
            double dist = this.func_70068_e((Entity)this.func_70638_az());
            if (dist >= 4.0 * (double)this.getScaleForAge() && dist <= 16.0 * (double)this.getScaleForAge() && (this.isInSand() || this.field_70122_E)) {
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                float leap = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                if ((double)leap >= 1.0E-4) {
                    this.field_70159_w += d0 / (double)leap * (double)0.8f + this.field_70159_w * (double)0.2f;
                    this.field_70179_y += d1 / (double)leap * (double)0.8f + this.field_70179_y * (double)0.2f;
                }
                this.field_70181_x = 0.5;
                this.setAnimation(ANIMATION_BITE);
            }
            if (dist < Math.min(4.0, 4.0 * (double)this.getScaleForAge()) && this.getAnimation() == ANIMATION_BITE) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
                this.field_70181_x /= 2.0;
                this.field_70181_x -= 0.4;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175667_e((BlockPos)blockpos$mutableblockpos)) {
            blockpos$mutableblockpos.func_185336_p(MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e())));
            if (this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() == Material.field_151595_p || this.func_70094_T()) {
                blockpos$mutableblockpos.func_185336_p(this.field_70170_p.func_189649_b(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v)));
            }
            return this.field_70170_p.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
        }
        return 0;
    }

    public int getSurface(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        while (!this.field_70170_p.func_175623_d(pos)) {
            pos = pos.func_177984_a();
        }
        return pos.func_177956_o();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.getScaleForAge() > 3.0f ? ModSounds.DEATHWORM_GIANT_IDLE : ModSounds.DEATHWORM_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.getScaleForAge() > 3.0f ? ModSounds.DEATHWORM_GIANT_HURT : ModSounds.DEATHWORM_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.getScaleForAge() > 3.0f ? ModSounds.DEATHWORM_GIANT_DIE : ModSounds.DEATHWORM_DIE;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.onUpdateParts();
        if (this.attack() && this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
            EntityLivingBase target = DragonUtils.riderLookingAtEntity((EntityLivingBase)this, (EntityLivingBase)((EntityPlayer)this.func_184179_bs()), 3.0);
            if (this.getAnimation() != ANIMATION_BITE) {
                this.setAnimation(ANIMATION_BITE);
                this.func_184185_a(this.getScaleForAge() > 3.0f ? ModSounds.DEATHWORM_GIANT_ATTACK : ModSounds.DEATHWORM_ATTACK, 1.0f, 1.0f);
                if (this.func_70681_au().nextInt(3) == 0 && this.getScaleForAge() > 1.0f) {
                    float radius = 1.5f * this.getScaleForAge();
                    float angle = (float)Math.PI / 180 * this.field_70761_aq;
                    double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * MathHelper.func_76134_b((float)angle);
                    BlockLaunchExplosion explosion = new BlockLaunchExplosion(this.field_70170_p, (Entity)this, this.field_70165_t + extraX, this.field_70163_u - (double)this.func_70047_e(), this.field_70161_v + extraZ, this.getScaleForAge() * 0.75f);
                    explosion.func_77278_a();
                    explosion.func_77279_a(true);
                }
            }
            if (target != null) {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            }
        }
        if (!this.isInSand()) {
            this.field_70145_X = false;
        } else {
            IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, (double)this.getSurface((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v)), this.field_70161_v).func_177977_b());
            int blockId = Block.func_176210_f((IBlockState)state);
            if (state.func_185914_p() && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, (double)((float)this.getSurface((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v)) + 0.5f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[]{blockId});
                for (int i = 0; i < this.segments.length; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.segments[i].field_70169_q + (double)(this.field_70146_Z.nextFloat() * this.segments[i].field_70130_N * 2.0f) - (double)this.segments[i].field_70130_N, (double)((float)this.getSurface((int)Math.floor(this.segments[i].field_70169_q), (int)Math.floor(this.segments[i].field_70167_r), (int)Math.floor(this.segments[i].field_70166_s)) + 0.5f), this.segments[i].field_70166_s + (double)(this.field_70146_Z.nextFloat() * this.segments[i].field_70130_N * 2.0f) - (double)this.segments[i].field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[]{blockId});
                }
            }
            if (this.field_70173_aa % 10 == 0) {
                this.func_184185_a(SoundEvents.field_187747_eB, 1.0f, 0.5f);
            }
        }
        if (this.up() && this.field_70122_E) {
            this.func_70664_aZ();
        }
        if (this.isInSand() && !this.isSandNavigator) {
            this.switchNavigator(true);
        }
        if (!this.isInSandStrict() && this.isSandNavigator) {
            this.switchNavigator(false);
        }
        if (this.field_70170_p.field_72995_K) {
            this.tail_buffer.calculateChainSwingBuffer(90.0f, 20, 5.0f, (EntityLivingBase)this);
        }
        if (this.func_184179_bs() != null) {
            this.field_70145_X = false;
            this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
            if (this.isSandBelow() && this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, (double)((float)this.getSurface((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v)) + 0.5f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[]{Block.func_149682_b((Block)Blocks.field_150354_m)});
                for (int i = 0; i < this.segments.length; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.segments[i].field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.segments[i].field_70130_N * 2.0f) - (double)this.segments[i].field_70130_N, (double)((float)this.getSurface((int)Math.floor(this.segments[i].field_70165_t), (int)Math.floor(this.segments[i].field_70163_u), (int)Math.floor(this.segments[i].field_70161_v)) + 0.5f), this.segments[i].field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.segments[i].field_70130_N * 2.0f) - (double)this.segments[i].field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[]{Block.func_149682_b((Block)Blocks.field_150354_m)});
                }
            }
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClientControls() {
        byte controlState;
        byte previousState;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((EntityPlayer)mc.field_71439_g)) {
            previousState = this.getControlState();
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            this.attack(ModKeys.dragon_strike.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
        if (this.func_184187_bx() != null && this.func_184187_bx() == mc.field_71439_g) {
            previousState = this.getControlState();
            this.dismount(mc.field_71474_y.field_74311_E.func_151470_d());
            controlState = this.getControlState();
            if (controlState != previousState) {
                IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonControl(this.func_145782_y(), controlState, this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
        }
    }

    public boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    public boolean dismount() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean attack() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void dismount(boolean dismount) {
        this.setStateField(1, dismount);
    }

    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    public boolean isSandBelow() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), k = MathHelper.func_76128_c((double)this.field_70161_v));
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        return iblockstate.func_185904_a() == Material.field_151595_p;
    }

    public boolean isInSand() {
        return this.func_184179_bs() == null && this.field_70170_p.func_72875_a(this.func_174813_aQ().func_72314_b(0.25, 0.25, 0.25), Material.field_151595_p);
    }

    public boolean isInSandStrict() {
        return this.func_184179_bs() == null && this.field_70170_p.func_72875_a(this.func_174813_aQ(), Material.field_151595_p);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE};
    }

    public Entity[] getWormParts() {
        return this.segments;
    }

    public int func_184649_cE() {
        return 10;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        EntityLivingBase controller;
        if (this.func_184207_aI() && this.func_82171_bF() && (controller = (EntityLivingBase)this.func_184179_bs()) != null) {
            if (this.func_70638_az() != null) {
                this.func_70624_b(null);
                this.func_70661_as().func_75499_g();
            }
            super.func_191986_a(strafe, vertical, forward);
            return;
        }
        if (this.func_70613_aW()) {
            if (this.isInSandStrict()) {
                this.func_191958_b(strafe, vertical, forward, 0.1f);
                float f4 = 0.8f;
                float d0 = EnchantmentHelper.func_185294_d((EntityLivingBase)this);
                if (d0 > 3.0f) {
                    d0 = 3.0f;
                }
                if (!this.field_70122_E) {
                    d0 *= 0.5f;
                }
                if (d0 > 0.0f) {
                    f4 += (0.54600006f - f4) * d0 / 3.0f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)f4;
                this.field_70159_w *= 0.900000011920929;
                this.field_70181_x *= 0.900000011920929;
                this.field_70181_x *= (double)f4;
                this.field_70179_y *= 0.900000011920929;
                this.field_70179_y *= (double)f4;
            } else {
                super.func_191986_a(strafe, vertical, forward);
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double deltaX = this.field_70165_t - this.field_70169_q;
        double deltaY = this.field_70163_u - this.field_70167_r;
        double deltaZ = this.field_70161_v - this.field_70166_s;
        float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 4.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.field_70721_aZ += (delta - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    @Override
    public boolean canPhaseThroughBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151595_p;
    }

    public boolean func_174816_a(Explosion explosionIn, World worldIn, BlockPos pos, IBlockState blockStateIn, float p_174816_5_) {
        float hardness = blockStateIn.func_185887_b(worldIn, pos);
        return hardness != -1.0f && hardness < 1.5f;
    }

    public boolean func_104002_bU() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean isRidingPlayer(EntityPlayer player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().func_110124_au().equals(player.func_110124_au());
    }

    @Override
    @Nullable
    public EntityPlayer getRidingPlayer() {
        if (this.func_184179_bs() instanceof EntityPlayer) {
            return (EntityPlayer)this.func_184179_bs();
        }
        return null;
    }

    @Override
    public double getRideSpeedModifier() {
        return 1.0;
    }

    public class SandMoveHelper
    extends EntityMoveHelper {
        private EntityDeathWorm worm;

        public SandMoveHelper() {
            super((EntityLiving)EntityDeathWorm.this);
            this.worm = EntityDeathWorm.this;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.worm.func_70661_as().func_75500_f() && !this.worm.func_184207_aI()) {
                double distanceX = this.field_75646_b - this.worm.field_70165_t;
                double distanceY = this.field_75647_c - this.worm.field_70163_u;
                double distanceZ = this.field_75644_d - this.worm.field_70161_v;
                double distance = Math.abs(distanceX * distanceX + distanceZ * distanceZ);
                double distanceWithY = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ));
                float angle = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.worm.field_70177_z = this.func_75639_a(this.worm.field_70177_z, angle, 30.0f);
                this.worm.func_70659_e(1.0f);
                this.worm.field_70181_x += (double)this.worm.func_70689_ay() * (distanceY /= distanceWithY) * 0.1;
                if (distance < (double)Math.max(1.0f, this.field_75648_a.field_70130_N)) {
                    float f = this.worm.field_70177_z * ((float)Math.PI / 180);
                    this.worm.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.35f);
                    this.worm.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.35f);
                }
            } else if (this.field_188491_h == EntityMoveHelper.Action.JUMPING) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
            } else {
                this.worm.func_70659_e(0.0f);
            }
        }
    }
}

