/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.entity.EntityDreadMob;
import com.github.alexthe666.iceandfire.entity.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.IDreadMob;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.ai.DreadAITargetNonDread;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityDreadThrall
extends EntityDreadMob
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dread_thrall"));
    private static final DataParameter<Boolean> CUSTOM_ARMOR_HEAD = EntityDataManager.func_187226_a(EntityDreadThrall.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CUSTOM_ARMOR_CHEST = EntityDataManager.func_187226_a(EntityDreadThrall.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CUSTOM_ARMOR_LEGS = EntityDataManager.func_187226_a(EntityDreadThrall.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CUSTOM_ARMOR_FEET = EntityDataManager.func_187226_a(EntityDreadThrall.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CUSTOM_ARMOR_INDEX = EntityDataManager.func_187226_a(EntityDreadThrall.class, (DataSerializer)DataSerializers.field_187192_b);
    public static Animation ANIMATION_SPAWN = Animation.create((int)40);
    private int animationTick;
    private Animation currentAnimation;

    public EntityDreadThrall(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{IDreadMob.class}));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DreadAITargetNonDread((EntityCreature)this, EntityLivingBase.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CUSTOM_ARMOR_INDEX, (Object)0);
        this.field_70180_af.func_187214_a(CUSTOM_ARMOR_HEAD, (Object)false);
        this.field_70180_af.func_187214_a(CUSTOM_ARMOR_CHEST, (Object)false);
        this.field_70180_af.func_187214_a(CUSTOM_ARMOR_LEGS, (Object)false);
        this.field_70180_af.func_187214_a(CUSTOM_ARMOR_FEET, (Object)false);
    }

    @Override
    public void func_70636_d() {
        Block belowBlock;
        super.func_70636_d();
        if (this.getAnimation() == ANIMATION_SPAWN && this.getAnimationTick() < 30 && (belowBlock = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c()) != Blocks.field_150350_a) {
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.func_174813_aQ().field_72338_b, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[]{Block.func_149682_b((Block)belowBlock)});
            }
        }
        if (this.func_184614_ca().func_77973_b() == Items.field_151031_f) {
            this.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151103_aS));
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        if (this.field_70146_Z.nextFloat() < 0.75f) {
            double chance = this.field_70146_Z.nextFloat();
            if (chance < (double)0.0025f) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.dragonsteel_ice_sword));
            }
            if (chance < (double)0.01f) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151048_u));
            }
            if (chance < (double)0.1f) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
            }
            if (chance < 0.75) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModItems.dread_sword));
            }
        }
        if (this.field_70146_Z.nextFloat() < 0.75f) {
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
            this.setCustomArmorHead(this.field_70146_Z.nextInt(8) != 0);
        }
        if (this.field_70146_Z.nextFloat() < 0.75f) {
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151023_V));
            this.setCustomArmorChest(this.field_70146_Z.nextInt(8) != 0);
        }
        if (this.field_70146_Z.nextFloat() < 0.75f) {
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W));
            this.setCustomArmorLegs(this.field_70146_Z.nextInt(8) != 0);
        }
        if (this.field_70146_Z.nextFloat() < 0.75f) {
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151029_X));
            this.setCustomArmorFeet(this.field_70146_Z.nextInt(8) != 0);
        }
        this.setArmorVariant(this.field_70146_Z.nextInt(8));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        this.setAnimation(ANIMATION_SPAWN);
        this.func_180481_a(difficulty);
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ArmorVariant", this.getArmorVariant());
        compound.func_74757_a("HasCustomHelmet", this.hasCustomArmorHead());
        compound.func_74757_a("HasCustomChestplate", this.hasCustomArmorChest());
        compound.func_74757_a("HasCustomLeggings", this.hasCustomArmorLegs());
        compound.func_74757_a("HasCustomBoots", this.hasCustomArmorFeet());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setArmorVariant(compound.func_74762_e("ArmorVariant"));
        this.setCustomArmorHead(compound.func_74767_n("HasCustomHelmet"));
        this.setCustomArmorChest(compound.func_74767_n("HasCustomChestplate"));
        this.setCustomArmorLegs(compound.func_74767_n("HasCustomLeggings"));
        this.setCustomArmorFeet(compound.func_74767_n("HasCustomBoots"));
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public boolean hasCustomArmorHead() {
        return (Boolean)this.field_70180_af.func_187225_a(CUSTOM_ARMOR_HEAD);
    }

    public void setCustomArmorHead(boolean head) {
        this.field_70180_af.func_187227_b(CUSTOM_ARMOR_HEAD, (Object)head);
    }

    public boolean hasCustomArmorChest() {
        return (Boolean)this.field_70180_af.func_187225_a(CUSTOM_ARMOR_CHEST);
    }

    public void setCustomArmorChest(boolean head) {
        this.field_70180_af.func_187227_b(CUSTOM_ARMOR_CHEST, (Object)head);
    }

    public boolean hasCustomArmorLegs() {
        return (Boolean)this.field_70180_af.func_187225_a(CUSTOM_ARMOR_LEGS);
    }

    public void setCustomArmorLegs(boolean head) {
        this.field_70180_af.func_187227_b(CUSTOM_ARMOR_LEGS, (Object)head);
    }

    public boolean hasCustomArmorFeet() {
        return (Boolean)this.field_70180_af.func_187225_a(CUSTOM_ARMOR_FEET);
    }

    public void setCustomArmorFeet(boolean head) {
        this.field_70180_af.func_187227_b(CUSTOM_ARMOR_FEET, (Object)head);
    }

    public int getArmorVariant() {
        return (Integer)this.field_70180_af.func_187225_a(CUSTOM_ARMOR_INDEX);
    }

    public void setArmorVariant(int variant) {
        this.field_70180_af.func_187227_b(CUSTOM_ARMOR_INDEX, (Object)variant);
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPAWN};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public boolean shouldFear() {
        return true;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190032_gu;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_190034_gw;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190033_gv;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_190035_gx, 0.15f, 1.0f);
    }
}

