/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityHydraBreath;
import com.github.alexthe666.iceandfire.entity.EntityHydraHead;
import com.github.alexthe666.iceandfire.entity.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.ilexiconn.llibrary.server.entity.multipart.IMultipartEntity;
import net.ilexiconn.llibrary.server.entity.multipart.PartEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHydra
extends EntityMob
implements IAnimatedEntity,
IMultipartEntity,
IVillagerFear,
IAnimalFear {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "hydra"));
    public static final int HEADS = 9;
    public static final double HEAD_HEALTH_THRESHOLD = 20.0;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityHydra.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEAD_COUNT = EntityDataManager.func_187226_a(EntityHydra.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SEVERED_HEAD = EntityDataManager.func_187226_a(EntityHydra.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};
    public boolean[] isStriking = new boolean[9];
    public float[] strikingProgress = new float[9];
    public float[] prevStrikeProgress = new float[9];
    public boolean[] isBreathing = new boolean[9];
    public float[] speakingProgress = new float[9];
    public float[] prevSpeakingProgress = new float[9];
    public float[] breathProgress = new float[9];
    public float[] prevBreathProgress = new float[9];
    public int[] breathTicks = new int[9];
    public float[] headDamageTracker = new float[9];
    private int animationTick;
    private Animation currentAnimation;
    private EntityHydraHead[] headBoxes = new EntityHydraHead[81];
    private int strikeCooldown = 0;
    private int breathCooldown = 0;
    private int lastHitHead = 0;
    private int prevHeadCount = -1;
    private int regrowHeadCooldown = 0;
    private boolean onlyRegrowOneHeadNotTwo = false;
    private float headDamageThreshold = 20.0f;

    public EntityHydra(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.8f, 1.39f);
        this.resetParts();
        this.headDamageThreshold = Math.max(5.0f, (float)IceAndFire.CONFIG.hydraMaxHealth * 0.08f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity.func_70089_S();
            }
        }));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, true, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(entity, StoneEntityProperties.class);
                return entity instanceof EntityLivingBase && DragonUtils.isAlive((EntityLivingBase)((EntityLiving)entity)) && !(entity instanceof PartEntity) && !(entity instanceof IMob) && (properties == null || properties != null && !properties.isStone) || entity instanceof IBlacklistedFromStatues && ((IBlacklistedFromStatues)entity).canBeTurnedToStone();
            }
        }));
    }

    public boolean func_70652_k(Entity entityIn) {
        return false;
    }

    public void func_70636_d() {
        int index;
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az()) && !this.isBreathing[index = this.field_70146_Z.nextInt(this.getHeadCount())] && !this.isStriking[index]) {
            if (this.func_70032_d((Entity)this.func_70638_az()) < 6.0f) {
                if (this.strikeCooldown == 0 && this.strikingProgress[index] == 0.0f) {
                    this.isBreathing[index] = false;
                    this.isStriking[index] = true;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)(40 + index));
                    this.strikeCooldown = 3;
                }
            } else if (this.field_70146_Z.nextBoolean() && this.breathCooldown == 0) {
                this.isBreathing[index] = true;
                this.isStriking[index] = false;
                this.field_70170_p.func_72960_a((Entity)this, (byte)(50 + index));
                this.breathCooldown = 15;
            }
        }
        for (int i = 0; i < 9; ++i) {
            boolean striking = this.isStriking[i];
            boolean breathing = this.isBreathing[i];
            this.prevStrikeProgress[i] = this.strikingProgress[i];
            if (striking && this.strikingProgress[i] > 9.0f) {
                this.isStriking[i] = false;
                if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 6.0f) {
                    this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                    this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 3, false, false));
                    this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 0.25f, this.field_70165_t - this.func_70638_az().field_70165_t, this.field_70161_v - this.func_70638_az().field_70161_v);
                }
            }
            if (breathing) {
                EntityLivingBase entity = this.func_70638_az();
                if (this.field_70173_aa % 7 == 0 && entity != null && i < this.getHeadCount()) {
                    Vec3d vec3d = this.func_70676_i(1.0f);
                    if (this.field_70146_Z.nextFloat() < 0.2f) {
                        this.func_184185_a(ModSounds.HYDRA_SPIT, this.func_70599_aP(), this.func_70647_i());
                    }
                    double headPosX = this.headBoxes[i].field_70165_t + vec3d.field_72450_a * 1.0;
                    double headPosY = this.headBoxes[i].field_70163_u + (double)1.3f;
                    double headPosZ = this.headBoxes[i].field_70161_v + vec3d.field_72449_c * 1.0;
                    double d2 = entity.field_70165_t - headPosX + this.field_70146_Z.nextGaussian() * 0.4;
                    double d3 = entity.field_70163_u + (double)entity.func_70047_e() - headPosY + this.field_70146_Z.nextGaussian() * 0.4;
                    double d4 = entity.field_70161_v - headPosZ + this.field_70146_Z.nextGaussian() * 0.4;
                    EntityHydraBreath entitylargefireball = new EntityHydraBreath(this.field_70170_p, this, d2, d3, d4);
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K && !entity.field_70128_L) {
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    }
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                }
                if (this.isBreathing[i] && (entity == null || entity.field_70128_L || this.breathTicks[i] > 60) && !this.field_70170_p.field_72995_K) {
                    this.isBreathing[i] = false;
                    this.breathTicks[i] = 0;
                    this.breathCooldown = 15;
                    this.field_70170_p.func_72960_a((Entity)this, (byte)(60 + i));
                }
                int n = i;
                this.breathTicks[n] = this.breathTicks[n] + 1;
            } else {
                this.breathTicks[i] = 0;
            }
            if (striking && this.strikingProgress[i] < 10.0f) {
                int n = i;
                this.strikingProgress[n] = this.strikingProgress[n] + 2.5f;
            } else if (!striking && this.strikingProgress[i] > 0.0f) {
                int n = i;
                this.strikingProgress[n] = this.strikingProgress[n] - 2.5f;
            }
            this.prevSpeakingProgress[i] = this.speakingProgress[i];
            if (this.speakingProgress[i] > 0.0f) {
                int n = i;
                this.speakingProgress[n] = this.speakingProgress[n] - 0.1f;
            }
            this.prevBreathProgress[i] = this.breathProgress[i];
            if (breathing && this.breathProgress[i] < 10.0f) {
                int n = i;
                this.breathProgress[n] = this.breathProgress[n] + 1.0f;
                continue;
            }
            if (breathing || !(this.breathProgress[i] > 0.0f)) continue;
            int n = i;
            this.breathProgress[n] = this.breathProgress[n] - 1.0f;
        }
        if (this.strikeCooldown > 0) {
            --this.strikeCooldown;
        }
        if (this.breathCooldown > 0) {
            --this.breathCooldown;
        }
        if (this.getHeadCount() == 1 && this.getSeveredHead() != -1) {
            this.setSeveredHead(-1);
        }
        if (this.getHeadCount() == 1 && !this.func_70027_ad()) {
            this.setHeadCount(2);
            this.setSeveredHead(1);
            this.onlyRegrowOneHeadNotTwo = true;
        }
        if (this.getSeveredHead() != -1 && this.getSeveredHead() < this.getHeadCount()) {
            this.setSeveredHead(MathHelper.func_76125_a((int)this.getSeveredHead(), (int)0, (int)(this.getHeadCount() - 1)));
            ++this.regrowHeadCooldown;
            if (this.regrowHeadCooldown >= 100) {
                this.headDamageTracker[this.getSeveredHead()] = 0.0f;
                this.setSeveredHead(-1);
                if (this.func_70027_ad()) {
                    this.setHeadCount(this.getHeadCount() - 1);
                } else {
                    this.func_184185_a(ModSounds.HYDRA_REGEN_HEAD, this.func_70599_aP(), this.func_70647_i());
                    if (!this.onlyRegrowOneHeadNotTwo) {
                        this.setHeadCount(this.getHeadCount() + 1);
                    }
                }
                this.onlyRegrowOneHeadNotTwo = false;
                this.regrowHeadCooldown = 0;
            }
        } else {
            this.regrowHeadCooldown = 0;
        }
    }

    public void resetParts() {
        this.clearParts();
        this.headBoxes = new EntityHydraHead[18];
        for (int i = 0; i < this.getHeadCount(); ++i) {
            float maxAngle = 5.0f;
            this.headBoxes[i] = new EntityHydraHead(this, 3.2f, ROTATE[this.getHeadCount() - 1][i] * 1.1f, 1.0f, 0.75f, 1.75f, 1.0f, i, false);
            this.headBoxes[9 + i] = new EntityHydraHead(this, 2.1f, ROTATE[this.getHeadCount() - 1][i] * 1.1f, 1.0f, 0.75f, 0.75f, 1.0f, i, true);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.prevHeadCount != this.getHeadCount()) {
            this.resetParts();
        }
        this.onUpdateParts();
        float partY = 1.0f - this.field_70721_aZ * 0.5f;
        for (int i = 0; i < this.getHeadCount(); ++i) {
            this.headBoxes[i].func_70107_b(this.headBoxes[i].field_70165_t, this.field_70163_u + (double)partY, this.headBoxes[i].field_70161_v);
            this.headBoxes[9 + i].func_70107_b(this.headBoxes[9 + i].field_70165_t, this.field_70163_u + (double)partY, this.headBoxes[9 + i].field_70161_v);
        }
        if (this.getHeadCount() > 1 && !this.func_70027_ad() && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 30 == 0) {
            int level = this.getHeadCount() - 1;
            if (this.getSeveredHead() != -1) {
                --level;
            }
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 30, level, false, false));
        }
        if (this.func_70027_ad()) {
            this.func_184589_d(MobEffects.field_76428_l);
        }
        this.prevHeadCount = this.getHeadCount();
    }

    public void onUpdateParts() {
        for (EntityHydraHead entity : this.headBoxes) {
            if (entity == null) continue;
            entity.func_70071_h_();
        }
    }

    private void clearParts() {
        for (EntityHydraHead entity : this.headBoxes) {
            if (entity == null) continue;
            entity.func_70106_y();
            this.field_70170_p.func_72973_f((Entity)entity);
        }
    }

    public void func_70106_y() {
        this.clearParts();
        super.func_70106_y();
    }

    protected void func_184581_c(DamageSource source) {
        this.speakingProgress[this.field_70146_Z.nextInt((int)this.getHeadCount())] = 1.0f;
        super.func_184581_c(source);
    }

    public void func_70642_aH() {
        this.speakingProgress[this.field_70146_Z.nextInt((int)this.getHeadCount())] = 1.0f;
        super.func_70642_aH();
    }

    public int func_70627_aG() {
        return 100 / this.getHeadCount();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("HeadCount", this.getHeadCount());
        compound.func_74768_a("SeveredHead", this.getSeveredHead());
        for (int i = 0; i < 9; ++i) {
            compound.func_74776_a("HeadDamage" + i, this.headDamageTracker[i]);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setHeadCount(compound.func_74762_e("HeadCount"));
        this.setSeveredHead(compound.func_74762_e("SeveredHead"));
        for (int i = 0; i < 9; ++i) {
            this.headDamageTracker[i] = compound.func_74760_g("HeadDamage" + i);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(HEAD_COUNT, (Object)3);
        this.field_70180_af.func_187214_a(SEVERED_HEAD, (Object)-1);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)IceAndFire.CONFIG.generateHydraChance);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
        this.func_110148_a(EntityLivingBase.SWIM_SPEED).func_111128_a(2.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        int headIndex;
        if (this.lastHitHead > this.getHeadCount()) {
            this.lastHitHead = this.getHeadCount() - 1;
        }
        int n = headIndex = this.lastHitHead;
        this.headDamageTracker[n] = this.headDamageTracker[n] + amount;
        if (this.headDamageTracker[headIndex] > this.headDamageThreshold && (this.getSeveredHead() == -1 || this.getSeveredHead() >= this.getHeadCount())) {
            this.headDamageTracker[headIndex] = 0.0f;
            this.regrowHeadCooldown = 0;
            this.setSeveredHead(headIndex);
            this.func_184185_a(SoundEvents.field_187684_cg, this.func_70599_aP(), this.func_70647_i());
        }
        if (this.func_110143_aJ() <= amount + 5.0f && this.getHeadCount() > 1 && !source.func_76357_e()) {
            amount = 0.0f;
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setVariant(this.field_70146_Z.nextInt(3));
        return livingdata;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    public boolean func_104002_bU() {
        return true;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getHeadCount() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(HEAD_COUNT)), (int)1, (int)9);
    }

    public void setHeadCount(int count) {
        this.field_70180_af.func_187227_b(HEAD_COUNT, (Object)MathHelper.func_76125_a((int)count, (int)1, (int)9));
    }

    public int getSeveredHead() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(SEVERED_HEAD)), (int)-1, (int)9);
    }

    public void setSeveredHead(int count) {
        this.field_70180_af.func_187227_b(SEVERED_HEAD, (Object)MathHelper.func_76125_a((int)count, (int)-1, (int)9));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id >= 40 && id <= 48) {
            int index = id - 40;
            this.isStriking[MathHelper.func_76125_a((int)index, (int)0, (int)8)] = true;
        } else if (id >= 50 && id <= 58) {
            int index = id - 50;
            this.isBreathing[MathHelper.func_76125_a((int)index, (int)0, (int)8)] = true;
        } else if (id >= 60 && id <= 68) {
            int index = id - 60;
            this.isBreathing[MathHelper.func_76125_a((int)index, (int)0, (int)8)] = false;
        } else {
            super.func_70103_a(id);
        }
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() != MobEffects.field_76436_u && super.func_70687_e(potioneffectIn);
    }

    public void onHitHead(float damage, int headIndex) {
        this.lastHitHead = headIndex;
    }

    public void triggerHeadFlags(int index) {
        this.lastHitHead = index;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.HYDRA_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.HYDRA_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.HYDRA_DIE;
    }
}

