/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.BlockBreakExplosion;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.IHumanoid;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.ai.TrollAIFleeSun;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityTroll
extends EntityMob
implements IAnimatedEntity,
IVillagerFear,
IHumanoid {
    public static final Animation ANIMATION_STRIKE_HORIZONTAL = Animation.create((int)20);
    public static final Animation ANIMATION_STRIKE_VERTICAL = Animation.create((int)20);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    public static final Animation ANIMATION_ROAR = Animation.create((int)25);
    public static final ResourceLocation FOREST_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "troll_forest"));
    public static final ResourceLocation FROST_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "troll_frost"));
    public static final ResourceLocation MOUNTAIN_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "troll_mountain"));
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityTroll.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> WEAPON = EntityDataManager.func_187226_a(EntityTroll.class, (DataSerializer)DataSerializers.field_187192_b);
    public float stoneProgress;
    private int animationTick;
    private Animation currentAnimation;
    private boolean avoidSun = true;

    public EntityTroll(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.2f, 3.5f);
    }

    private void setAvoidSun(boolean day) {
        if (day && !this.avoidSun) {
            ((PathNavigateGround)this.func_70661_as()).func_179685_e(true);
            this.avoidSun = true;
        }
        if (!day && this.avoidSun) {
            ((PathNavigateGround)this.func_70661_as()).func_179685_e(false);
            this.avoidSun = false;
        }
    }

    public boolean func_175446_cd() {
        return EntityGorgon.isStoneMob((EntityLivingBase)this) || super.func_175446_cd();
    }

    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos((Entity)this);
        return this.func_70681_au().nextInt(IceAndFire.CONFIG.trollSpawnCheckChance) == 0 && !this.field_70170_p.func_175678_i(pos.func_177984_a()) && super.func_70601_bi();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new TrollAIFleeSun(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 1.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.setAvoidSun(true);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(IceAndFire.CONFIG.trollAttackStrength);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(IceAndFire.CONFIG.trollMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(9.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.func_70681_au().nextBoolean()) {
            this.setAnimation(ANIMATION_STRIKE_VERTICAL);
        } else {
            this.setAnimation(ANIMATION_STRIKE_HORIZONTAL);
        }
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(WEAPON, (Object)0);
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public EnumTroll getType() {
        return EnumTroll.values()[this.getVariant()];
    }

    public void setType(EnumTroll variant) {
        this.setVariant(variant.ordinal());
    }

    private int getWeapon() {
        return (Integer)this.field_70180_af.func_187225_a(WEAPON);
    }

    private void setWeapon(int variant) {
        this.field_70180_af.func_187227_b(WEAPON, (Object)variant);
    }

    public EnumTroll.Weapon getWeaponType() {
        return EnumTroll.Weapon.values()[this.getWeapon()];
    }

    public void setWeaponType(EnumTroll.Weapon variant) {
        this.setWeapon(variant.ordinal());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("Weapon", this.getWeapon());
        compound.func_74776_a("StoneProgress", this.stoneProgress);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setWeapon(compound.func_74762_e("Weapon"));
        this.stoneProgress = compound.func_74760_g("StoneProgress");
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setType(EnumTroll.getBiomeType(this.field_70170_p.func_180494_b(this.func_180425_c())));
        this.setWeaponType(EnumTroll.getWeaponForType(this.getType()));
        return livingdata;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76355_l().contains("arrow")) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        switch (this.getType()) {
            case MOUNTAIN: {
                return MOUNTAIN_LOOT;
            }
            case FROST: {
                return FROST_LOOT;
            }
            case FOREST: {
                return FOREST_LOOT;
            }
        }
        return null;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 15;
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 20 && !this.field_70170_p.field_72995_K && IceAndFire.CONFIG.trollsDropWeapon) {
            if (this.func_70681_au().nextInt(3) == 0) {
                ItemStack weaponStack = new ItemStack(this.getWeaponType().item, 1, 0);
                weaponStack.func_96631_a(this.func_70681_au().nextInt(250), this.func_70681_au(), null);
                this.dropItemAt(weaponStack, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            } else {
                ItemStack brokenDrop = new ItemStack(Blocks.field_150417_aV, this.func_70681_au().nextInt(2) + 1, 0);
                ItemStack brokenDrop2 = new ItemStack(Blocks.field_150417_aV, this.func_70681_au().nextInt(2) + 1, 0);
                if (this.getWeaponType() == EnumTroll.Weapon.AXE) {
                    brokenDrop = new ItemStack(Items.field_151055_y, this.func_70681_au().nextInt(2) + 1, 0);
                    brokenDrop2 = new ItemStack(Blocks.field_150347_e, this.func_70681_au().nextInt(2) + 1, 0);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.COLUMN) {
                    brokenDrop = new ItemStack(Blocks.field_150417_aV, this.func_70681_au().nextInt(2) + 1, 2);
                    brokenDrop2 = new ItemStack(Blocks.field_150417_aV, this.func_70681_au().nextInt(2) + 1, 2);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.COLUMN_FOREST) {
                    brokenDrop = new ItemStack(Blocks.field_150417_aV, this.func_70681_au().nextInt(2) + 1, 1);
                    brokenDrop2 = new ItemStack(Blocks.field_150417_aV, this.func_70681_au().nextInt(2) + 1, 2);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.COLUMN_FROST) {
                    brokenDrop = new ItemStack(Blocks.field_150417_aV, this.func_70681_au().nextInt(2) + 1, 0);
                    brokenDrop2 = new ItemStack(Items.field_151126_ay, this.func_70681_au().nextInt(4) + 1);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.HAMMER) {
                    brokenDrop = new ItemStack(Items.field_151103_aS, this.func_70681_au().nextInt(2) + 1, 0);
                    brokenDrop2 = new ItemStack(Blocks.field_150347_e, this.func_70681_au().nextInt(2) + 1, 0);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.TRUNK) {
                    brokenDrop = new ItemStack(Blocks.field_150364_r, this.func_70681_au().nextInt(2) + 1, 0);
                    brokenDrop2 = new ItemStack(Blocks.field_150364_r, this.func_70681_au().nextInt(2) + 1, 0);
                }
                if (this.getWeaponType() == EnumTroll.Weapon.TRUNK_FROST) {
                    brokenDrop = new ItemStack(Blocks.field_150364_r, this.func_70681_au().nextInt(4) + 1, 1);
                    brokenDrop2 = new ItemStack(Items.field_151126_ay, this.func_70681_au().nextInt(4) + 1);
                }
                this.dropItemAt(brokenDrop, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.dropItemAt(brokenDrop2, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
    }

    @Nullable
    private EntityItem dropItemAt(ItemStack stack, double x, double y, double z) {
        if (stack.func_190916_E() > 0) {
            EntityItem entityitem = new EntityItem(this.field_70170_p, x, y, z, stack);
            entityitem.func_174869_p();
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            return entityitem;
        }
        return null;
    }

    public void func_70636_d() {
        IBlockState state;
        float weaponX;
        boolean stone;
        super.func_70636_d();
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70638_az() instanceof EntityPlayer) {
            this.func_70624_b(null);
        }
        if ((stone = EntityGorgon.isStoneMob((EntityLivingBase)this)) && this.stoneProgress < 20.0f) {
            this.stoneProgress += 2.0f;
        } else if (!stone && this.stoneProgress > 0.0f) {
            this.stoneProgress -= 2.0f;
        }
        if (!stone && this.getAnimation() == NO_ANIMATION && this.func_70638_az() != null && this.func_70681_au().nextInt(100) == 0) {
            this.setAnimation(ANIMATION_ROAR);
        }
        if (this.getAnimation() == ANIMATION_ROAR && this.getAnimationTick() == 5) {
            this.func_184185_a(ModSounds.TROLL_ROAR, 1.0f, 1.0f);
        }
        if (!stone && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 30 == 0) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 30, 1, false, false));
        }
        this.setAvoidSun(this.field_70170_p.func_72935_r());
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            StoneEntityProperties properties;
            BlockPos blockpos;
            float f = this.func_70013_c();
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (f > 0.5f && this.field_70170_p.func_175678_i(blockpos) && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class)) != null && !properties.isStone) {
                properties.isStone = true;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                this.setAnimation(NO_ANIMATION);
                this.func_184185_a(ModSounds.GORGON_TURN_STONE, 1.0f, 1.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
            weaponX = (float)(this.field_70165_t + (double)1.9f * Math.cos((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0));
            float weaponZ = (float)(this.field_70161_v + (double)1.9f * Math.sin((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0));
            float weaponY = (float)(this.field_70163_u + (double)0.2f);
            state = this.field_70170_p.func_180495_p(new BlockPos((double)weaponX, (double)(weaponY - 1.0f), (double)weaponZ));
            for (int i = 0; i < 20; ++i) {
                double motionX = this.func_70681_au().nextGaussian() * 0.07;
                double motionY = this.func_70681_au().nextGaussian() * 0.07;
                double motionZ = this.func_70681_au().nextGaussian() * 0.07;
                if (!state.func_185904_a().func_76220_a() || !this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)(weaponX + (this.func_70681_au().nextFloat() - 0.5f)), (double)(weaponY + (this.func_70681_au().nextFloat() - 0.5f)), (double)(weaponZ + (this.func_70681_au().nextFloat() - 0.5f)), motionX, motionY, motionZ, new int[]{Block.func_149682_b((Block)state.func_177230_c())});
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 4.0 && this.getAnimationTick() == 10 && this.field_70725_aQ <= 0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        }
        if (this.getAnimation() == ANIMATION_STRIKE_HORIZONTAL && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 4.0 && this.getAnimationTick() == 10 && this.field_70725_aQ <= 0) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            float f1 = 0.5f;
            float f2 = this.func_70638_az().field_191988_bg;
            float f3 = 0.6f;
            float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
            if (f4 < 1.0f) {
                f4 = 1.0f;
            }
            f4 = f1 / f4;
            float f5 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f6 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
            float f8 = f3 * f6 + f2 * f5;
            this.func_70638_az().field_70159_w = f5;
            this.func_70638_az().field_70179_y = f6;
            this.func_70638_az().field_70181_x = 0.4f;
        }
        if (this.func_70661_as().func_75500_f() && this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > 3.0 && this.func_70068_e((Entity)this.func_70638_az()) < 30.0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
            this.func_70625_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
            if (this.getAnimation() == NO_ANIMATION && this.field_70146_Z.nextInt(15) == 0) {
                this.setAnimation(ANIMATION_STRIKE_VERTICAL);
            }
            if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
                weaponX = (float)(this.field_70165_t + (double)1.9f * Math.cos((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0));
                float weaponZ = (float)(this.field_70161_v + (double)1.9f * Math.sin((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0));
                float weaponY = (float)(this.field_70163_u + (double)(this.func_70047_e() / 2.0f));
                state = this.field_70170_p.func_180495_p(new BlockPos((double)weaponX, (double)weaponY, (double)weaponZ));
                BlockBreakExplosion explosion = new BlockBreakExplosion(this.field_70170_p, (EntityCreature)this, weaponX, weaponY, weaponZ, 1.0f + this.func_70681_au().nextFloat());
                if (!MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((EntityLiving)this, weaponX, weaponY, weaponZ))) {
                    explosion.func_77278_a();
                    explosion.func_77279_a(true);
                }
                this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_STRIKE_VERTICAL && this.getAnimationTick() == 10) {
            this.func_184185_a(SoundEvents.field_187730_dW, 2.5f, 0.5f);
        }
        if (this.getAnimation() == ANIMATION_STRIKE_HORIZONTAL && this.getAnimationTick() == 10) {
            this.func_184185_a(SoundEvents.field_187730_dW, 2.5f, 0.5f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public void func_70642_aH() {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_70642_aH();
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.TROLL_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.TROLL_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.TROLL_DIE;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_STRIKE_HORIZONTAL, ANIMATION_STRIKE_VERTICAL, ANIMATION_SPEAK, ANIMATION_ROAR};
    }
}

