/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.core.ModItems;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;

public class CyclopsAITargetSheepPlayers<T extends EntityLivingBase>
extends EntityAITarget {
    protected final Class<T> targetClass;
    protected final Sorter sorter;
    protected final Predicate<? super T> targetEntitySelector;
    private final int targetChance;
    protected T targetEntity;

    public CyclopsAITargetSheepPlayers(EntityCreature creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, true);
    }

    public CyclopsAITargetSheepPlayers(EntityCreature creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null);
    }

    public CyclopsAITargetSheepPlayers(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, final @Nullable Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.sorter = new Sorter((Entity)creature);
        this.func_75248_a(1);
        this.targetEntitySelector = new Predicate<T>(){

            public boolean apply(@Nullable T p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                if (targetSelector != null && !targetSelector.apply(p_apply_1_)) {
                    return false;
                }
                return EntitySelectors.field_180132_d.apply(p_apply_1_) && CyclopsAITargetSheepPlayers.this.func_75296_a(p_apply_1_, false);
            }
        };
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.targetClass != EntityPlayer.class && this.targetClass != EntityPlayerMP.class) {
            List list = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
            if (list.isEmpty()) {
                return false;
            }
            Collections.sort(list, this.sorter);
            this.targetEntity = (EntityLivingBase)list.get(0);
            return true;
        }
        this.targetEntity = this.field_75299_d.field_70170_p.func_184150_a(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u + (double)this.field_75299_d.func_70047_e(), this.field_75299_d.field_70161_v, this.func_111175_f(), this.func_111175_f(), (Function)new Function<EntityPlayer, Double>(){

            @Nullable
            public Double apply(@Nullable EntityPlayer player) {
                ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
                ItemStack chestplate = player.func_184582_a(EntityEquipmentSlot.CHEST);
                ItemStack leggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
                ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
                double subHelm = helmet != null && helmet.func_77973_b() != null && helmet.func_77973_b() == ModItems.sheep_helmet ? 0.2 : 0.0;
                double subChest = chestplate != null && chestplate.func_77973_b() != null && chestplate.func_77973_b() == ModItems.sheep_chestplate ? 0.2 : 0.0;
                double subLegs = leggings != null && leggings.func_77973_b() != null && leggings.func_77973_b() == ModItems.sheep_leggings ? 0.2 : 0.0;
                double subBoots = boots != null && boots.func_77973_b() != null && boots.func_77973_b() == ModItems.sheep_boots ? 0.2 : 0.0;
                double subSneaking = player.func_70093_af() ? 0.2 : 0.0;
                return 1.0 - subHelm - subChest - subLegs - subBoots - subSneaking;
            }
        }, this.targetEntitySelector);
        return this.targetEntity != null;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        public Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.entity.func_70068_e(p_compare_1_);
            if (d0 < (d1 = this.entity.func_70068_e(p_compare_2_))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }
}

