/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.tile;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DreadSpawnerBaseLogic
extends MobSpawnerBaseLogic {
    private final List<WeightedSpawnerEntity> potentialSpawns = Lists.newArrayList();
    private int spawnDelay = 20;
    private WeightedSpawnerEntity spawnData = new WeightedSpawnerEntity();
    private double mobRotation;
    private double prevMobRotation;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    private Entity cachedEntity;
    private int maxNearbyEntities = 6;
    private int activatingRangeFromPlayer = 16;
    private int spawnRange = 4;

    @Nullable
    private ResourceLocation getEntityId() {
        String s = this.spawnData.func_185277_b().func_74779_i("id");
        return StringUtils.func_151246_b((String)s) ? null : new ResourceLocation(s);
    }

    public void func_190894_a(@Nullable ResourceLocation id) {
        if (id != null) {
            this.spawnData.func_185277_b().func_74778_a("id", id.toString());
        }
    }

    private boolean isActivated() {
        BlockPos blockpos = this.func_177221_b();
        return this.func_98271_a().func_175636_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)this.activatingRangeFromPlayer);
    }

    public void func_98278_g() {
        if (!this.isActivated()) {
            this.prevMobRotation = this.mobRotation;
        } else {
            BlockPos blockpos = this.func_177221_b();
            if (this.func_98271_a().field_72995_K) {
                double d3 = (float)blockpos.func_177958_n() + this.func_98271_a().field_73012_v.nextFloat();
                double d4 = (float)blockpos.func_177956_o() + this.func_98271_a().field_73012_v.nextFloat();
                double d5 = (float)blockpos.func_177952_p() + this.func_98271_a().field_73012_v.nextFloat();
                this.func_98271_a().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d3, d4, d5, 0.0, 0.0, 0.0, new int[0]);
                IceAndFire.PROXY.spawnParticle("dread_torch", d3, d4, d5, 0.0, 0.0, 0.0);
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                }
                this.prevMobRotation = this.mobRotation;
                this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
            } else {
                if (this.spawnDelay == -1) {
                    this.resetTimer();
                }
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                    return;
                }
                boolean flag = false;
                for (int i = 0; i < this.spawnCount; ++i) {
                    double d2;
                    double d1;
                    int j;
                    double d0;
                    NBTTagCompound nbttagcompound = this.spawnData.func_185277_b();
                    NBTTagList nbttaglist = nbttagcompound.func_150295_c("Pos", 6);
                    World world = this.func_98271_a();
                    Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)nbttagcompound, (World)world, (double)(d0 = (j = nbttaglist.func_74745_c()) >= 1 ? nbttaglist.func_150309_d(0) : (double)blockpos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5), (double)(d1 = j >= 2 ? nbttaglist.func_150309_d(1) : (double)(blockpos.func_177956_o() + world.field_73012_v.nextInt(3) - 1)), (double)(d2 = j >= 3 ? nbttaglist.func_150309_d(2) : (double)blockpos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * (double)this.spawnRange + 0.5), (boolean)false);
                    if (entity == null) {
                        return;
                    }
                    int k = world.func_72872_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.spawnRange)).size();
                    if (k >= this.maxNearbyEntities) {
                        this.resetTimer();
                        return;
                    }
                    EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                    entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entityliving != null && !ForgeEventFactory.canEntitySpawnSpawner((EntityLiving)entityliving, (World)this.func_98271_a(), (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v), (MobSpawnerBaseLogic)this)) continue;
                    if (this.spawnData.func_185277_b().func_186856_d() == 1 && this.spawnData.func_185277_b().func_150297_b("id", 8) && entity instanceof EntityLiving && !ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)this.func_98271_a(), (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v), (MobSpawnerBaseLogic)this)) {
                        ((EntityLiving)entity).func_180482_a(world.func_175649_E(new BlockPos(entity)), null);
                    }
                    AnvilChunkLoader.func_186052_a((Entity)entity, (World)world);
                    world.func_175718_b(2004, blockpos, 0);
                    if (entityliving != null) {
                        entityliving.func_70656_aK();
                    }
                    flag = true;
                }
                if (flag) {
                    this.resetTimer();
                }
            }
        }
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.func_98271_a().field_73012_v.nextInt(i);
        }
        if (!this.potentialSpawns.isEmpty()) {
            this.func_184993_a((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.func_98271_a().field_73012_v, this.potentialSpawns));
        }
        this.func_98267_a(1);
    }

    public void func_98270_a(NBTTagCompound nbt) {
        this.spawnDelay = nbt.func_74765_d("Delay");
        this.potentialSpawns.clear();
        if (nbt.func_150297_b("SpawnPotentials", 9)) {
            NBTTagList nbttaglist = nbt.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.potentialSpawns.add(new WeightedSpawnerEntity(nbttaglist.func_150305_b(i)));
            }
        }
        if (nbt.func_150297_b("SpawnData", 10)) {
            this.func_184993_a(new WeightedSpawnerEntity(1, nbt.func_74775_l("SpawnData")));
        } else if (!this.potentialSpawns.isEmpty()) {
            this.func_184993_a((WeightedSpawnerEntity)WeightedRandom.func_76271_a((Random)this.func_98271_a().field_73012_v, this.potentialSpawns));
        }
        if (nbt.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = nbt.func_74765_d("MaxSpawnDelay");
            this.spawnCount = nbt.func_74765_d("SpawnCount");
        }
        if (nbt.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.func_74765_d("MaxNearbyEntities");
            this.activatingRangeFromPlayer = nbt.func_74765_d("RequiredPlayerRange");
        }
        if (nbt.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = nbt.func_74765_d("SpawnRange");
        }
        if (this.func_98271_a() != null) {
            this.cachedEntity = null;
        }
    }

    public NBTTagCompound func_189530_b(NBTTagCompound p_189530_1_) {
        ResourceLocation resourcelocation = this.getEntityId();
        if (resourcelocation == null) {
            return p_189530_1_;
        }
        p_189530_1_.func_74777_a("Delay", (short)this.spawnDelay);
        p_189530_1_.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        p_189530_1_.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        p_189530_1_.func_74777_a("SpawnCount", (short)this.spawnCount);
        p_189530_1_.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        p_189530_1_.func_74777_a("RequiredPlayerRange", (short)this.activatingRangeFromPlayer);
        p_189530_1_.func_74777_a("SpawnRange", (short)this.spawnRange);
        p_189530_1_.func_74782_a("SpawnData", (NBTBase)this.spawnData.func_185277_b().func_74737_b());
        NBTTagList nbttaglist = new NBTTagList();
        if (this.potentialSpawns.isEmpty()) {
            nbttaglist.func_74742_a((NBTBase)this.spawnData.func_185278_a());
        } else {
            for (WeightedSpawnerEntity weightedspawnerentity : this.potentialSpawns) {
                nbttaglist.func_74742_a((NBTBase)weightedspawnerentity.func_185278_a());
            }
        }
        p_189530_1_.func_74782_a("SpawnPotentials", (NBTBase)nbttaglist);
        return p_189530_1_;
    }

    public boolean func_98268_b(int delay) {
        if (delay == 1 && this.func_98271_a().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity func_184994_d() {
        if (this.cachedEntity == null) {
            this.cachedEntity = AnvilChunkLoader.func_186051_a((NBTTagCompound)this.spawnData.func_185277_b(), (World)this.func_98271_a(), (boolean)false);
            if (this.spawnData.func_185277_b().func_186856_d() == 1 && this.spawnData.func_185277_b().func_150297_b("id", 8) && this.cachedEntity instanceof EntityLiving) {
                ((EntityLiving)this.cachedEntity).func_180482_a(this.func_98271_a().func_175649_E(new BlockPos(this.cachedEntity)), null);
            }
        }
        return this.cachedEntity;
    }

    public void func_184993_a(WeightedSpawnerEntity p_184993_1_) {
        this.spawnData = p_184993_1_;
    }

    public abstract void func_98267_a(int var1);

    public abstract World func_98271_a();

    public abstract BlockPos func_177221_b();

    @SideOnly(value=Side.CLIENT)
    public double func_177222_d() {
        return this.mobRotation;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_177223_e() {
        return this.prevMobRotation;
    }
}

