/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.MiscEntityProperties;
import java.util.List;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDeathwormGauntlet
extends Item {
    public ItemDeathwormGauntlet(String color) {
        this.func_77637_a(IceAndFire.TAB_ITEMS);
        this.func_77655_b("iceandfire.deathworm_gauntlet_" + color);
        this.field_77777_bU = 1;
        this.func_77656_e(500);
        this.setRegistryName("iceandfire", "deathworm_gauntlet_" + color);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        MiscEntityProperties properties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)player, MiscEntityProperties.class);
        if (stack.func_77978_p() != null) {
            if (properties.deathwormReceded || properties.deathwormLaunched) {
                return;
            }
            if (player instanceof EntityPlayer) {
                if (stack.func_77978_p().func_74762_e("HolderID") != player.func_145782_y()) {
                    stack.func_77978_p().func_74768_a("HolderID", player.func_145782_y());
                }
                if (((EntityPlayer)player).func_184811_cZ().func_185143_a((Item)this, 0.0f) == 0.0f) {
                    ((EntityPlayer)player).func_184811_cZ().func_185145_a((Item)this, 10);
                    player.func_184185_a(ModSounds.DEATHWORM_ATTACK, 1.0f, 1.0f);
                    properties.deathwormReceded = false;
                    properties.deathwormLaunched = true;
                }
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        MiscEntityProperties properties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entityLiving, MiscEntityProperties.class);
        if (properties != null && properties.specialWeaponDmg > 0) {
            stack.func_77972_a(properties.specialWeaponDmg, entityLiving);
            properties.specialWeaponDmg = 0;
        }
        if (stack.func_77978_p().func_74762_e("HolderID") != -1) {
            stack.func_77978_p().func_74768_a("HolderID", -1);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.func_77969_a(newStack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int unused, boolean unused2) {
        boolean hitMob = false;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        } else {
            MiscEntityProperties properties = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(entity, MiscEntityProperties.class);
            if (properties != null) {
                if (properties.deathwormReceded) {
                    if (properties.deathwormLungeTicks > 0) {
                        properties.deathwormLungeTicks -= 4;
                    }
                    if (properties.deathwormLungeTicks <= 0) {
                        properties.deathwormLungeTicks = 0;
                        properties.deathwormReceded = false;
                        properties.deathwormLaunched = false;
                    }
                } else if (properties.deathwormLaunched) {
                    properties.deathwormLungeTicks = 4 + properties.deathwormLungeTicks;
                    if (properties.deathwormLungeTicks > 20 && !properties.deathwormReceded) {
                        properties.deathwormReceded = true;
                    }
                }
                if (properties.prevDeathwormLungeTicks == 20 && entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
                    double range = 5.0;
                    for (EntityLiving entityliving : world.func_72872_a(EntityLiving.class, new AxisAlignedBB(player.field_70165_t - range, player.field_70163_u - range, player.field_70161_v - range, player.field_70165_t + range, player.field_70163_u + range, player.field_70161_v + range))) {
                        Vec3d vec3d1 = new Vec3d(entityliving.field_70165_t - player.field_70165_t, entityliving.field_70163_u - player.field_70163_u, entityliving.field_70161_v - player.field_70161_v);
                        double d0 = vec3d1.func_72433_c();
                        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
                        boolean canSee = d1 > 1.0 - 0.5 / d0 && player.func_70685_l((Entity)entityliving);
                        if (!canSee) continue;
                        ++properties.specialWeaponDmg;
                        entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entity)), 3.0f);
                        entityliving.func_70653_a((Entity)entityliving, 0.5f, entityliving.field_70165_t - player.field_70165_t, entityliving.field_70161_v - player.field_70161_v);
                    }
                }
                properties.prevDeathwormLungeTicks = properties.deathwormLungeTicks;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"item.iceandfire.legendary_weapon.desc", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.iceandfire.deathworm_gauntlet.desc_0", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.iceandfire.deathworm_gauntlet.desc_1", (Object[])new Object[0]));
    }
}

