/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.structures;

import com.github.alexthe666.iceandfire.structures.processor.DreadRuinProcessor;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WorldGenDreadRuin
extends WorldGenerator {
    private static final ResourceLocation STRUCTURE_0 = new ResourceLocation("iceandfire", "dread_ruin_0");
    private static final ResourceLocation STRUCTURE_1 = new ResourceLocation("iceandfire", "dread_ruin_1");
    private static final ResourceLocation STRUCTURE_2 = new ResourceLocation("iceandfire", "dread_ruin_2");
    private static final ResourceLocation STRUCTURE_3 = new ResourceLocation("iceandfire", "dread_ruin_3");
    private static final ResourceLocation STRUCTURE_4 = new ResourceLocation("iceandfire", "dread_ruin_4");
    private static final ResourceLocation STRUCTURE_5 = new ResourceLocation("iceandfire", "dread_ruin_5");
    private static final ResourceLocation STRUCTURE_6 = new ResourceLocation("iceandfire", "dread_ruin_6");
    private static final ResourceLocation STRUCTURE_7 = new ResourceLocation("iceandfire", "dread_ruin_7");
    private static final ResourceLocation STRUCTURE_8 = new ResourceLocation("iceandfire", "dread_ruin_8");
    private static final ResourceLocation STRUCTURE_9 = new ResourceLocation("iceandfire", "dread_ruin_9");
    private static final ResourceLocation STRUCTURE_10 = new ResourceLocation("iceandfire", "dread_ruin_10");
    private static final ResourceLocation STRUCTURE_11 = new ResourceLocation("iceandfire", "dread_ruin_11");
    private static final ResourceLocation STRUCTURE_12 = new ResourceLocation("iceandfire", "dread_ruin_12");

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        ResourceLocation structure = this.getRandomStructure(rand);
        EnumFacing facing = EnumFacing.field_176754_o[rand.nextInt(3)];
        MinecraftServer server = worldIn.func_73046_m();
        TemplateManager templateManager = worldIn.func_72860_G().func_186340_h();
        PlacementSettings settings = new PlacementSettings().func_186220_a(WorldGenDreadRuin.getRotationFromFacing(facing)).func_186225_a(Blocks.field_150350_a);
        Template template = templateManager.func_186237_a(server, structure);
        Biome biome = worldIn.func_180494_b(position);
        BlockPos genPos = position.func_177967_a(facing, template.func_186259_a().func_177952_p() / 2).func_177967_a(facing.func_176735_f(), template.func_186259_a().func_177958_n() / 2);
        template.func_189960_a(worldIn, genPos, (ITemplateProcessor)new DreadRuinProcessor(position, settings, biome), settings, 2);
        return true;
    }

    public static Rotation getRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    private ResourceLocation getRandomStructure(Random rand) {
        switch (rand.nextInt(11)) {
            case 0: {
                return STRUCTURE_0;
            }
            case 1: {
                return STRUCTURE_1;
            }
            case 2: {
                return STRUCTURE_2;
            }
            case 3: {
                return STRUCTURE_3;
            }
            case 4: {
                return STRUCTURE_4;
            }
            case 5: {
                return STRUCTURE_5;
            }
            case 6: {
                return STRUCTURE_6;
            }
            case 7: {
                return STRUCTURE_7;
            }
            case 8: {
                return STRUCTURE_8;
            }
            case 9: {
                return STRUCTURE_9;
            }
            case 10: {
                return STRUCTURE_10;
            }
            case 11: {
                return STRUCTURE_11;
            }
            case 12: {
                return STRUCTURE_12;
            }
        }
        return STRUCTURE_0;
    }
}

