/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.structures;

import com.github.alexthe666.iceandfire.block.BlockGoldPile;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.MyrmexHive;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBone;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGenMyrmexDecoration {
    public static final ResourceLocation MYRMEX_GOLD_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_loot_chest"));
    public static final ResourceLocation DESERT_MYRMEX_FOOD_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_desert_food_chest"));
    public static final ResourceLocation JUNGLE_MYRMEX_FOOD_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_jungle_food_chest"));
    public static final ResourceLocation MYRMEX_TRASH_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "myrmex_trash_chest"));

    public static void generateSkeleton(World worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, blockpos.func_177977_b(), EnumFacing.UP)) {
            EnumFacing direction = EnumFacing.field_176754_o[new Random().nextInt(3)];
            EnumFacing.Axis oppositeAxis = direction.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
            int maxRibHeight = rand.nextInt(2);
            for (int spine = 0; spine < 5 + rand.nextInt(2) * 2; ++spine) {
                BlockPos segment = blockpos.func_177967_a(direction, spine);
                if (origin.func_177951_i((Vec3i)segment) <= (double)(radius * radius)) {
                    worldIn.func_175656_a(segment, Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)direction.func_176740_k()));
                }
                if (spine % 2 == 0) continue;
                BlockPos rightRib = segment.func_177972_a(direction.func_176735_f());
                BlockPos leftRib = segment.func_177972_a(direction.func_176746_e());
                if (origin.func_177951_i((Vec3i)rightRib) <= (double)(radius * radius)) {
                    worldIn.func_175656_a(rightRib, Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)oppositeAxis));
                }
                if (origin.func_177951_i((Vec3i)leftRib) <= (double)(radius * radius)) {
                    worldIn.func_175656_a(leftRib, Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)oppositeAxis));
                }
                for (int ribHeight = 1; ribHeight < maxRibHeight + 2; ++ribHeight) {
                    if (origin.func_177951_i((Vec3i)rightRib.func_177981_b(ribHeight).func_177972_a(direction.func_176735_f())) <= (double)(radius * radius)) {
                        worldIn.func_175656_a(rightRib.func_177981_b(ribHeight).func_177972_a(direction.func_176735_f()), Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)EnumFacing.Axis.Y));
                    }
                    if (!(origin.func_177951_i((Vec3i)leftRib.func_177981_b(ribHeight).func_177972_a(direction.func_176746_e())) <= (double)(radius * radius))) continue;
                    worldIn.func_175656_a(leftRib.func_177981_b(ribHeight).func_177972_a(direction.func_176746_e()), Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)EnumFacing.Axis.Y));
                }
                if (origin.func_177951_i((Vec3i)rightRib.func_177981_b(maxRibHeight + 2)) <= (double)(radius * radius)) {
                    worldIn.func_175656_a(rightRib.func_177981_b(maxRibHeight + 2), Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)oppositeAxis));
                }
                if (!(origin.func_177951_i((Vec3i)leftRib.func_177981_b(maxRibHeight + 2)) <= (double)(radius * radius))) continue;
                worldIn.func_175656_a(leftRib.func_177981_b(maxRibHeight + 2), Blocks.field_189880_di.func_176223_P().func_177226_a((IProperty)BlockBone.field_176298_M, (Comparable)oppositeAxis));
            }
        }
    }

    public static void generateLeaves(World worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, blockpos.func_177977_b(), EnumFacing.UP)) {
            IBlockState leaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
            for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)worldIn.func_180494_b(blockpos))) {
                if (type == BiomeDictionary.Type.SANDY || type == BiomeDictionary.Type.SAVANNA || type == BiomeDictionary.Type.WASTELAND) {
                    leaf = Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.ACACIA).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
                    break;
                }
                if (type == BiomeDictionary.Type.JUNGLE) {
                    leaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
                    break;
                }
                if (type != BiomeDictionary.Type.CONIFEROUS) continue;
                leaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
                break;
            }
            int i1 = 0;
            for (int i = 0; i1 >= 0 && i < 3; ++i) {
                int j = i1 + rand.nextInt(2);
                int k = i1 + rand.nextInt(2);
                int l = i1 + rand.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)blockpos.func_177982_a(-j, -k, -l), (BlockPos)blockpos.func_177982_a(j, k, l))) {
                    if (!(pos.func_177951_i((Vec3i)blockpos) <= (double)(f * f)) || !worldIn.func_175623_d(pos)) continue;
                    worldIn.func_180501_a(pos, leaf, 4);
                }
                blockpos = blockpos.func_177982_a(-(i1 + 1) + rand.nextInt(2 + i1 * 2), 0 - rand.nextInt(2), -(i1 + 1) + rand.nextInt(2 + i1 * 2));
            }
        }
    }

    public static void generatePumpkins(World worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, blockpos.func_177977_b(), EnumFacing.UP)) {
            worldIn.func_175656_a(blockpos, BiomeDictionary.hasType((Biome)worldIn.func_180494_b(blockpos), (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) ? Blocks.field_150440_ba.func_176223_P() : Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)rand.nextInt(3))));
        }
    }

    public static void generateCocoon(World worldIn, BlockPos blockpos, Random rand, boolean jungle, ResourceLocation lootTable) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, blockpos.func_177977_b(), EnumFacing.UP)) {
            worldIn.func_180501_a(blockpos, jungle ? ModBlocks.jungle_myrmex_cocoon.func_176223_P() : ModBlocks.desert_myrmex_cocoon.func_176223_P(), 3);
            if (worldIn.func_175625_s(blockpos) != null && worldIn.func_175625_s(blockpos) instanceof TileEntityLockableLoot && !worldIn.func_175625_s(blockpos).func_145837_r()) {
                TileEntity tileentity1 = worldIn.func_175625_s(blockpos);
                ((TileEntityLockableLoot)tileentity1).func_189404_a(lootTable, rand.nextLong());
            }
        }
    }

    public static void generateMushrooms(World worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, blockpos.func_177977_b(), EnumFacing.UP)) {
            worldIn.func_175656_a(blockpos, rand.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P());
        }
    }

    public static void generateGold(World worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        IBlockState gold;
        IBlockState iBlockState = gold = rand.nextBoolean() ? ModBlocks.goldPile.func_176223_P() : ModBlocks.silverPile.func_176223_P();
        if (worldIn.func_180495_p(blockpos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, blockpos.func_177977_b(), EnumFacing.UP)) {
            worldIn.func_180501_a(blockpos, gold.func_177226_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 3);
            worldIn.func_180501_a(MyrmexHive.getGroundedPos(worldIn, blockpos.func_177978_c()), gold.func_177226_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            worldIn.func_180501_a(MyrmexHive.getGroundedPos(worldIn, blockpos.func_177968_d()), gold.func_177226_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            worldIn.func_180501_a(MyrmexHive.getGroundedPos(worldIn, blockpos.func_177976_e()), gold.func_177226_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            worldIn.func_180501_a(MyrmexHive.getGroundedPos(worldIn, blockpos.func_177974_f()), gold.func_177226_a((IProperty)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + new Random().nextInt(7))), 3);
            if (rand.nextInt(3) == 0) {
                TileEntity tileentity1;
                worldIn.func_180501_a(blockpos.func_177984_a(), Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.field_176754_o[new Random().nextInt(3)]), 2);
                if (worldIn.func_180495_p(blockpos.func_177984_a()).func_177230_c() instanceof BlockChest && (tileentity1 = worldIn.func_175625_s(blockpos.func_177984_a())) instanceof TileEntityChest && !tileentity1.func_145837_r()) {
                    ((TileEntityChest)tileentity1).func_189404_a(MYRMEX_GOLD_CHEST, rand.nextLong());
                }
            }
        }
    }

    public static void generateTrashHeap(World worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        if (worldIn.func_180495_p(blockpos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, blockpos.func_177977_b(), EnumFacing.UP)) {
            Block blob = Blocks.field_150346_d;
            switch (rand.nextInt(3)) {
                case 0: {
                    blob = Blocks.field_150346_d;
                    break;
                }
                case 1: {
                    blob = Blocks.field_150354_m;
                    break;
                }
                case 2: {
                    blob = Blocks.field_150347_e;
                    break;
                }
                case 3: {
                    blob = Blocks.field_150351_n;
                }
            }
            int i1 = 0;
            for (int i = 0; i1 >= 0 && i < 3; ++i) {
                int j = i1 + rand.nextInt(2);
                int k = i1 + rand.nextInt(2);
                int l = i1 + rand.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)blockpos.func_177982_a(-j, -k, -l), (BlockPos)blockpos.func_177982_a(j, k, l))) {
                    if (!(pos.func_177951_i((Vec3i)blockpos) <= (double)(f * f))) continue;
                    worldIn.func_180501_a(pos, blob.func_176223_P(), 4);
                }
                blockpos = blockpos.func_177982_a(-(i1 + 1) + rand.nextInt(2 + i1 * 2), 0 - rand.nextInt(2), -(i1 + 1) + rand.nextInt(2 + i1 * 2));
            }
        }
    }

    public static void generateTrashOre(World worldIn, BlockPos blockpos, BlockPos origin, int radius, Random rand) {
        Block current = worldIn.func_180495_p(blockpos).func_177230_c();
        if (origin.func_177951_i((Vec3i)blockpos) <= (double)(radius * radius) && (current == Blocks.field_150346_d || current == Blocks.field_150354_m || current == Blocks.field_150347_e || current == Blocks.field_150351_n)) {
            Block ore = Blocks.field_150450_ax;
            if (rand.nextInt(3) == 0) {
                ore = rand.nextBoolean() ? Blocks.field_150352_o : ModBlocks.silverOre;
            } else if (rand.nextInt(3) == 0) {
                ore = Blocks.field_150482_ag;
            } else if (rand.nextInt(2) == 0) {
                ore = rand.nextBoolean() ? Blocks.field_150412_bA : ModBlocks.sapphireOre;
            }
            worldIn.func_175656_a(blockpos, ore.func_176223_P());
        }
    }
}

