/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class DreadWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "iceandfire_dread";
    private final List<BlockPos> allOverworldPortalLocations = Lists.newArrayList();
    private final List<BlockPos> activeOverworldPortalLocations = Lists.newArrayList();
    private World world;
    private int tickCounter;

    public DreadWorldData(String name) {
        super(name);
    }

    public DreadWorldData(World world) {
        super(IDENTIFIER);
        this.world = world;
        this.func_76185_a();
    }

    public static DreadWorldData get(World world) {
        MapStorage storage = world.getPerWorldStorage();
        DreadWorldData instance = (DreadWorldData)storage.func_75742_a(DreadWorldData.class, IDENTIFIER);
        if (instance == null) {
            instance = new DreadWorldData(world);
            storage.func_75745_a(IDENTIFIER, (WorldSavedData)instance);
        }
        instance.func_76185_a();
        return instance;
    }

    public void setWorldsForAll(World worldIn) {
        this.world = worldIn;
    }

    public void tick() {
        ++this.tickCounter;
    }

    public void removePortalAtPos(BlockPos pos) {
        Iterator<BlockPos> iterator = this.allOverworldPortalLocations.iterator();
        while (iterator.hasNext()) {
            BlockPos portalPos = iterator.next();
            if (!portalPos.equals((Object)pos)) continue;
            iterator.remove();
            this.func_76185_a();
        }
        for (BlockPos portalPos : this.activeOverworldPortalLocations) {
            if (!portalPos.equals((Object)pos)) continue;
            iterator.remove();
            this.func_76185_a();
        }
    }

    public void addPortalLocation(BlockPos pos) {
        if (!this.allOverworldPortalLocations.contains(pos)) {
            this.allOverworldPortalLocations.add(pos);
        }
    }

    public void activatePortalAt(BlockPos pos) {
        if (!this.allOverworldPortalLocations.contains(pos)) {
            this.allOverworldPortalLocations.add(pos);
        }
        if (!this.activeOverworldPortalLocations.contains(pos)) {
            this.activeOverworldPortalLocations.add(pos);
        }
    }

    public List<BlockPos> getAllActivePortals() {
        return this.allOverworldPortalLocations;
    }

    public List<BlockPos> getAllPortals() {
        return this.activeOverworldPortalLocations;
    }

    public BlockPos getExitPortalFromDreadlands(BlockPos queenLoc) {
        BlockPos pos = null;
        double d0 = 3.4028234663852886E38;
        for (BlockPos activePosLoc : this.activeOverworldPortalLocations) {
            double d1 = activePosLoc.func_177951_i((Vec3i)queenLoc);
            if (!(d1 < d0)) continue;
            pos = activePosLoc;
            d0 = d1;
        }
        return pos;
    }

    public void debug() {
        for (BlockPos pos : this.activeOverworldPortalLocations) {
            IceAndFire.logger.debug((Object)pos);
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.tickCounter = nbt.func_74762_e("Tick");
        NBTTagList nbttaglistAll = nbt.func_150295_c("AllPortals", 10);
        for (int i = 0; i < nbttaglistAll.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglistAll.func_150305_b(i);
            BlockPos pos = new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z"));
            this.allOverworldPortalLocations.add(pos);
        }
        NBTTagList nbttaglistActive = nbt.func_150295_c("ActivePortals", 10);
        for (int i = 0; i < nbttaglistActive.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglistActive.func_150305_b(i);
            BlockPos pos = new BlockPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Y"), nbttagcompound.func_74762_e("Z"));
            this.activeOverworldPortalLocations.add(pos);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("Tick", this.tickCounter);
        NBTTagList nbttaglistAll = new NBTTagList();
        for (BlockPos pos : this.allOverworldPortalLocations) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("X", pos.func_177958_n());
            nbttagcompound.func_74768_a("Y", pos.func_177956_o());
            nbttagcompound.func_74768_a("Z", pos.func_177952_p());
            nbttaglistAll.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("AllPortals", (NBTBase)nbttaglistAll);
        NBTTagList nbttaglistActive = new NBTTagList();
        for (BlockPos pos : this.activeOverworldPortalLocations) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("X", pos.func_177958_n());
            nbttagcompound.func_74768_a("Y", pos.func_177956_o());
            nbttagcompound.func_74768_a("Z", pos.func_177952_p());
            nbttaglistActive.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("ActivePortals", (NBTBase)nbttaglistActive);
        return compound;
    }
}

