/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.incubation.core.registry;

import com.markus1002.incubation.common.world.gen.feature.ChickenNestFeature;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModFeatures {
    public static final Feature<NoFeatureConfig> CHICKEN_NEST = new ChickenNestFeature(NoFeatureConfig::func_214639_a);

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        ModFeatures.registerFeature(CHICKEN_NEST, "chicken_nest");
    }

    private static void registerFeature(Feature<?> feature, String name) {
        feature.setRegistryName(name);
        ForgeRegistries.FEATURES.register(feature);
    }

    public static void setupFeatures() {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (!BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST) || !ModFeatures.doesCreatureSpawnInBiome(EntityType.field_200795_i, EntityClassification.CREATURE, biome)) continue;
            ModFeatures.addFeatureToBiome(biome, GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a(CHICKEN_NEST, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(32)));
        }
    }

    private static boolean doesCreatureSpawnInBiome(EntityType<?> entityType, EntityClassification classification, Biome biome) {
        for (Biome.SpawnListEntry entry : biome.func_76747_a(classification)) {
            if (entry.field_200702_b != entityType) continue;
            return true;
        }
        return false;
    }

    private static void addFeatureToBiome(Biome biome, GenerationStage.Decoration decorationStage, ConfiguredFeature<?> configuredFeature) {
        if (!biome.func_203607_a(decorationStage).contains(configuredFeature)) {
            biome.func_203611_a(decorationStage, configuredFeature);
        }
    }
}

