/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.config;

import net.minecraftforge.common.config.Config;

@Config(modid="inventoryhud", type=Config.Type.INSTANCE, name="inventoryhud", category="")
public class InvConfig {
    @Config.Name(value="Inventory HUD config")
    public static InvHUD inv = new InvHUD();
    @Config.Name(value="Potion HUD config")
    public static PotHUD pot = new PotHUD();
    @Config.Name(value="ArmorStatus HUD config")
    public static ArmHUD arm = new ArmHUD();

    public static enum ArmorView {
        PERCENTAGE,
        DAMAGE,
        DAMAGE_LEFT;

    }

    public static enum ArmorType {
        ARMOR,
        FULL,
        FULL_AND_INV;

    }

    public static enum PotOrientation {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static enum Orientation {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        MIDDLE;

    }

    public static class ArmHUD {
        @Config.Name(value="ArmorStatusHUD ON/OFF")
        public boolean ArmorDamage = false;
        @Config.Name(value="ArmorStatusHUD orientation")
        @Config.Comment(value={"What orientation should ArmorStatusHUD be. If it is 'MIDDLE' you can't change position, it always will render around hotbar"})
        public Orientation armOr = Orientation.MIDDLE;
        @Config.Name(value="ArmorStatusHUD X position")
        @Config.Comment(value={"Horizontal position of ArmorStatusHUD"})
        @Config.RangeInt(min=0)
        public int xArmPos = 0;
        @Config.Name(value="ArmorStatusHUD Y position")
        @Config.Comment(value={"Vertical position of ArmorStatusHUD"})
        @Config.RangeInt(min=0)
        public int yArmPos = 0;
        @Config.Name(value="Hide ArmorStatusHUD above")
        @Config.Comment(value={"It will hide armor icon if durability above this value, set it to 100 if you don't want to hide icon"})
        @Config.RangeInt(min=0, max=100)
        public int armAbove = 100;
        @Config.Name(value="ArmorStatusHUD type")
        @Config.Comment(value={"What type of ArmorStatusHUD you want to use? Only armor, armor and hands, or armor, hands and inventory empty slot counter"})
        public ArmorType armType = ArmorType.FULL_AND_INV;
        @Config.Name(value="ArmorStatusHUD durability view")
        @Config.Comment(value={"How you want to see durability? In percentage, damage, or how many damage left"})
        public ArmorView armView = ArmorView.PERCENTAGE;
    }

    public static class PotHUD {
        @Config.Name(value="PotionsHUD ON/OFF")
        public boolean Potions = false;
        @Config.Name(value="PotionHUD orientation")
        @Config.Comment(value={"What orientation should PotionHUD be."})
        public PotOrientation PotOrient = PotOrientation.TOP_LEFT;
        @Config.Name(value="PotionsHUD X position")
        @Config.Comment(value={"Horizontal position of PotionHUD"})
        @Config.RangeInt(min=0)
        public int xPotionPos = 0;
        @Config.Name(value="PotionsHUD Y position")
        @Config.Comment(value={"Vertical position of PotionHUD"})
        @Config.RangeInt(min=0)
        public int yPotionPos = 0;
        @Config.Name(value="Potions Background transparency")
        @Config.Comment(value={"Value from 0 to 100, where 0 is fully invisible"})
        @Config.RangeInt(min=0, max=100)
        public int potAlpha = 100;
    }

    public static class InvHUD {
        @Config.Name(value="InventoryHUD toggle on by default")
        @Config.Comment(value={"Should InventoryHUD be toggled on when you just entered to the world"})
        public boolean byDefault = true;
        @Config.Name(value="InventoryHUD orientation")
        @Config.Comment(value={"What orientation should InventoryHUD be. If it is 'MIDDLE' you can't change position, it always will render above hotbar"})
        public Orientation invOr = Orientation.MIDDLE;
        @Config.Name(value="InventoryHUD X position")
        @Config.Comment(value={"Horizontal position of InventoryHUD"})
        @Config.RangeInt(min=0)
        public int xInvPos = 0;
        @Config.Name(value="InventoryHUD Y position")
        @Config.Comment(value={"Vertical position of InventoryHUD"})
        @Config.RangeInt(min=0)
        public int yInvPos = 0;
    }
}

